/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.MethodAliasInfo;
import org.apache.derby.catalog.types.OldRoutineType;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.IdUtil;

public class RoutineAliasInfo
extends MethodAliasInfo {
    private static final String[] SQL_CONTROL = new String[]{"MODIFIES SQL DATA", "READS SQL DATA", "CONTAINS SQL", "NO SQL"};
    public static final short MODIFIES_SQL_DATA = 0;
    public static final short READS_SQL_DATA = 1;
    public static final short CONTAINS_SQL = 2;
    public static final short NO_SQL = 3;
    public static final short PS_JAVA = 0;
    public static final short PS_DERBY_JDBC_RESULT_SET = 1;
    public static final short PS_DERBY = 2;
    private static final short SQL_ALLOWED_MASK = 15;
    private static final short DETERMINISTIC_MASK = 16;
    private static final short SECURITY_DEFINER_MASK = 32;
    private static final short VARARGS_MASK = 64;
    private int parameterCount;
    private TypeDescriptor[] parameterTypes;
    private String[] parameterNames;
    private int[] parameterModes;
    private int dynamicResultSets;
    private TypeDescriptor returnType;
    private short parameterStyle;
    private short sqlOptions;
    private String specificName;
    private boolean calledOnNullInput;
    private transient char aliasType;

    public RoutineAliasInfo() {
    }

    public RoutineAliasInfo(String string2, int n, String[] stringArray, TypeDescriptor[] typeDescriptorArray, int[] nArray, int n2, short s2, short s3, boolean bl, boolean bl2) {
        this(string2, n, stringArray, typeDescriptorArray, nArray, n2, s2, s3, bl, bl2, false, true, null);
    }

    public RoutineAliasInfo(String string2, int n, String[] stringArray, TypeDescriptor[] typeDescriptorArray, int[] nArray, int n2, short s2, short s3, boolean bl, boolean bl2, boolean bl3, boolean bl4, TypeDescriptor typeDescriptor) {
        super(string2);
        this.parameterCount = n;
        this.parameterNames = stringArray;
        this.parameterTypes = typeDescriptorArray;
        this.parameterModes = nArray;
        this.dynamicResultSets = n2;
        this.parameterStyle = s2;
        this.sqlOptions = (short)(s3 & 0xF);
        if (bl) {
            this.sqlOptions = (short)(this.sqlOptions | 0x10);
        }
        if (bl2) {
            this.sqlOptions = (short)(this.sqlOptions | 0x40);
        }
        if (bl3) {
            this.sqlOptions = (short)(this.sqlOptions | 0x20);
        }
        this.calledOnNullInput = bl4;
        this.returnType = typeDescriptor;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public TypeDescriptor[] getParameterTypes() {
        return this.parameterTypes;
    }

    public int[] getParameterModes() {
        return this.parameterModes;
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public int getMaxDynamicResultSets() {
        return this.dynamicResultSets;
    }

    public short getParameterStyle() {
        return this.parameterStyle;
    }

    public short getSQLAllowed() {
        return (short)(this.sqlOptions & 0xF);
    }

    public boolean isDeterministic() {
        return (this.sqlOptions & 0x10) != 0;
    }

    public boolean hasVarargs() {
        return (this.sqlOptions & 0x40) != 0;
    }

    public boolean hasDefinersRights() {
        return (this.sqlOptions & 0x20) != 0;
    }

    public boolean calledOnNullInput() {
        return this.calledOnNullInput;
    }

    public TypeDescriptor getReturnType() {
        return this.returnType;
    }

    public boolean isTableFunction() {
        if (this.returnType == null) {
            return false;
        }
        return this.returnType.isRowMultiSet();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.specificName = (String)objectInput.readObject();
        this.dynamicResultSets = objectInput.readInt();
        this.parameterCount = objectInput.readInt();
        this.parameterStyle = objectInput.readShort();
        this.sqlOptions = objectInput.readShort();
        this.returnType = RoutineAliasInfo.getStoredType(objectInput.readObject());
        this.calledOnNullInput = objectInput.readBoolean();
        objectInput.readInt();
        if (this.parameterCount != 0) {
            this.parameterNames = new String[this.parameterCount];
            this.parameterTypes = new TypeDescriptor[this.parameterCount];
            ArrayUtil.readArrayItems(objectInput, this.parameterNames);
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                this.parameterTypes[i] = RoutineAliasInfo.getStoredType(objectInput.readObject());
            }
            this.parameterModes = ArrayUtil.readIntArray(objectInput);
        } else {
            this.parameterNames = null;
            this.parameterTypes = null;
            this.parameterModes = null;
        }
    }

    public static TypeDescriptor getStoredType(Object object) {
        if (object instanceof OldRoutineType) {
            return ((OldRoutineType)object).getCatalogType();
        }
        return (TypeDescriptor)object;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.specificName);
        objectOutput.writeInt(this.dynamicResultSets);
        objectOutput.writeInt(this.parameterCount);
        objectOutput.writeShort(this.parameterStyle);
        objectOutput.writeShort(this.sqlOptions);
        objectOutput.writeObject(this.returnType);
        objectOutput.writeBoolean(this.calledOnNullInput);
        objectOutput.writeInt(0);
        if (this.parameterCount != 0) {
            ArrayUtil.writeArrayItems(objectOutput, this.parameterNames);
            ArrayUtil.writeArrayItems(objectOutput, this.parameterTypes);
            ArrayUtil.writeIntArray(objectOutput, this.parameterModes);
        }
    }

    public int getTypeFormatId() {
        return 451;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.getMethodName());
        stringBuffer.append('(');
        for (int i = 0; i < this.parameterCount; ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            if (this.returnType == null) {
                stringBuffer.append(RoutineAliasInfo.parameterMode(this.parameterModes[i]));
                stringBuffer.append(' ');
            }
            stringBuffer.append(IdUtil.normalToDelimited(this.parameterNames[i]));
            stringBuffer.append(' ');
            stringBuffer.append(this.parameterTypes[i].getSQLstring());
        }
        if (this.hasVarargs()) {
            stringBuffer.append(" ... ");
        }
        stringBuffer.append(')');
        if (this.returnType != null) {
            stringBuffer.append(" RETURNS " + this.returnType.getSQLstring());
        }
        stringBuffer.append(" LANGUAGE JAVA PARAMETER STYLE ");
        switch (this.parameterStyle) {
            case 0: {
                stringBuffer.append("JAVA ");
                break;
            }
            case 1: {
                stringBuffer.append("DERBY_JDBC_RESULT_SET ");
                break;
            }
            case 2: {
                stringBuffer.append("DERBY ");
            }
        }
        if (this.isDeterministic()) {
            stringBuffer.append(" DETERMINISTIC ");
        }
        if (this.hasDefinersRights()) {
            stringBuffer.append(" EXTERNAL SECURITY DEFINER ");
        }
        stringBuffer.append(SQL_CONTROL[this.getSQLAllowed()]);
        if (this.returnType == null && this.dynamicResultSets != 0) {
            stringBuffer.append(" DYNAMIC RESULT SETS ");
            stringBuffer.append(this.dynamicResultSets);
        }
        if (this.returnType != null) {
            stringBuffer.append(this.calledOnNullInput ? " CALLED " : " RETURNS NULL ");
            stringBuffer.append("ON NULL INPUT");
        }
        return stringBuffer.toString();
    }

    public static String parameterMode(int n) {
        switch (n) {
            case 1: {
                return "IN";
            }
            case 4: {
                return "OUT";
            }
            case 2: {
                return "INOUT";
            }
        }
        return "UNKNOWN";
    }

    public void setCollationTypeForAllStringTypes(int n) {
        if (this.parameterCount != 0) {
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                this.parameterTypes[i] = DataTypeDescriptor.getCatalogType(this.parameterTypes[i], n);
            }
        }
        if (this.returnType != null) {
            this.returnType = DataTypeDescriptor.getCatalogType(this.returnType, n);
        }
    }
}

