/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.apache.derby.iapi.jdbc.BrokeredStatementControl;
import org.apache.derby.iapi.jdbc.EngineStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokeredStatement
implements EngineStatement {
    final BrokeredStatementControl control;
    final int resultSetType;
    final int resultSetConcurrency;
    final int resultSetHoldability;
    private String cursorName;
    private Boolean escapeProcessing;

    BrokeredStatement(BrokeredStatementControl brokeredStatementControl) throws SQLException {
        this.control = brokeredStatementControl;
        this.resultSetType = this.getResultSetType();
        this.resultSetConcurrency = this.getResultSetConcurrency();
        this.resultSetHoldability = this.getResultSetHoldability();
    }

    @Override
    public final void addBatch(String string2) throws SQLException {
        this.getStatement().addBatch(string2);
    }

    @Override
    public final void clearBatch() throws SQLException {
        this.getStatement().clearBatch();
    }

    @Override
    public final int[] executeBatch() throws SQLException {
        return this.getStatement().executeBatch();
    }

    @Override
    public final void cancel() throws SQLException {
        this.getStatement().cancel();
    }

    @Override
    public final boolean execute(String string2) throws SQLException {
        return this.getStatement().execute(string2);
    }

    @Override
    public final ResultSet executeQuery(String string2) throws SQLException {
        return this.wrapResultSet(this.getStatement().executeQuery(string2));
    }

    @Override
    public final int executeUpdate(String string2) throws SQLException {
        return this.getStatement().executeUpdate(string2);
    }

    @Override
    public void close() throws SQLException {
        this.control.closeRealStatement();
    }

    @Override
    public final Connection getConnection() throws SQLException {
        return this.getStatement().getConnection();
    }

    @Override
    public final int getFetchDirection() throws SQLException {
        return this.getStatement().getFetchDirection();
    }

    @Override
    public final int getFetchSize() throws SQLException {
        return this.getStatement().getFetchSize();
    }

    @Override
    public final int getMaxFieldSize() throws SQLException {
        return this.getStatement().getMaxFieldSize();
    }

    @Override
    public final int getMaxRows() throws SQLException {
        return this.getStatement().getMaxRows();
    }

    @Override
    public final int getResultSetConcurrency() throws SQLException {
        return this.getStatement().getResultSetConcurrency();
    }

    @Override
    public final void setMaxFieldSize(int n) throws SQLException {
        this.getStatement().setMaxFieldSize(n);
    }

    @Override
    public final void setMaxRows(int n) throws SQLException {
        this.getStatement().setMaxRows(n);
    }

    @Override
    public final void setEscapeProcessing(boolean bl) throws SQLException {
        this.getStatement().setEscapeProcessing(bl);
        this.escapeProcessing = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        return this.getStatement().getWarnings();
    }

    @Override
    public final void clearWarnings() throws SQLException {
        this.getStatement().clearWarnings();
    }

    @Override
    public final void setCursorName(String string2) throws SQLException {
        this.getStatement().setCursorName(string2);
        this.cursorName = string2;
    }

    @Override
    public final ResultSet getResultSet() throws SQLException {
        return this.wrapResultSet(this.getStatement().getResultSet());
    }

    @Override
    public final int getUpdateCount() throws SQLException {
        return this.getStatement().getUpdateCount();
    }

    @Override
    public final boolean getMoreResults() throws SQLException {
        return this.getStatement().getMoreResults();
    }

    @Override
    public final int getResultSetType() throws SQLException {
        return this.getStatement().getResultSetType();
    }

    @Override
    public final void setFetchDirection(int n) throws SQLException {
        this.getStatement().setFetchDirection(n);
    }

    @Override
    public final void setFetchSize(int n) throws SQLException {
        this.getStatement().setFetchSize(n);
    }

    @Override
    public final int getQueryTimeout() throws SQLException {
        return this.getStatement().getQueryTimeout();
    }

    @Override
    public final void setQueryTimeout(int n) throws SQLException {
        this.getStatement().setQueryTimeout(n);
    }

    @Override
    public final boolean execute(String string2, int n) throws SQLException {
        return this.getStatement().execute(string2, n);
    }

    @Override
    public final boolean execute(String string2, int[] nArray) throws SQLException {
        return this.getStatement().execute(string2, nArray);
    }

    @Override
    public final boolean execute(String string2, String[] stringArray) throws SQLException {
        return this.getStatement().execute(string2, stringArray);
    }

    @Override
    public final int executeUpdate(String string2, int n) throws SQLException {
        int n2 = this.getStatement().executeUpdate(string2, n);
        return n2;
    }

    @Override
    public final int executeUpdate(String string2, int[] nArray) throws SQLException {
        return this.getStatement().executeUpdate(string2, nArray);
    }

    @Override
    public final int executeUpdate(String string2, String[] stringArray) throws SQLException {
        return this.getStatement().executeUpdate(string2, stringArray);
    }

    @Override
    public final boolean getMoreResults(int n) throws SQLException {
        return ((EngineStatement)this.getStatement()).getMoreResults(n);
    }

    @Override
    public final ResultSet getGeneratedKeys() throws SQLException {
        return this.wrapResultSet(this.getStatement().getGeneratedKeys());
    }

    @Override
    public final int getResultSetHoldability() throws SQLException {
        int n = ((EngineStatement)this.getStatement()).getResultSetHoldability();
        return this.controlCheck().checkHoldCursors(n);
    }

    public Statement createDuplicateStatement(Connection connection, Statement statement) throws SQLException {
        Statement statement2 = connection.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
        this.setStatementState(statement, statement2);
        return statement2;
    }

    void setStatementState(Statement statement, Statement statement2) throws SQLException {
        if (this.cursorName != null) {
            statement2.setCursorName(this.cursorName);
        }
        if (this.escapeProcessing != null) {
            statement2.setEscapeProcessing(this.escapeProcessing);
        }
        statement2.setFetchDirection(statement.getFetchDirection());
        statement2.setFetchSize(statement.getFetchSize());
        statement2.setMaxFieldSize(statement.getMaxFieldSize());
        statement2.setMaxRows(statement.getMaxRows());
        statement2.setQueryTimeout(statement.getQueryTimeout());
    }

    public Statement getStatement() throws SQLException {
        return this.control.getRealStatement();
    }

    final ResultSet wrapResultSet(ResultSet resultSet) {
        return this.control.wrapResultSet(this, resultSet);
    }

    final BrokeredStatementControl controlCheck() throws SQLException {
        this.getStatement().getConnection();
        return this.control;
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        this.checkIfClosed();
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        this.checkIfClosed();
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw this.unableToUnwrap(clazz);
        }
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return ((EngineStatement)this.getStatement()).isClosed();
    }

    protected final void checkIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw this.control.getExceptionFactory().getSQLException("XJ012.S", null, null, new Object[]{"Statement"});
        }
    }

    final SQLException unableToUnwrap(Class clazz) {
        return this.control.getExceptionFactory().getSQLException("XJ128.S", null, null, new Object[]{clazz});
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        ((EngineStatement)this.getStatement()).closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return ((EngineStatement)this.getStatement()).isCloseOnCompletion();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        return ((EngineStatement)this.getStatement()).executeLargeBatch();
    }

    @Override
    public long executeLargeUpdate(String string2) throws SQLException {
        return ((EngineStatement)this.getStatement()).executeLargeUpdate(string2);
    }

    @Override
    public long executeLargeUpdate(String string2, int n) throws SQLException {
        return ((EngineStatement)this.getStatement()).executeLargeUpdate(string2, n);
    }

    @Override
    public long executeLargeUpdate(String string2, int[] nArray) throws SQLException {
        return ((EngineStatement)this.getStatement()).executeLargeUpdate(string2, nArray);
    }

    @Override
    public long executeLargeUpdate(String string2, String[] stringArray) throws SQLException {
        return ((EngineStatement)this.getStatement()).executeLargeUpdate(string2, stringArray);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return ((EngineStatement)this.getStatement()).getLargeMaxRows();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return ((EngineStatement)this.getStatement()).getLargeUpdateCount();
    }

    @Override
    public void setLargeMaxRows(long l) throws SQLException {
        ((EngineStatement)this.getStatement()).setLargeMaxRows(l);
    }
}

