/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.classfile;

import java.io.IOException;
import org.apache.derby.iapi.services.classfile.AttributeEntry;
import org.apache.derby.iapi.services.classfile.Attributes;
import org.apache.derby.iapi.services.classfile.ClassFormatOutput;
import org.apache.derby.iapi.services.classfile.ClassHolder;

public class ClassMember {
    protected ClassHolder cpt;
    protected int access_flags;
    protected int name_index;
    protected int descriptor_index;
    protected Attributes attribute_info;

    ClassMember(ClassHolder classHolder, int n, int n2, int n3) {
        this.cpt = classHolder;
        this.name_index = n2;
        this.descriptor_index = n3;
        this.access_flags = n;
    }

    public int getModifier() {
        return this.access_flags;
    }

    public String getDescriptor() {
        return this.cpt.nameIndexToString(this.descriptor_index);
    }

    public String getName() {
        return this.cpt.nameIndexToString(this.name_index);
    }

    public void addAttribute(String string2, ClassFormatOutput classFormatOutput) {
        if (this.attribute_info == null) {
            this.attribute_info = new Attributes(1);
        }
        this.attribute_info.addEntry(new AttributeEntry(this.cpt.addUtf8(string2), classFormatOutput));
    }

    void put(ClassFormatOutput classFormatOutput) throws IOException {
        classFormatOutput.putU2(this.access_flags);
        classFormatOutput.putU2(this.name_index);
        classFormatOutput.putU2(this.descriptor_index);
        if (this.attribute_info != null) {
            classFormatOutput.putU2(this.attribute_info.size());
            this.attribute_info.put(classFormatOutput);
        } else {
            classFormatOutput.putU2(0);
        }
    }

    int classFileSize() {
        int n = 8;
        if (this.attribute_info != null) {
            n += this.attribute_info.classFileSize();
        }
        return n;
    }
}

