/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io.vfmem;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.derby.impl.io.vfmem.BlockedByteArrayInputStream;
import org.apache.derby.impl.io.vfmem.BlockedByteArrayOutputStream;
import org.apache.derby.impl.io.vfmem.DataStoreEntry;
import org.apache.derby.io.StorageRandomAccessFile;

public class VirtualRandomAccessFile
implements StorageRandomAccessFile {
    private final DataStoreEntry entry;
    private long fp;
    private final BlockedByteArrayInputStream bIn;
    private final DataInputStream dIs;
    private final BlockedByteArrayOutputStream bOut;
    private final DataOutputStream dOs;

    public VirtualRandomAccessFile(DataStoreEntry dataStoreEntry, boolean bl) throws FileNotFoundException {
        this.entry = dataStoreEntry;
        this.bIn = dataStoreEntry.getInputStream();
        this.bIn.setPosition(0L);
        this.dIs = new DataInputStream(this.bIn);
        if (bl) {
            this.bOut = null;
            this.dOs = null;
        } else {
            this.bOut = dataStoreEntry.getOutputStream(true);
            this.bOut.setPosition(0L);
            this.dOs = new DataOutputStream(this.bOut);
        }
    }

    public void close() throws IOException {
        this.dIs.close();
        if (this.dOs != null) {
            this.dOs.close();
        }
        this.fp = Long.MIN_VALUE;
    }

    public long getFilePointer() {
        return this.fp;
    }

    public long length() {
        return this.entry.length();
    }

    public void seek(long l) throws IOException {
        if (l < 0L) {
            throw new IOException("Negative position: " + l);
        }
        this.fp = l;
        this.bIn.setPosition(l);
        if (this.bOut != null) {
            this.bOut.setPosition(l);
        }
    }

    public void setLength(long l) {
        if (this.bOut == null) {
            throw new NullPointerException();
        }
        this.entry.setLength(l);
        if (l < this.fp) {
            this.fp = l;
        }
    }

    public void sync() {
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.bIn.read(byArray, n, n2);
        this.fp = this.bIn.getPosition();
        return n3;
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.dIs.readFully(byArray, n, n2);
        this.fp = this.bIn.getPosition();
    }

    public int skipBytes(int n) {
        if (n <= 0) {
            return 0;
        }
        long l = Math.min((long)n, this.entry.length() - this.fp);
        this.fp += l;
        return (int)l;
    }

    public boolean readBoolean() throws IOException {
        boolean bl = this.dIs.readBoolean();
        this.fp = this.bIn.getPosition();
        return bl;
    }

    public byte readByte() throws IOException {
        byte by = this.dIs.readByte();
        this.fp = this.bIn.getPosition();
        return by;
    }

    public int readUnsignedByte() throws IOException {
        int n = this.dIs.readUnsignedByte();
        this.fp = this.bIn.getPosition();
        return n;
    }

    public short readShort() throws IOException {
        short s2 = this.dIs.readShort();
        this.fp = this.bIn.getPosition();
        return s2;
    }

    public int readUnsignedShort() throws IOException {
        int n = this.dIs.readUnsignedShort();
        this.fp = this.bIn.getPosition();
        return n;
    }

    public char readChar() throws IOException {
        char c = this.dIs.readChar();
        this.fp = this.bIn.getPosition();
        return c;
    }

    public int readInt() throws IOException {
        int n = this.dIs.readInt();
        this.fp = this.bIn.getPosition();
        return n;
    }

    public long readLong() throws IOException {
        long l = this.dIs.readLong();
        this.fp = this.bIn.getPosition();
        return l;
    }

    public float readFloat() throws IOException {
        float f = this.dIs.readFloat();
        this.fp = this.bIn.getPosition();
        return f;
    }

    public double readDouble() throws IOException {
        double d = this.dIs.readDouble();
        this.fp = this.bIn.getPosition();
        return d;
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException("readLine");
    }

    public String readUTF() throws IOException {
        String string2 = this.dIs.readUTF();
        this.fp = this.bIn.getPosition();
        return string2;
    }

    public void write(int n) throws IOException {
        this.dOs.write(n);
        this.fp = this.bOut.getPosition();
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.dOs.write(byArray, n, n2);
        this.fp = this.bOut.getPosition();
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.dOs.writeBoolean(bl);
        this.fp = this.bOut.getPosition();
    }

    public void writeByte(int n) throws IOException {
        this.dOs.writeByte(n);
        this.fp = this.bOut.getPosition();
    }

    public void writeShort(int n) throws IOException {
        this.dOs.writeShort(n);
        this.fp = this.bOut.getPosition();
    }

    public void writeChar(int n) throws IOException {
        this.dOs.writeChar(n);
        this.fp = this.bOut.getPosition();
    }

    public void writeInt(int n) throws IOException {
        this.dOs.writeInt(n);
        this.fp = this.bOut.getPosition();
    }

    public void writeLong(long l) throws IOException {
        this.dOs.writeLong(l);
        this.fp = this.bOut.getPosition();
    }

    public void writeFloat(float f) throws IOException {
        this.dOs.writeFloat(f);
        this.fp = this.bOut.getPosition();
    }

    public void writeDouble(double d) throws IOException {
        this.dOs.writeDouble(d);
        this.fp = this.bOut.getPosition();
    }

    public void writeBytes(String string2) throws IOException {
        this.dOs.writeBytes(string2);
        this.fp = this.bOut.getPosition();
    }

    public void writeChars(String string2) throws IOException {
        this.dOs.writeChars(string2);
        this.fp = this.bOut.getPosition();
    }

    public void writeUTF(String string2) throws IOException {
        this.dOs.writeUTF(string2);
        this.fp = this.bOut.getPosition();
    }
}

