/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.sql.execute.GenericConstantActionFactory;

public class EmbedDatabaseMetaData
extends ConnectionChild
implements DatabaseMetaData,
PrivilegedAction {
    private static final int ILLEGAL_UDT_TYPE = 0;
    private final String url;
    private GenericConstantActionFactory constantActionFactory;
    private static Properties queryDescriptions;
    private static Properties queryDescriptions_net;

    public EmbedDatabaseMetaData(EmbedConnection embedConnection, String string2) throws SQLException {
        super(embedConnection);
        this.url = string2;
    }

    private Properties getQueryDescriptions(boolean bl) {
        Properties properties;
        Properties properties2 = properties = bl ? queryDescriptions_net : queryDescriptions;
        if (properties != null) {
            return properties;
        }
        this.loadQueryDescriptions();
        return bl ? queryDescriptions_net : queryDescriptions;
    }

    private void PBloadQueryDescriptions() {
        String[] stringArray = new String[]{"metadata.properties", "/org/apache/derby/impl/sql/catalog/metadata_net.properties"};
        Properties[] propertiesArray = new Properties[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                propertiesArray[i] = new Properties();
                InputStream inputStream = this.getClass().getResourceAsStream(stringArray[i]);
                propertiesArray[i].load(inputStream);
                inputStream.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        queryDescriptions = propertiesArray[0];
        queryDescriptions_net = propertiesArray[1];
    }

    public boolean allProceduresAreCallable() {
        return true;
    }

    public boolean allTablesAreSelectable() {
        return true;
    }

    public final String getURL() {
        if (this.url == null) {
            return this.url;
        }
        int n = this.url.indexOf(59);
        if (n == -1) {
            return this.url;
        }
        return this.url.substring(0, n);
    }

    public String getUserName() {
        return this.getEmbedConnection().getTR().getUserName();
    }

    public boolean isReadOnly() {
        return this.getLanguageConnectionContext().getDatabase().isReadOnly();
    }

    public boolean nullsAreSortedHigh() {
        return true;
    }

    public boolean nullsAreSortedLow() {
        return false;
    }

    public boolean nullsAreSortedAtStart() {
        return false;
    }

    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    public String getDatabaseProductName() {
        return Monitor.getMonitor().getEngineVersion().getProductName();
    }

    public String getDatabaseProductVersion() {
        ProductVersionHolder productVersionHolder = Monitor.getMonitor().getEngineVersion();
        return productVersionHolder.getVersionBuildString(true);
    }

    public String getDriverName() {
        return "Apache Derby Embedded JDBC Driver";
    }

    public String getDriverVersion() {
        return this.getDatabaseProductVersion();
    }

    public int getDriverMajorVersion() {
        return this.getEmbedConnection().getLocalDriver().getMajorVersion();
    }

    public int getDriverMinorVersion() {
        return this.getEmbedConnection().getLocalDriver().getMinorVersion();
    }

    public boolean usesLocalFiles() {
        return true;
    }

    public boolean usesLocalFilePerTable() {
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() {
        return true;
    }

    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() {
        return true;
    }

    public String getIdentifierQuoteString() {
        return "\"";
    }

    public String getSQLKeywords() {
        return "ALIAS,BIGINT,BOOLEAN,CALL,CLASS,COPY,DB2J_DEBUG,EXECUTE,EXPLAIN,FILE,FILTER,GETCURRENTCONNECTION,INDEX,INSTANCEOF,METHOD,NEW,OFF,PROPERTIES,RECOMPILE,RENAME,RUNTIMESTATISTICS,STATEMENT,STATISTICS,TIMING,WAIT";
    }

    public String getNumericFunctions() {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MOD,PI,RADIANS,RAND,SIGN,SIN,SQRT,TAN";
    }

    public String getStringFunctions() {
        return "CONCAT,LENGTH,LCASE,LOCATE,LTRIM,RTRIM,SUBSTRING,UCASE";
    }

    public String getSystemFunctions() {
        return "USER";
    }

    public String getTimeDateFunctions() {
        return "CURDATE,CURTIME,HOUR,MINUTE,MONTH,SECOND,TIMESTAMPADD,TIMESTAMPDIFF,YEAR";
    }

    public String getSearchStringEscape() {
        return "";
    }

    public String getExtraNameCharacters() {
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    public boolean supportsColumnAliasing() {
        return true;
    }

    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    public boolean supportsConvert() {
        return false;
    }

    public boolean supportsConvert(int n, int n2) {
        return false;
    }

    public boolean supportsTableCorrelationNames() {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() {
        return true;
    }

    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    public boolean supportsOrderByUnrelated() {
        return false;
    }

    public boolean supportsGroupBy() {
        return true;
    }

    public boolean supportsGroupByUnrelated() {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    public boolean supportsLikeEscapeClause() {
        return true;
    }

    public boolean supportsMultipleResultSets() {
        return true;
    }

    public boolean supportsMultipleTransactions() {
        return true;
    }

    public boolean supportsNonNullableColumns() {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    public boolean supportsCoreSQLGrammar() {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    public boolean supportsANSI92FullSQL() {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    public boolean supportsOuterJoins() {
        return true;
    }

    public boolean supportsFullOuterJoins() {
        return false;
    }

    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    public String getSchemaTerm() {
        return "SCHEMA";
    }

    public String getProcedureTerm() {
        return "PROCEDURE";
    }

    public String getCatalogTerm() {
        return "CATALOG";
    }

    public boolean isCatalogAtStart() {
        return false;
    }

    public String getCatalogSeparator() {
        return "";
    }

    public boolean supportsSchemasInDataManipulation() {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    public boolean supportsPositionedDelete() {
        return true;
    }

    public boolean supportsPositionedUpdate() {
        return true;
    }

    public boolean supportsRefCursors() {
        return false;
    }

    public boolean supportsSelectForUpdate() {
        return true;
    }

    public boolean supportsStoredProcedures() {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    public boolean supportsSubqueriesInExists() {
        return true;
    }

    public boolean supportsSubqueriesInIns() {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    public boolean supportsUnion() {
        return true;
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() {
        return false;
    }

    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    public int getMaxCharLiteralLength() {
        return 0;
    }

    public int getMaxColumnNameLength() {
        return 128;
    }

    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    public int getMaxColumnsInIndex() {
        return 0;
    }

    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    public int getMaxColumnsInSelect() {
        return 0;
    }

    public int getMaxColumnsInTable() {
        return 0;
    }

    public int getMaxConnections() {
        return 0;
    }

    public int getMaxCursorNameLength() {
        return 128;
    }

    public int getMaxIndexLength() {
        return 0;
    }

    public long getMaxLogicalLobSize() {
        return 0L;
    }

    public int getMaxSchemaNameLength() {
        return 128;
    }

    public int getMaxProcedureNameLength() {
        return 128;
    }

    public int getMaxCatalogNameLength() {
        return 0;
    }

    public int getMaxRowSize() {
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() {
        return true;
    }

    public int getMaxStatementLength() {
        return 0;
    }

    public int getMaxStatements() {
        return 0;
    }

    public int getMaxTableNameLength() {
        return 128;
    }

    public int getMaxTablesInSelect() {
        return 0;
    }

    public int getMaxUserNameLength() {
        return 128;
    }

    public int getDefaultTransactionIsolation() {
        return 2;
    }

    public boolean supportsTransactions() {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) {
        return n == 8 || n == 4 || n == 2 || n == 1;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    public ResultSet getProcedures(String string2, String string3, String string4) throws SQLException {
        return this.doGetProcs(string2, string3, string4, "getProcedures40");
    }

    public ResultSet getProceduresForODBC(String string2, String string3, String string4) throws SQLException {
        return this.doGetProcs(string2, string3, string4, "odbc_getProcedures");
    }

    public ResultSet getFunctions(String string2, String string3, String string4) throws SQLException {
        return this.doGetProcs(string2, string3, string4, "getFunctions");
    }

    private ResultSet doGetProcs(String string2, String string3, String string4, String string5) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery(string5);
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string4));
        return preparedStatement.executeQuery();
    }

    public ResultSet getProcedureColumns(String string2, String string3, String string4, String string5) throws SQLException {
        return this.doGetProcCols(string2, string3, string4, string5, "getProcedureColumns40");
    }

    public ResultSet getProcedureColumnsForODBC(String string2, String string3, String string4, String string5) throws SQLException {
        return this.doGetProcCols(string2, string3, string4, string5, "odbc_getProcedureColumns");
    }

    public ResultSet getFunctionColumns(String string2, String string3, String string4, String string5) throws SQLException {
        return this.doGetProcCols(string2, string3, string4, string5, "getFunctionColumns");
    }

    private ResultSet doGetProcCols(String string2, String string3, String string4, String string5, String string6) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery(string6);
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string4));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string5));
        return preparedStatement.executeQuery();
    }

    public ResultSet getTables(String string2, String string3, String string4, String[] stringArray) throws SQLException {
        int n;
        PreparedStatement preparedStatement = this.getPreparedQuery("getTables");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string4));
        if (stringArray == null) {
            stringArray = new String[]{"TABLE", "VIEW", "SYNONYM", "SYSTEM TABLE"};
        }
        String[] stringArray2 = new String[4];
        for (n = 0; n < 4; ++n) {
            stringArray2[n] = null;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if ("TABLE".equals(stringArray[n])) {
                stringArray2[0] = "T";
                continue;
            }
            if ("VIEW".equals(stringArray[n])) {
                stringArray2[1] = "V";
                continue;
            }
            if ("SYNONYM".equals(stringArray[n])) {
                stringArray2[2] = "A";
                continue;
            }
            if (!"SYSTEM TABLE".equals(stringArray[n]) && !"SYSTEM_TABLE".equals(stringArray[n])) continue;
            stringArray2[3] = "S";
        }
        for (n = 0; n < 4; ++n) {
            if (stringArray2[n] == null) {
                preparedStatement.setNull(n + 4, 1);
                continue;
            }
            preparedStatement.setString(n + 4, stringArray2[n]);
        }
        return preparedStatement.executeQuery();
    }

    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    public ResultSet getCatalogs() throws SQLException {
        return this.getSimpleQuery("getCatalogs");
    }

    public ResultSet getTableTypes() throws SQLException {
        return this.getSimpleQuery("getTableTypes");
    }

    public ResultSet getColumns(String string2, String string3, String string4, String string5) throws SQLException {
        return this.doGetCols(string2, string3, string4, string5, "getColumns");
    }

    public ResultSet getColumnsForODBC(String string2, String string3, String string4, String string5) throws SQLException {
        return this.doGetCols(string2, string3, string4, string5, "odbc_getColumns");
    }

    private ResultSet doGetCols(String string2, String string3, String string4, String string5, String string6) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery(string6);
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string4));
        preparedStatement.setString(4, EmbedDatabaseMetaData.swapNull(string5));
        return preparedStatement.executeQuery();
    }

    public ResultSet getColumnPrivileges(String string2, String string3, String string4, String string5) throws SQLException {
        if (string4 == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        PreparedStatement preparedStatement = this.getPreparedQuery("getColumnPrivileges");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setString(3, string4);
        preparedStatement.setString(4, EmbedDatabaseMetaData.swapNull(string5));
        return preparedStatement.executeQuery();
    }

    public ResultSet getTablePrivileges(String string2, String string3, String string4) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery("getTablePrivileges");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string4));
        return preparedStatement.executeQuery();
    }

    public ResultSet getBestRowIdentifier(String string2, String string3, String string4, int n, boolean bl) throws SQLException {
        return this.doGetBestRowId(string2, string3, string4, n, bl, "");
    }

    public ResultSet getBestRowIdentifierForODBC(String string2, String string3, String string4, int n, boolean bl) throws SQLException {
        return this.doGetBestRowId(string2, string3, string4, n, bl, "odbc_");
    }

    private ResultSet doGetBestRowId(String string2, String string3, String string4, int n, boolean bl, String string5) throws SQLException {
        if (string4 == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null) {
            string3 = "%";
        }
        if (n < 0 || n > 2) {
            PreparedStatement preparedStatement = this.getPreparedQuery("getBestRowIdentifierEmpty");
            return preparedStatement.executeQuery();
        }
        PreparedStatement preparedStatement = this.getPreparedQuery("getBestRowIdentifierPrimaryKey");
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string3);
        preparedStatement.setString(3, string4);
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl2 = resultSet.next();
        String string6 = "";
        if (bl2) {
            string6 = resultSet.getString(1);
        }
        resultSet.close();
        preparedStatement.close();
        if (bl2) {
            preparedStatement = this.getPreparedQuery(string5 + "getBestRowIdentifierPrimaryKeyColumns");
            preparedStatement.setString(1, string6);
            preparedStatement.setString(2, string6);
            return preparedStatement.executeQuery();
        }
        preparedStatement = this.getPreparedQuery("getBestRowIdentifierUniqueConstraint");
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string3);
        preparedStatement.setString(3, string4);
        resultSet = preparedStatement.executeQuery();
        bl2 = resultSet.next();
        if (bl2) {
            string6 = resultSet.getString(1);
        }
        resultSet.close();
        preparedStatement.close();
        if (bl2) {
            preparedStatement = this.getPreparedQuery(string5 + "getBestRowIdentifierUniqueKeyColumns");
            preparedStatement.setString(1, string6);
            preparedStatement.setString(2, string6);
            preparedStatement.setInt(3, n2);
            return preparedStatement.executeQuery();
        }
        preparedStatement = this.getPreparedQuery("getBestRowIdentifierUniqueIndex");
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string3);
        preparedStatement.setString(3, string4);
        resultSet = preparedStatement.executeQuery();
        bl2 = resultSet.next();
        long l = 0L;
        if (bl2) {
            l = resultSet.getLong(1);
        }
        resultSet.close();
        preparedStatement.close();
        if (bl2) {
            preparedStatement = this.getPreparedQuery(string5 + "getBestRowIdentifierUniqueIndexColumns");
            preparedStatement.setLong(1, l);
            preparedStatement.setInt(2, n2);
            return preparedStatement.executeQuery();
        }
        preparedStatement = this.getPreparedQuery(string5 + "getBestRowIdentifierAllColumns");
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string3);
        preparedStatement.setString(3, string4);
        preparedStatement.setInt(4, n);
        preparedStatement.setInt(5, n2);
        return preparedStatement.executeQuery();
    }

    public ResultSet getVersionColumns(String string2, String string3, String string4) throws SQLException {
        return this.doGetVersionCols(string2, string3, string4, "getVersionColumns");
    }

    public ResultSet getVersionColumnsForODBC(String string2, String string3, String string4) throws SQLException {
        return this.doGetVersionCols(string2, string3, string4, "odbc_getVersionColumns");
    }

    private ResultSet doGetVersionCols(String string2, String string3, String string4, String string5) throws SQLException {
        if (string4 == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        PreparedStatement preparedStatement = this.getPreparedQuery(string5);
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setString(3, string4);
        return preparedStatement.executeQuery();
    }

    private boolean notInSoftUpgradeMode() throws SQLException {
        boolean bl;
        if (this.getEmbedConnection().isClosed()) {
            throw Util.noCurrentConnection();
        }
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        try {
            bl = languageConnectionContext.getDataDictionary().checkVersion(-1, null);
            InterruptStatus.restoreIntrFlagIfSeen();
        }
        catch (Throwable throwable) {
            throw this.handleException(throwable);
        }
        return bl;
    }

    public ResultSet getPrimaryKeys(String string2, String string3, String string4) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery("getPrimaryKeys");
        if (string4 == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setString(3, string4);
        return preparedStatement.executeQuery();
    }

    public ResultSet getImportedKeys(String string2, String string3, String string4) throws SQLException {
        if (string4 == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        PreparedStatement preparedStatement = this.getPreparedQuery("getImportedKeys");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setString(3, string4);
        return preparedStatement.executeQuery();
    }

    public ResultSet getExportedKeys(String string2, String string3, String string4) throws SQLException {
        if (string4 == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        PreparedStatement preparedStatement = this.getPreparedQuery("getCrossReference");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setString(3, string4);
        preparedStatement.setString(4, EmbedDatabaseMetaData.swapNull(null));
        preparedStatement.setString(5, EmbedDatabaseMetaData.swapNull(null));
        preparedStatement.setString(6, EmbedDatabaseMetaData.swapNull(null));
        return preparedStatement.executeQuery();
    }

    public ResultSet getCrossReference(String string2, String string3, String string4, String string5, String string6, String string7) throws SQLException {
        if (string4 == null || string7 == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        PreparedStatement preparedStatement = this.getPreparedQuery("getCrossReference");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setString(3, string4);
        preparedStatement.setString(4, EmbedDatabaseMetaData.swapNull(string5));
        preparedStatement.setString(5, EmbedDatabaseMetaData.swapNull(string6));
        preparedStatement.setString(6, string7);
        return preparedStatement.executeQuery();
    }

    public ResultSet getCrossReferenceForODBC(String string2, String string3, String string4, String string5, String string6, String string7) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery("odbc_getCrossReference");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string4));
        preparedStatement.setString(4, EmbedDatabaseMetaData.swapNull(string5));
        preparedStatement.setString(5, EmbedDatabaseMetaData.swapNull(string6));
        preparedStatement.setString(6, EmbedDatabaseMetaData.swapNull(string7));
        return preparedStatement.executeQuery();
    }

    public ResultSet getTypeInfo() throws SQLException {
        return this.getTypeInfoMinion("getTypeInfo");
    }

    public ResultSet getTypeInfoForODBC() throws SQLException {
        return this.getTypeInfoMinion("odbc_getTypeInfo");
    }

    private ResultSet getTypeInfoMinion(String string2) throws SQLException {
        try {
            boolean bl = this.getLanguageConnectionContext().getDataDictionary().checkVersion(190, null);
            PreparedStatement preparedStatement = this.getPreparedQuery(string2);
            preparedStatement.setBoolean(1, bl);
            return preparedStatement.executeQuery();
        }
        catch (StandardException standardException) {
            throw this.handleException(standardException);
        }
    }

    public ResultSet getIndexInfo(String string2, String string3, String string4, boolean bl, boolean bl2) throws SQLException {
        return this.doGetIndexInfo(string2, string3, string4, bl, bl2, "getIndexInfo");
    }

    public ResultSet getIndexInfoForODBC(String string2, String string3, String string4, boolean bl, boolean bl2) throws SQLException {
        return this.doGetIndexInfo(string2, string3, string4, bl, bl2, "odbc_getIndexInfo");
    }

    private ResultSet doGetIndexInfo(String string2, String string3, String string4, boolean bl, boolean bl2, String string5) throws SQLException {
        if (string4 == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        int n = 0;
        if (bl2) {
            n = 1;
        }
        PreparedStatement preparedStatement = this.getPreparedQuery(string5);
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setString(3, string4);
        preparedStatement.setBoolean(4, bl);
        preparedStatement.setInt(5, n);
        return preparedStatement.executeQuery();
    }

    public boolean supportsResultSetType(int n) {
        return n == 1003 || n == 1004;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) {
        return n != 1005;
    }

    public boolean ownUpdatesAreVisible(int n) {
        return n == 1004;
    }

    public boolean ownDeletesAreVisible(int n) {
        return n == 1004;
    }

    public boolean ownInsertsAreVisible(int n) {
        return false;
    }

    public boolean othersUpdatesAreVisible(int n) {
        return n == 1003;
    }

    public boolean othersDeletesAreVisible(int n) {
        return n == 1003;
    }

    public boolean othersInsertsAreVisible(int n) {
        return n == 1003;
    }

    public boolean updatesAreDetected(int n) {
        return n == 1004;
    }

    public boolean deletesAreDetected(int n) {
        return n == 1004;
    }

    public boolean insertsAreDetected(int n) {
        return false;
    }

    public boolean supportsBatchUpdates() {
        return true;
    }

    public ResultSet getUDTs(String string2, String string3, String string4, int[] nArray) throws SQLException {
        int n = 0;
        if (nArray == null) {
            n = 2000;
        } else if (nArray.length > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != 2000) continue;
                n = 2000;
            }
        }
        PreparedStatement preparedStatement = this.getPreparedQuery("getUDTs");
        preparedStatement.setInt(1, 2000);
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(3, EmbedDatabaseMetaData.swapNull(string3));
        preparedStatement.setString(4, EmbedDatabaseMetaData.swapNull(string4));
        preparedStatement.setInt(5, n);
        return preparedStatement.executeQuery();
    }

    public Connection getConnection() {
        return this.getEmbedConnection().getApplicationConnection();
    }

    public boolean supportsStatementPooling() {
        return false;
    }

    public boolean supportsSavepoints() {
        return true;
    }

    public boolean supportsNamedParameters() {
        return false;
    }

    public boolean supportsMultipleOpenResults() {
        return true;
    }

    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    public boolean supportsResultSetHoldability(int n) {
        return true;
    }

    public int getResultSetHoldability() {
        return 1;
    }

    public int getDatabaseMajorVersion() {
        ProductVersionHolder productVersionHolder = Monitor.getMonitor().getEngineVersion();
        if (productVersionHolder == null) {
            return -1;
        }
        return productVersionHolder.getMajorVersion();
    }

    public int getDatabaseMinorVersion() {
        ProductVersionHolder productVersionHolder = Monitor.getMonitor().getEngineVersion();
        if (productVersionHolder == null) {
            return -1;
        }
        return productVersionHolder.getMinorVersion();
    }

    public int getJDBCMajorVersion() {
        return 3;
    }

    public int getJDBCMinorVersion() {
        return 0;
    }

    public int getSQLStateType() {
        return 2;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    public ResultSet getSuperTypes(String string2, String string3, String string4) throws SQLException {
        return this.getSimpleQuery("getSuperTypes");
    }

    public ResultSet getSuperTables(String string2, String string3, String string4) throws SQLException {
        return this.getSimpleQuery("getSuperTables");
    }

    public ResultSet getAttributes(String string2, String string3, String string4, String string5) throws SQLException {
        return this.getSimpleQuery("getAttributes");
    }

    public ResultSet getClientInfoProperties() throws SQLException {
        return this.getSimpleQuery("getClientInfoProperties");
    }

    public ResultSet getSchemas(String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery("getSchemas");
        preparedStatement.setString(1, EmbedDatabaseMetaData.swapNull(string2));
        preparedStatement.setString(2, EmbedDatabaseMetaData.swapNull(string3));
        return preparedStatement.executeQuery();
    }

    public boolean generatedKeyAlwaysReturned() {
        return true;
    }

    public ResultSet getPseudoColumns(String string2, String string3, String string4, String string5) throws SQLException {
        return this.getSimpleQuery("getPseudoColumns");
    }

    public ResultSet getClientCachedMetaData() throws SQLException {
        return this.getSimpleQuery("METADATA", true);
    }

    private ResultSet getSimpleQuery(String string2, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedQuery(string2, bl);
        if (preparedStatement == null) {
            return null;
        }
        return preparedStatement.executeQuery();
    }

    protected ResultSet getSimpleQuery(String string2) throws SQLException {
        return this.getSimpleQuery(string2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement getPreparedQueryUsingSystemTables(String string2, boolean bl) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            PreparedStatement preparedStatement = null;
            try {
                String string3 = this.getQueryDescriptions(bl).getProperty(string2);
                if (string3 == null) {
                    throw Util.notImplemented(string2);
                }
                preparedStatement = this.prepareSPS(string2, string3, bl);
                InterruptStatus.restoreIntrFlagIfSeen(this.getLanguageConnectionContext());
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
            finally {
                this.restoreContextStack();
            }
            return preparedStatement;
        }
    }

    private PreparedStatement getPreparedQuery(String string2, boolean bl) throws SQLException {
        PreparedStatement preparedStatement;
        if (this.notInSoftUpgradeMode() && !this.isReadOnly()) {
            preparedStatement = this.getPreparedQueryUsingSystemTables(string2, bl);
        } else {
            try {
                String string3 = this.getQueryFromDescription(string2, bl);
                preparedStatement = this.getEmbedConnection().prepareMetaDataStatement(string3);
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
        }
        return preparedStatement;
    }

    protected PreparedStatement getPreparedQuery(String string2) throws SQLException {
        return this.getPreparedQuery(string2, false);
    }

    private String getQueryFromDescription(String string2, boolean bl) throws StandardException {
        DataDictionary dataDictionary = this.getLanguageConnectionContext().getDataDictionary();
        if (!dataDictionary.checkVersion(140, null)) {
            if (string2.equals("getColumnPrivileges")) {
                string2 = "getColumnPrivileges_10_1";
            }
            if (string2.equals("getTablePrivileges")) {
                string2 = "getTablePrivileges_10_1";
            }
        }
        return this.getQueryDescriptions(bl).getProperty(string2);
    }

    private PreparedStatement prepareSPS(String string2, String string3, boolean bl) throws StandardException, SQLException {
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        languageConnectionContext.beginNestedTransaction(true);
        DataDictionary dataDictionary = this.getLanguageConnectionContext().getDataDictionary();
        SPSDescriptor sPSDescriptor = dataDictionary.getSPSDescriptor(string2, bl ? dataDictionary.getSysIBMSchemaDescriptor() : dataDictionary.getSystemSchemaDescriptor());
        languageConnectionContext.commitNestedTransaction();
        if (sPSDescriptor == null) {
            throw Util.notImplemented(string2);
        }
        String string4 = "EXECUTE STATEMENT " + (bl ? "SYSIBM" : "SYS") + ".\"" + string2 + "\"";
        return this.getEmbedConnection().prepareMetaDataStatement(string4);
    }

    protected static final String swapNull(String string2) {
        return string2 == null ? "%" : string2;
    }

    private LanguageConnectionContext getLanguageConnectionContext() {
        return this.getEmbedConnection().getLanguageConnection();
    }

    private void loadQueryDescriptions() {
        AccessController.doPrivileged(this);
    }

    public final Object run() {
        this.PBloadQueryDescriptions();
        return null;
    }
}

