/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Arrays;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.derby.catalog.SystemProcedures;
import org.apache.derby.iapi.error.SQLWarningFactory;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PasswordHasher;
import org.apache.derby.iapi.sql.dictionary.UserDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.jdbc.authentication.AuthenticationServiceBase;
import org.apache.derby.jdbc.InternalDriver;

public final class NativeAuthenticationServiceImpl
extends AuthenticationServiceBase
implements UserAuthenticator {
    private boolean _creatingCredentialsDB = false;
    private String _credentialsDB;
    private boolean _authenticateDatabaseOperationsLocally;
    private long _passwordLifetimeMillis = 2678400000L;
    private double _passwordExpirationThreshold = 0.125;
    private String _badlyFormattedPasswordProperty;

    public boolean canSupport(Properties properties) {
        if (!this.requireAuthentication(properties)) {
            return false;
        }
        if (PropertyUtil.nativeAuthenticationEnabled(properties)) {
            this.parseNativeSpecification(properties);
            return true;
        }
        return false;
    }

    private void parseNativeSpecification(Properties properties) {
        Object object;
        int n;
        String string2 = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.provider");
        this._authenticateDatabaseOperationsLocally = PropertyUtil.localNativeAuthenticationEnabled(properties);
        int n2 = string2.indexOf(":") + 1;
        int n3 = n = this._authenticateDatabaseOperationsLocally ? string2.lastIndexOf(":") : string2.length();
        if (n > n2) {
            this._credentialsDB = string2.substring(n2, n);
            if (this._credentialsDB.length() == 0) {
                this._credentialsDB = null;
            }
        }
        this._badlyFormattedPasswordProperty = null;
        String string3 = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.native.passwordLifetimeMillis");
        if (string3 != null) {
            object = this.parsePasswordLifetime(string3);
            if (object != null) {
                this._passwordLifetimeMillis = (Long)object;
            } else {
                this._badlyFormattedPasswordProperty = "derby.authentication.native.passwordLifetimeMillis";
            }
        }
        if ((object = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.native.passwordLifetimeThreshold")) != null) {
            Double d = this.parsePasswordThreshold((String)object);
            if (d != null) {
                this._passwordExpirationThreshold = d;
            } else {
                this._badlyFormattedPasswordProperty = "derby.authentication.native.passwordLifetimeThreshold";
            }
        }
    }

    private boolean validAuthenticationProvider() throws StandardException {
        boolean bl;
        boolean bl2 = bl = this.getServiceName() == null;
        if (this._credentialsDB != null) {
            if (Monitor.getMonitor().getCanonicalServiceName(this._credentialsDB) == null) {
                throw StandardException.newException("4251L", this._credentialsDB);
            }
            return true;
        }
        if (bl) {
            return false;
        }
        return this._authenticateDatabaseOperationsLocally;
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        super.boot(bl, properties);
        if (!this.validAuthenticationProvider()) {
            throw StandardException.newException("4251H");
        }
        if (this._badlyFormattedPasswordProperty != null) {
            throw StandardException.newException("4251J", this._badlyFormattedPasswordProperty);
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.reset();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw Monitor.exceptionStartingModule(noSuchAlgorithmException);
        }
        this._creatingCredentialsDB = bl && this.authenticatingInThisService(this.getCanonicalServiceName());
        this.setAuthenticationService(this);
    }

    public String getSystemCredentialsDatabaseName() {
        return this._credentialsDB;
    }

    public boolean authenticateUser(String string2, String string3, String string4, Properties properties) throws SQLException {
        try {
            if (string2 == null) {
                return false;
            }
            if (string3 == null) {
                return false;
            }
            if (string4 == null || !this.authenticatingInThisDatabase(string4)) {
                return this.authenticateRemotely(string2, string3, string4);
            }
            return this.authenticateLocally(string2, string3, string4);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
    }

    private boolean authenticatingInThisDatabase(String string2) throws StandardException {
        return this.authenticatingInThisService(Monitor.getMonitor().getCanonicalServiceName(string2));
    }

    private boolean authenticatingInThisService(String string2) throws StandardException {
        if (this._authenticateDatabaseOperationsLocally) {
            return true;
        }
        return this.isCredentialsService(string2);
    }

    private boolean isCredentialsService(String string2) throws StandardException {
        String string3 = this.getCanonicalServiceName(this._credentialsDB);
        String string4 = Monitor.getMonitor().getCanonicalServiceName(string2);
        if (string3 == null) {
            return false;
        }
        return string3.equals(string2);
    }

    private String getCanonicalServiceName() throws StandardException {
        return this.getCanonicalServiceName(this.getServiceName());
    }

    private String getCanonicalServiceName(String string2) throws StandardException {
        return Monitor.getMonitor().getCanonicalServiceName(string2);
    }

    private boolean authenticateRemotely(String string2, String string3, String string4) throws StandardException, SQLWarning {
        if (this._credentialsDB == null) {
            throw StandardException.newException("4251H");
        }
        SQLWarning sQLWarning = null;
        try {
            Properties properties = new Properties();
            properties.setProperty("user", string2);
            properties.setProperty("password", string3);
            String string5 = "jdbc:derby:" + this._credentialsDB;
            Connection connection = InternalDriver.activeDriver().connect(string5, properties, 0);
            sQLWarning = connection.getWarnings();
            connection.close();
        }
        catch (SQLException sQLException) {
            String string6 = sQLException.getSQLState();
            if ("08004".equals(string6)) {
                return false;
            }
            if ("XJ004.C".startsWith(string6)) {
                throw StandardException.newException("4251I", this._credentialsDB);
            }
            throw this.wrap(sQLException);
        }
        if (sQLWarning != null) {
            throw sQLWarning;
        }
        return true;
    }

    private void callDataSourceSetter(DataSource dataSource, String string2, String string3) throws StandardException {
        try {
            dataSource.getClass().getMethod(string2, String.class).invoke((Object)dataSource, string3);
        }
        catch (Exception exception) {
            throw this.wrap(exception);
        }
    }

    private StandardException wrap(Throwable throwable) {
        return StandardException.plainWrapException(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticateLocally(String string2, String string3, String string4) throws StandardException, SQLException {
        string2 = IdUtil.getUserAuthorizationId(string2);
        if (this._creatingCredentialsDB) {
            this._creatingCredentialsDB = false;
            TransactionController transactionController = this.getTransaction();
            SystemProcedures.addUser(string2, string3, transactionController);
            transactionController.commit();
            return true;
        }
        DataDictionary dataDictionary = (DataDictionary)Monitor.getServiceModule(this, "org.apache.derby.iapi.sql.dictionary.DataDictionary");
        UserDescriptor userDescriptor = dataDictionary.getUser(string2);
        if (userDescriptor == null) {
            PasswordHasher passwordHasher = dataDictionary.makePasswordHasher(this.getDatabaseProperties());
            passwordHasher.hashPasswordIntoString(string2, string3).toCharArray();
            return false;
        }
        PasswordHasher passwordHasher = new PasswordHasher(userDescriptor.getHashingScheme());
        char[] cArray = passwordHasher.hashPasswordIntoString(string2, string3).toCharArray();
        char[] cArray2 = userDescriptor.getAndZeroPassword();
        try {
            if (cArray == null || cArray2 == null) {
                boolean bl = false;
                return bl;
            }
            if (cArray.length != cArray2.length) {
                boolean bl = false;
                return bl;
            }
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == cArray2[i]) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (cArray != null) {
                Arrays.fill(cArray, '\u0000');
            }
            if (cArray2 != null) {
                Arrays.fill(cArray2, '\u0000');
            }
        }
        if (this._passwordLifetimeMillis > 0L) {
            long l;
            long l2 = System.currentTimeMillis() - userDescriptor.getLastModified().getTime();
            long l3 = this._passwordLifetimeMillis - l2;
            if (l3 <= 0L) {
                if (!dataDictionary.getAuthorizationDatabaseOwner().equals(string2)) {
                    return false;
                }
                l3 = 0L;
            }
            if (l3 <= (l = (long)((double)this._passwordLifetimeMillis * this._passwordExpirationThreshold))) {
                if (dataDictionary.getAuthorizationDatabaseOwner().equals(string2)) {
                    throw SQLWarningFactory.newSQLWarning("01J16", string4);
                }
                long l4 = l3 / 86400000L;
                throw SQLWarningFactory.newSQLWarning("01J15", Long.toString(l4), string4);
            }
        }
        return true;
    }
}

