/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.util.Locale;
import java.util.Properties;
import org.apache.derby.impl.load.LoadError;

class ControlInfo {
    static final String ESCAPE = "Escape";
    static final String DEFAULT_ESCAPE = "\\";
    static final String QUOTE = "Quote";
    static final String DEFAULT_QUOTE = "'";
    static final String COMMIT_COUNT = "CommitCount";
    static final String DEFAULT_COMMIT_COUNT = "0";
    static final String START_ROW = "StartRow";
    static final String DEFAULT_START_ROW = "1";
    static final String STOP_ROW = "StopRow";
    static final String DEFAULT_STOP_ROW = "0";
    static final String FIELD_SEPARATOR = "FieldSeparator";
    static final String DEFAULT_FIELD_SEPARATOR = ",";
    static final String RECORD_SEPARATOR = "RecordSeparator";
    static final String DEFAULT_RECORD_SEPARATOR = System.getProperty("line.separator");
    static final String COLUMN_DEFINITION = "ColumnDefinition";
    static final String DEFAULT_COLUMN_DEFINITION = "FALSE";
    static final String NULL_STRING = "Null";
    static final String DEFAULT_NULL_STRING = "NULL";
    static final String FORMAT = "Format";
    static final String DEFAULT_FORMAT = "ASCII_DELIMITED";
    static final String DB2_DELIMITED_FORMAT = "DB2_DELIMITED";
    static final String FIELD_START_DELIMITER = "FieldStartDelimiter";
    static final String DEFAULT_FIELD_START_DELIMITER = "\"";
    static final String FIELD_END_DELIMITER = "FieldEndDelimiter";
    static final String DEFAULT_FIELD_END_DELIMITER = "\"";
    static final String COLUMN_WIDTHS = "ColumnWidths";
    static final String MESSAGE_FILE = "MessageFile";
    static final String DEFAULT_VERSION = "1";
    static final String VERSION = "Version";
    static final String NEWLINE = "\n";
    static final String COMMA = ",";
    static final String SPACE = " ";
    static final String TAB = "\t";
    static final String CR = "\r";
    static final String LF = "\n";
    static final String CRLF = "\r\n";
    static final String LFCR = "\n\r";
    static final String FF = "\f";
    static final String EMPTY_LINE = "\n\n";
    static final String SEMICOLON = ";";
    static final String DATA_CODESET = "DataCodeset";
    static final String HAS_DELIMETER_AT_END = "HasDelimeterAtEnd";
    static final String INTERNAL_NONE = "None";
    static final String INTERNAL_TRUE = "True";
    static final String INTERNAL_FALSE = "False";
    static final String INTERNAL_TAB = "Tab";
    static final String INTERNAL_SPACE = "Space";
    static final String INTERNAL_CR = "CR";
    static final String INTERNAL_LF = "LF";
    static final String INTERNAL_CRLF = "CR-LF";
    static final String INTERNAL_LFCR = "LF-CR";
    static final String INTERNAL_COMMA = "Comma";
    static final String INTERNAL_SEMICOLON = "Semicolon";
    static final String INTERNAL_NEWLINE = "New Line";
    static final String INTERNAL_FF = "FF";
    static final String INTERNAL_EMPTY_LINE = "Empty line";
    private Properties currentProperties;

    public ControlInfo() throws Exception {
        this.getCurrentProperties();
        if (this.getFieldSeparator().indexOf(this.getRecordSeparator()) != -1) {
            throw LoadError.fieldAndRecordSeparatorsSubset();
        }
    }

    String getPropertyValue(String string2) throws Exception {
        return this.getCurrentProperties().getProperty(string2);
    }

    private void loadDefaultValues() {
        this.currentProperties = new Properties();
        this.currentProperties.put(FIELD_SEPARATOR, ",");
        this.currentProperties.put(RECORD_SEPARATOR, DEFAULT_RECORD_SEPARATOR);
        this.currentProperties.put(COLUMN_DEFINITION, DEFAULT_COLUMN_DEFINITION);
        this.currentProperties.put(NULL_STRING, DEFAULT_NULL_STRING);
        this.currentProperties.put(FORMAT, DEFAULT_FORMAT);
        this.currentProperties.put(FIELD_START_DELIMITER, "\"");
        this.currentProperties.put(FIELD_END_DELIMITER, "\"");
        this.currentProperties.put(VERSION, "1");
        this.currentProperties.put(HAS_DELIMETER_AT_END, INTERNAL_FALSE);
    }

    String getCurrentVersion() throws Exception {
        return "1";
    }

    String getFormat() throws Exception {
        return this.getCurrentProperties().getProperty(FORMAT);
    }

    int[] getColumnWidths() {
        return null;
    }

    String getFieldSeparator() throws Exception {
        String string2 = this.getCurrentProperties().getProperty(FIELD_SEPARATOR);
        string2 = this.mapFromUserFriendlyFieldDelimiters(string2);
        return string2;
    }

    String getFieldStartDelimiter() throws Exception {
        return this.getCurrentProperties().getProperty(FIELD_START_DELIMITER);
    }

    String getFieldEndDelimiter() throws Exception {
        return this.getCurrentProperties().getProperty(FIELD_END_DELIMITER);
    }

    String getRecordSeparator() throws Exception {
        String string2 = this.getCurrentProperties().getProperty(RECORD_SEPARATOR);
        string2 = this.mapFromUserFriendlyRecordDelimiters(string2);
        return string2;
    }

    boolean getHasDelimiterAtEnd() throws Exception {
        String string2 = this.getCurrentProperties().getProperty(HAS_DELIMETER_AT_END);
        return string2.equals(INTERNAL_TRUE);
    }

    String getHasDelimeterAtEndString() throws Exception {
        String string2 = this.getCurrentProperties().getProperty(HAS_DELIMETER_AT_END);
        return string2;
    }

    String getNullString() throws Exception {
        return this.getCurrentProperties().getProperty(NULL_STRING);
    }

    String getColumnDefinition() throws Exception {
        return this.getCurrentProperties().getProperty(COLUMN_DEFINITION);
    }

    private String mapFromUserFriendlyFieldDelimiters(String string2) {
        if (string2.toUpperCase(Locale.ENGLISH).equals(INTERNAL_TAB.toUpperCase(Locale.ENGLISH))) {
            return TAB;
        }
        if (string2.toUpperCase(Locale.ENGLISH).equals(INTERNAL_SPACE.toUpperCase(Locale.ENGLISH))) {
            return SPACE;
        }
        if (string2.toUpperCase(Locale.ENGLISH).equals(INTERNAL_CR.toUpperCase(Locale.ENGLISH))) {
            return CR;
        }
        if (string2.toUpperCase(Locale.ENGLISH).equals(INTERNAL_LF.toUpperCase(Locale.ENGLISH))) {
            return "\n";
        }
        if (string2.toUpperCase(Locale.ENGLISH).equals(INTERNAL_CRLF.toUpperCase(Locale.ENGLISH))) {
            return CRLF;
        }
        if (string2.toUpperCase(Locale.ENGLISH).equals(INTERNAL_LFCR.toUpperCase(Locale.ENGLISH))) {
            return LFCR;
        }
        if (string2.toUpperCase(Locale.ENGLISH).equals(INTERNAL_COMMA.toUpperCase(Locale.ENGLISH))) {
            return ",";
        }
        if (string2.toUpperCase(Locale.ENGLISH).equals(INTERNAL_SEMICOLON.toUpperCase(Locale.ENGLISH))) {
            return SEMICOLON;
        }
        string2 = this.commonToFieldAndRecordDelimiters(string2, "\\n", '\n');
        string2 = this.commonToFieldAndRecordDelimiters(string2, "\\t", '\t');
        string2 = this.commonToFieldAndRecordDelimiters(string2, "\\r", '\r');
        string2 = this.commonToFieldAndRecordDelimiters(string2, "\\f", '\f');
        return string2;
    }

    private String commonToFieldAndRecordDelimiters(String string2, String string3, char c) {
        while (string2.indexOf(string3) != -1) {
            int n = string2.indexOf(string3);
            String string4 = string2.substring(0, n);
            String string5 = string2.substring(n + 2);
            string2 = string4 + c + string5;
        }
        return string2;
    }

    private String mapFromUserFriendlyRecordDelimiters(String string2) {
        if (string2.equals("\n")) {
            string2 = INTERNAL_NEWLINE;
        }
        if (string2.toUpperCase(Locale.ENGLISH).equals(INTERNAL_NEWLINE.toUpperCase(Locale.ENGLISH))) {
            return "\n";
        }
        if (string2.toUpperCase(Locale.ENGLISH).equals(INTERNAL_CR.toUpperCase(Locale.ENGLISH))) {
            return CR;
        }
        if (string2.toUpperCase(Locale.ENGLISH).equals(INTERNAL_LF.toUpperCase(Locale.ENGLISH))) {
            return "\n";
        }
        if (string2.toUpperCase(Locale.ENGLISH).equals(INTERNAL_CRLF.toUpperCase(Locale.ENGLISH))) {
            return CRLF;
        }
        if (string2.toUpperCase(Locale.ENGLISH).equals(INTERNAL_LFCR.toUpperCase(Locale.ENGLISH))) {
            return LFCR;
        }
        if (string2.toUpperCase(Locale.ENGLISH).equals(INTERNAL_FF.toUpperCase(Locale.ENGLISH))) {
            return FF;
        }
        if (string2.toUpperCase(Locale.ENGLISH).equals(INTERNAL_EMPTY_LINE.toUpperCase(Locale.ENGLISH))) {
            return EMPTY_LINE;
        }
        string2 = this.commonToFieldAndRecordDelimiters(string2, "\\n", '\n');
        string2 = this.commonToFieldAndRecordDelimiters(string2, "\\t", '\t');
        string2 = this.commonToFieldAndRecordDelimiters(string2, "\\r", '\r');
        string2 = this.commonToFieldAndRecordDelimiters(string2, "\\f", '\f');
        return string2;
    }

    String getDataCodeset() throws Exception {
        return this.getCurrentProperties().getProperty(DATA_CODESET);
    }

    Properties getCurrentProperties() throws Exception {
        if (this.currentProperties == null) {
            this.loadDefaultValues();
        }
        return this.currentProperties;
    }

    public void setColumnWidths(String string2) throws Exception {
        if (string2 != null) {
            this.currentProperties.setProperty(COLUMN_WIDTHS, string2);
        }
    }

    public void setFieldSeparator(String string2) throws Exception {
        if (string2 != null) {
            this.currentProperties.setProperty(FIELD_SEPARATOR, string2);
        }
    }

    public void setFieldStartDelimiter(String string2) throws Exception {
        if (string2 != null) {
            this.currentProperties.setProperty(FIELD_START_DELIMITER, string2);
        }
    }

    public void setFieldEndDelimiter(String string2) throws Exception {
        if (string2 != null) {
            this.currentProperties.setProperty(FIELD_END_DELIMITER, string2);
        }
    }

    public void setRecordSeparator(String string2) throws Exception {
        if (string2 != null) {
            this.currentProperties.setProperty(RECORD_SEPARATOR, string2);
        }
    }

    public void setHasDelimiterAtEnd(String string2) throws Exception {
        if (string2 != null) {
            this.currentProperties.setProperty(HAS_DELIMETER_AT_END, string2);
        }
    }

    public void setNullString(String string2) throws Exception {
        if (string2 != null) {
            this.currentProperties.setProperty(NULL_STRING, string2);
        }
    }

    public void setcolumnDefinition(String string2) throws Exception {
        if (string2 != null) {
            this.currentProperties.setProperty(COLUMN_DEFINITION, string2);
        }
    }

    public void setDataCodeset(String string2) throws Exception {
        if (string2 != null) {
            this.currentProperties.setProperty(DATA_CODESET, string2);
        }
    }

    public void setCharacterDelimiter(String string2) throws Exception {
        if (string2 != null) {
            this.setFieldStartDelimiter(string2);
            this.setFieldEndDelimiter(string2);
        }
    }

    public void setControlProperties(String string2, String string3, String string4) throws Exception {
        this.setCharacterDelimiter(string2);
        this.setFieldSeparator(string3);
        this.setDataCodeset(string4);
        this.validateDelimiters();
    }

    private void validateDelimiters() throws Exception {
        char c = this.getFieldSeparator().charAt(0);
        char c2 = this.getFieldStartDelimiter().charAt(0);
        if (c2 == '.') {
            throw LoadError.periodAsCharDelimiterNotAllowed();
        }
        if (c == c2 || c == '.' || Character.isSpaceChar(c) || Character.isSpaceChar(c2) || Character.digit(c, 16) != -1 || Character.digit(c2, 16) != -1) {
            throw LoadError.delimitersAreNotMutuallyExclusive();
        }
    }
}

