/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.lang.reflect.Method;
import java.util.Hashtable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.impl.services.reflect.DirectCall;
import org.apache.derby.impl.services.reflect.LoadedGeneratedClass;
import org.apache.derby.impl.services.reflect.ReflectMethod;

public final class ReflectGeneratedClass
extends LoadedGeneratedClass {
    private final Hashtable methodCache = new Hashtable();
    private static final GeneratedMethod[] directs = new GeneratedMethod[10];

    public ReflectGeneratedClass(ClassFactory classFactory, Class clazz) {
        super(classFactory, clazz);
    }

    public GeneratedMethod getMethod(String string2) throws StandardException {
        GeneratedMethod generatedMethod = (GeneratedMethod)this.methodCache.get(string2);
        if (generatedMethod != null) {
            return generatedMethod;
        }
        try {
            if (string2.length() == 2 && string2.startsWith("e")) {
                int n = string2.charAt(1) - 48;
                generatedMethod = directs[n];
            } else {
                Method method = this.getJVMClass().getMethod(string2, null);
                generatedMethod = new ReflectMethod(method);
            }
            this.methodCache.put(string2, generatedMethod);
            return generatedMethod;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw StandardException.newException("XBCM3.S", noSuchMethodException, (Object)this.getName(), (Object)string2);
        }
    }

    static {
        for (int i = 0; i < directs.length; ++i) {
            ReflectGeneratedClass.directs[i] = new DirectCall(i);
        }
    }
}

