/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.CursorInfo;
import org.apache.derby.impl.sql.CursorTableReference;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class CursorNode
extends DMLStatementNode {
    public static final int UNSPECIFIED = 0;
    public static final int READ_ONLY = 1;
    public static final int UPDATE = 2;
    private String name;
    private OrderByList orderByList;
    private ValueNode offset;
    private ValueNode fetchFirst;
    private boolean hasJDBClimitClause;
    private String statementType;
    private int updateMode;
    private boolean needTarget;
    private List updatableColumns;
    private FromTable updateTable;
    private ResultColumnDescriptor[] targetColumnDescriptors;
    private ArrayList statsToUpdate;
    private boolean checkIndexStats;
    private int indexOfSessionTableNamesInSavedObjects = -1;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        this.init(object2);
        this.name = (String)object3;
        this.statementType = (String)object;
        this.orderByList = (OrderByList)object4;
        this.offset = (ValueNode)object5;
        this.fetchFirst = (ValueNode)object6;
        this.hasJDBClimitClause = object7 == null ? false : (Boolean)object7;
        this.updateMode = (Integer)object8;
        this.updatableColumns = (List)object9;
    }

    public String toString() {
        return "";
    }

    public String statementToString() {
        return this.statementType;
    }

    private static String updateModeString(int n) {
        return "";
    }

    public void printSubNodes(int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindStatement() throws StandardException {
        int n;
        Object object;
        DataDictionary dataDictionary = this.getDataDictionary();
        boolean bl = this.checkIndexStats = dataDictionary.getIndexStatsRefresher(true) != null;
        if (this.orderByList != null) {
            this.orderByList.pullUpOrderByColumns(this.resultSet);
        }
        this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
        try {
            object = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            this.resultSet.rejectParameters();
            super.bind(dataDictionary);
            this.resultSet.bindResultColumns((FromList)object);
            this.resultSet.bindUntypedNullsToResultColumns(null);
            this.resultSet.rejectXMLValues();
            Object var4_4 = null;
            this.getCompilerContext().popCurrentPrivType();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.getCompilerContext().popCurrentPrivType();
            throw throwable;
        }
        this.collectTablesWithPossiblyStaleStats();
        if (this.orderByList != null) {
            this.orderByList.bindOrderByColumns(this.resultSet);
        }
        CursorNode.bindOffsetFetch(this.offset, this.fetchFirst);
        if (this.updateMode == 2 && this.updateMode != (n = this.determineUpdateMode(dataDictionary))) {
            throw StandardException.newException("42Y90");
        }
        if (this.updateMode == 0) {
            this.updateMode = this.getLanguageConnectionContext().getStatementContext().isForReadOnly() ? 1 : this.determineUpdateMode(dataDictionary);
        }
        if (this.updateMode == 1) {
            this.updatableColumns = null;
        }
        if (this.updateMode == 2) {
            this.bindUpdateColumns(this.updateTable);
            if (this.updateTable instanceof FromTable) {
                this.updateTable.markUpdatableByCursor(this.updatableColumns);
                this.resultSet.getResultColumns().markColumnsInSelectListUpdatableByCursor(this.updatableColumns);
            }
        }
        this.resultSet.renameGeneratedResultNames();
        if (this.getLanguageConnectionContext().checkIfAnyDeclaredGlobalTempTablesForThisConnection() && (object = this.getSessionSchemaTableNamesForCursor()) != null) {
            this.indexOfSessionTableNamesInSavedObjects = this.getCompilerContext().addSavedObject(object);
        }
    }

    private void collectTablesWithPossiblyStaleStats() throws StandardException {
        if (!this.checkIndexStats) {
            return;
        }
        FromList fromList = this.resultSet.getFromList();
        for (int i = 0; i < fromList.size(); ++i) {
            TableDescriptor tableDescriptor;
            FromTable fromTable = (FromTable)fromList.elementAt(i);
            if (!fromTable.isBaseTable() || (tableDescriptor = fromTable.getTableDescriptor()).getTableType() != 0) continue;
            if (this.statsToUpdate == null) {
                this.statsToUpdate = new ArrayList();
            }
            this.statsToUpdate.add(tableDescriptor);
        }
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.resultSet.referencesSessionSchema();
    }

    protected ArrayList getSessionSchemaTableNamesForCursor() throws StandardException {
        FromList fromList = this.resultSet.getFromList();
        int n = fromList.size();
        ArrayList<String> arrayList = null;
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)fromList.elementAt(i);
            if (!(fromTable instanceof FromBaseTable) || !this.isSessionSchema(fromTable.getTableDescriptor().getSchemaDescriptor())) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(fromTable.getTableName().getTableName());
        }
        return arrayList;
    }

    private int determineUpdateMode(DataDictionary dataDictionary) throws StandardException {
        if (this.updateMode == 1) {
            return 1;
        }
        if (this.orderByList != null) {
            return 1;
        }
        if (!this.resultSet.isUpdatableCursor(dataDictionary)) {
            return 1;
        }
        this.updateTable = this.resultSet.getCursorTargetTable();
        if (this.updateTable.markAsCursorTargetTable()) {
            this.needTarget = true;
            this.genTargetResultColList();
        }
        return 2;
    }

    public void optimizeStatement() throws StandardException {
        if (this.orderByList != null) {
            if (this.orderByList.size() > 1) {
                this.orderByList.removeDupColumns();
            }
            this.resultSet.pushOrderByList(this.orderByList);
            this.orderByList = null;
        }
        this.resultSet.pushOffsetFetchFirst(this.offset, this.fetchFirst, this.hasJDBClimitClause);
        super.optimizeStatement();
    }

    int activationKind() {
        return 4;
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (this.indexOfSessionTableNamesInSavedObjects != -1) {
            MethodBuilder methodBuilder2 = activationClassBuilder.getConstructor();
            methodBuilder2.pushThis();
            methodBuilder2.push(this.indexOfSessionTableNamesInSavedObjects);
            methodBuilder2.putField("org.apache.derby.impl.sql.execute.BaseActivation", "indexOfSessionTableNamesInSavedObjects", "int");
            methodBuilder2.endStatement();
        }
        this.generateParameterValueSet(activationClassBuilder);
        this.resultSet.markStatementResultSet();
        this.resultSet.generate(activationClassBuilder, methodBuilder);
        if (this.needTarget) {
            activationClassBuilder.rememberCursor(methodBuilder);
            activationClassBuilder.addCursorPositionCode();
        }
    }

    public String getUpdateBaseTableName() {
        return this.updateTable == null ? null : this.updateTable.getBaseTableName();
    }

    public String getUpdateExposedTableName() throws StandardException {
        return this.updateTable == null ? null : this.updateTable.getExposedName();
    }

    public String getUpdateSchemaName() throws StandardException {
        return this.updateTable == null ? null : ((FromBaseTable)this.updateTable).getTableNameField().getSchemaName();
    }

    public int getUpdateMode() {
        return this.updateMode;
    }

    private String[] getUpdatableColumns() {
        return this.updatableColumns == null ? (String[])null : this.getUpdateColumnNames();
    }

    private ResultColumnDescriptor[] genTargetResultColList() throws StandardException {
        if (this.updateTable == null) {
            return null;
        }
        if (this.targetColumnDescriptors != null) {
            return this.targetColumnDescriptors;
        }
        ResultColumnList resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        ResultColumnList resultColumnList2 = this.updateTable.getResultColumns();
        int n = resultColumnList2.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList2.elementAt(i);
            ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(94, resultColumn.getName(), this.makeTableName(resultColumn.getSchemaName(), resultColumn.getTableName()), resultColumn.getTypeServices(), this.getContextManager());
            ResultColumn resultColumn2 = (ResultColumn)this.getNodeFactory().getNode(80, resultColumn.columnDescriptor, valueNode, this.getContextManager());
            resultColumnList.addResultColumn(resultColumn2);
        }
        this.targetColumnDescriptors = resultColumnList.makeResultDescriptors();
        return this.targetColumnDescriptors;
    }

    public boolean needsSavepoint() {
        return false;
    }

    public Object getCursorInfo() throws StandardException {
        if (!this.needTarget) {
            return null;
        }
        return new CursorInfo(this.updateMode, new CursorTableReference(this.getUpdateExposedTableName(), this.getUpdateBaseTableName(), this.getUpdateSchemaName()), this.genTargetResultColList(), this.getUpdatableColumns());
    }

    private void bindUpdateColumns(FromTable fromTable) throws StandardException {
        int n = this.updatableColumns.size();
        ResultColumnList resultColumnList = this.resultSet.getResultColumns();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)this.updatableColumns.get(i);
            TableDescriptor tableDescriptor = fromTable.getTableDescriptor();
            if (tableDescriptor.getColumnDescriptor(string2) == null) {
                throw StandardException.newException("42X04", string2);
            }
            for (int j = 0; j < resultColumnList.size(); ++j) {
                ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(j);
                if (resultColumn.getSourceTableName() == null || resultColumn.getExpression() == null || !resultColumn.getExpression().getColumnName().equals(string2) || resultColumn.getName().equals(string2)) continue;
                throw StandardException.newException("42X42", string2);
            }
        }
    }

    private String[] getUpdateColumnNames() {
        int n = this.updatableColumns.size();
        if (n == 0) {
            return null;
        }
        return this.updatableColumns.toArray(new String[n]);
    }

    public String getXML() {
        return null;
    }

    public TableDescriptor[] updateIndexStatisticsFor() throws StandardException {
        if (!this.checkIndexStats || this.statsToUpdate == null) {
            return EMPTY_TD_LIST;
        }
        for (int i = this.statsToUpdate.size() - 1; i >= 0; --i) {
            TableDescriptor tableDescriptor = (TableDescriptor)this.statsToUpdate.get(i);
            if (!tableDescriptor.getAndClearIndexStatsIsUpToDate()) continue;
            this.statsToUpdate.remove(i);
        }
        if (this.statsToUpdate.isEmpty()) {
            return EMPTY_TD_LIST;
        }
        TableDescriptor[] tableDescriptorArray = new TableDescriptor[this.statsToUpdate.size()];
        this.statsToUpdate.toArray(tableDescriptorArray);
        this.statsToUpdate.clear();
        return tableDescriptorArray;
    }

    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.orderByList != null) {
            this.orderByList.acceptChildren(visitor);
        }
        if (this.offset != null) {
            this.offset.acceptChildren(visitor);
        }
        if (this.fetchFirst != null) {
            this.fetchFirst.acceptChildren(visitor);
        }
    }
}

