/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.compile.TableName;

abstract class DDLStatementNode
extends StatementNode {
    public static final int UNKNOWN_TYPE = 0;
    public static final int ADD_TYPE = 1;
    public static final int DROP_TYPE = 2;
    public static final int MODIFY_TYPE = 3;
    public static final int LOCKING_TYPE = 4;
    public static final int UPDATE_STATISTICS = 5;
    public static final int DROP_STATISTICS = 6;
    private TableName objectName;
    private boolean initOk;
    boolean implicitCreateSchema;

    DDLStatementNode() {
    }

    public void init(Object object) throws StandardException {
        this.initAndCheck(object);
    }

    protected void initAndCheck(Object object) throws StandardException {
        this.objectName = (TableName)object;
        this.initOk = true;
    }

    public boolean isAtomic() {
        return true;
    }

    public String getRelativeName() {
        return this.objectName.getTableName();
    }

    public String getFullName() {
        return this.objectName.getFullTableName();
    }

    public final TableName getObjectName() {
        return this.objectName;
    }

    public String toString() {
        return "";
    }

    int activationKind() {
        return 5;
    }

    public final void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.callMethod((short)185, null, "getDDLResultSet", "org.apache.derby.iapi.sql.ResultSet", 1);
    }

    protected final SchemaDescriptor getSchemaDescriptor() throws StandardException {
        return this.getSchemaDescriptor(true, true);
    }

    protected final SchemaDescriptor getSchemaDescriptor(boolean bl, boolean bl2) throws StandardException {
        String string2 = this.objectName.getSchemaName();
        boolean bl3 = !this.implicitCreateSchema;
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(string2, bl3);
        CompilerContext compilerContext = this.getCompilerContext();
        if (schemaDescriptor == null) {
            if (string2.startsWith("SYS")) {
                throw StandardException.newException("42X62", (Object)this.statementToString(), (Object)string2);
            }
            schemaDescriptor = new SchemaDescriptor(this.getDataDictionary(), string2, null, null, false);
            if (this.isPrivilegeCollectionRequired()) {
                compilerContext.addRequiredSchemaPriv(string2, null, 16);
            }
        }
        if (bl && this.isPrivilegeCollectionRequired()) {
            compilerContext.addRequiredSchemaPriv(schemaDescriptor.getSchemaName(), null, 17);
        }
        if (bl2 && schemaDescriptor.isSystemSchema()) {
            throw StandardException.newException("42X62", (Object)this.statementToString(), (Object)schemaDescriptor);
        }
        return schemaDescriptor;
    }

    protected final TableDescriptor getTableDescriptor() throws StandardException {
        return this.getTableDescriptor(this.objectName);
    }

    protected final TableDescriptor getTableDescriptor(boolean bl) throws StandardException {
        TableDescriptor tableDescriptor = this.justGetDescriptor(this.objectName);
        tableDescriptor = this.checkTableDescriptor(tableDescriptor, bl);
        return tableDescriptor;
    }

    protected final TableDescriptor getTableDescriptor(UUID uUID) throws StandardException {
        TableDescriptor tableDescriptor = this.getDataDictionary().getTableDescriptor(uUID);
        tableDescriptor = this.checkTableDescriptor(tableDescriptor, true);
        return tableDescriptor;
    }

    protected final TableDescriptor getTableDescriptor(TableName tableName) throws StandardException {
        TableDescriptor tableDescriptor = this.justGetDescriptor(tableName);
        tableDescriptor = this.checkTableDescriptor(tableDescriptor, true);
        return tableDescriptor;
    }

    private TableDescriptor justGetDescriptor(TableName tableName) throws StandardException {
        String string2 = tableName.getSchemaName();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(string2);
        TableDescriptor tableDescriptor = this.getTableDescriptor(tableName.getTableName(), schemaDescriptor);
        if (tableDescriptor == null) {
            throw StandardException.newException("42Y55", (Object)this.statementToString(), (Object)tableName);
        }
        return tableDescriptor;
    }

    private TableDescriptor checkTableDescriptor(TableDescriptor tableDescriptor, boolean bl) throws StandardException {
        String string2 = null;
        switch (tableDescriptor.getTableType()) {
            case 5: {
                string2 = "X0Y56.S";
                break;
            }
            case 1: {
                if (bl) {
                    string2 = "X0Y56.S";
                    break;
                }
                return tableDescriptor;
            }
            case 0: {
                return this.lockTableForCompilation(tableDescriptor);
            }
            case 3: {
                return tableDescriptor;
            }
            case 2: {
                string2 = "42Y62";
            }
        }
        throw StandardException.newException(string2, (Object)this.statementToString(), (Object)tableDescriptor.getQualifiedName());
    }

    void bindName(DataDictionary dataDictionary) throws StandardException {
        if (this.objectName != null) {
            this.objectName.bind(dataDictionary);
        }
    }

    FromList makeFromList(DataDictionary dataDictionary, TableElementList tableElementList, boolean bl) throws StandardException {
        TableName tableName = this.getObjectName();
        if (tableName.getSchemaName() == null) {
            tableName.setSchemaName(this.getSchemaDescriptor().getSchemaName());
        }
        FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        FromBaseTable fromBaseTable = (FromBaseTable)this.getNodeFactory().getNode(135, tableName, null, null, null, this.getContextManager());
        if (bl) {
            fromBaseTable.setTableNumber(0);
            fromList.addFromTable(fromBaseTable);
            fromBaseTable.setResultColumns((ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager()));
        } else {
            fromList.addFromTable(fromBaseTable);
            fromList.bindTables(dataDictionary, (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()));
        }
        tableElementList.appendNewColumnsToRCL(fromBaseTable);
        return fromList;
    }
}

