/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.GenericDescriptorList;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.CurrentOfNode;
import org.apache.derby.impl.sql.compile.CurrentRowLocationNode;
import org.apache.derby.impl.sql.compile.DMLModStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UpdateNode;
import org.apache.derby.impl.sql.compile.VTIDeferModPolicy;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.execute.FKInfo;

public class DeleteNode
extends DMLModStatementNode {
    private static final String COLUMNNAME = "###RowLocationToDelete";
    protected boolean deferred;
    protected FromTable targetTable;
    protected FKInfo fkInfo;
    protected FormatableBitSet readColsBitSet;
    private ConstantAction[] dependentConstantActions;
    private boolean cascadeDelete;
    private StatementNode[] dependentNodes;

    public void init(Object object, Object object2) {
        super.init(object2);
        this.targetTableName = (TableName)object;
    }

    public String statementToString() {
        return "DELETE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindStatement() throws StandardException {
        this.getCompilerContext().pushCurrentPrivType(0);
        try {
            int n;
            int n2;
            Object object;
            FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            ResultColumn resultColumn = null;
            TableName tableName = null;
            CurrentOfNode currentOfNode = null;
            DataDictionary dataDictionary = this.getDataDictionary();
            super.bindTables(dataDictionary);
            SelectNode selectNode = (SelectNode)this.resultSet;
            this.targetTable = (FromTable)selectNode.fromList.elementAt(0);
            if (this.targetTable instanceof CurrentOfNode) {
                currentOfNode = (CurrentOfNode)this.targetTable;
                tableName = currentOfNode.getBaseCursorTargetTableName();
            }
            if (this.targetTable instanceof FromVTI) {
                this.targetVTI = (FromVTI)this.targetTable;
                this.targetVTI.setTarget();
            } else if (this.targetTableName == null) {
                this.targetTableName = tableName;
            } else if (tableName != null && !this.targetTableName.equals(tableName)) {
                throw StandardException.newException("42X28", (Object)this.targetTableName, (Object)currentOfNode.getCursorName());
            }
            this.verifyTargetTable();
            if (this.targetTable instanceof FromVTI) {
                this.getResultColumnList();
                this.resultColumnList = this.targetTable.getResultColumnsForList(null, this.resultColumnList, null);
                this.resultSet.setResultColumns(this.resultColumnList);
            } else {
                this.resultColumnList = new ResultColumnList();
                object = this.getResultColumnList(this.resultColumnList);
                this.readColsBitSet = this.getReadMap(dataDictionary, this.targetTableDescriptor);
                this.resultColumnList = ((FromBaseTable)object).addColsToList(this.resultColumnList, this.readColsBitSet);
                n2 = this.targetTableDescriptor.getMaxColumnID();
                for (n = 1; n <= n2 && this.readColsBitSet.get(n); ++n) {
                }
                if (n > n2) {
                    this.readColsBitSet = null;
                }
                CurrentRowLocationNode currentRowLocationNode = (CurrentRowLocationNode)this.getNodeFactory().getNode(2, this.getContextManager());
                resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, COLUMNNAME, currentRowLocationNode, this.getContextManager());
                resultColumn.markGenerated();
                this.resultColumnList.addResultColumn(resultColumn);
                this.correlateAddedColumns(this.resultColumnList, this.targetTable);
                this.resultSet.setResultColumns(this.resultColumnList);
            }
            super.bindExpressions();
            this.resultSet.getResultColumns().bindUntypedNullsToResultColumns(this.resultColumnList);
            if (!(this.targetTable instanceof FromVTI)) {
                resultColumn.bindResultColumnToExpression();
                this.bindConstraints(dataDictionary, this.getNodeFactory(), this.targetTableDescriptor, null, this.resultColumnList, null, this.readColsBitSet, false, true);
                if (this.resultSet.subqueryReferencesTarget(this.targetTableDescriptor.getName(), true) || this.requiresDeferredProcessing()) {
                    this.deferred = true;
                }
            } else {
                this.deferred = VTIDeferModPolicy.deferIt(3, this.targetVTI, null, selectNode.getWhereClause());
            }
            selectNode = null;
            if (this.fkTableNames != null) {
                object = this.targetTableDescriptor.getSchemaName() + "." + this.targetTableDescriptor.getName();
                if (!this.isDependentTable) {
                    this.dependentTables = new HashSet();
                }
                if (this.dependentTables.add(object)) {
                    this.cascadeDelete = true;
                    n = this.fkTableNames.length;
                    this.dependentNodes = new StatementNode[n];
                    for (n2 = 0; n2 < n; ++n2) {
                        this.dependentNodes[n2] = this.getDependentTableNode(this.fkTableNames[n2], this.fkRefActions[n2], this.fkColDescriptors[n2]);
                        this.dependentNodes[n2].bindStatement();
                    }
                }
            } else if (this.isDependentTable) {
                object = this.targetTableDescriptor.getSchemaName() + "." + this.targetTableDescriptor.getName();
                this.dependentTables.add(object);
            }
            if (this.isPrivilegeCollectionRequired()) {
                this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
                this.getCompilerContext().addRequiredTablePriv(this.targetTableDescriptor);
                this.getCompilerContext().popCurrentPrivType();
            }
        }
        finally {
            this.getCompilerContext().popCurrentPrivType();
        }
    }

    int getPrivType() {
        return 4;
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.resultSet.referencesSessionSchema();
    }

    public ConstantAction makeConstantAction() throws StandardException {
        if (this.targetTableDescriptor != null) {
            int n = this.resultSet.updateTargetLockMode();
            long l = this.targetTableDescriptor.getHeapConglomerateId();
            TransactionController transactionController = this.getLanguageConnectionContext().getTransactionCompile();
            StaticCompiledOpenConglomInfo[] staticCompiledOpenConglomInfoArray = new StaticCompiledOpenConglomInfo[this.indexConglomerateNumbers.length];
            for (int i = 0; i < staticCompiledOpenConglomInfoArray.length; ++i) {
                staticCompiledOpenConglomInfoArray[i] = transactionController.getStaticCompiledConglomInfo(this.indexConglomerateNumbers[i]);
            }
            if (this.targetTableDescriptor.getLockGranularity() == 'T') {
                n = 7;
            }
            ResultDescription resultDescription = null;
            if (this.isDependentTable) {
                resultDescription = this.makeResultDescription();
            }
            return this.getGenericConstantActionFactory().getDeleteConstantAction(l, this.targetTableDescriptor.getTableType(), transactionController.getStaticCompiledConglomInfo(l), this.indicesToMaintain, this.indexConglomerateNumbers, staticCompiledOpenConglomInfoArray, this.deferred, false, this.targetTableDescriptor.getUUID(), n, null, null, null, 0L, null, null, resultDescription, this.getFKInfo(), this.getTriggerInfo(), this.readColsBitSet == null ? (FormatableBitSet)null : new FormatableBitSet(this.readColsBitSet), DeleteNode.getReadColMap(this.targetTableDescriptor.getNumberOfColumns(), this.readColsBitSet), this.resultColumnList.getStreamStorableColIds(this.targetTableDescriptor.getNumberOfColumns()), this.readColsBitSet == null ? this.targetTableDescriptor.getNumberOfColumns() : this.readColsBitSet.getNumBitsSet(), null, this.resultSet.isOneRowResultSet(), this.dependentConstantActions);
        }
        return this.getGenericConstantActionFactory().getUpdatableVTIConstantAction(3, this.deferred);
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n;
        String string2;
        int n2;
        String string3;
        this.generateCodeForTemporaryTable(activationClassBuilder);
        if (!this.isDependentTable) {
            this.generateParameterValueSet(activationClassBuilder);
        }
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        activationClassBuilder.newRowLocationScanResultSetName();
        this.resultSet.generate(activationClassBuilder, methodBuilder);
        if (this.targetTableDescriptor != null) {
            activationClassBuilder.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.CursorResultSet", activationClassBuilder.getRowLocationScanResultSetName());
            if (this.cascadeDelete || this.isDependentTable) {
                string3 = "getDeleteCascadeResultSet";
                n2 = 4;
            } else {
                string3 = "getDeleteResultSet";
                n2 = 1;
            }
        } else {
            n2 = 1;
            string3 = "getDeleteVTIResultSet";
        }
        if (this.isDependentTable) {
            methodBuilder.push(activationClassBuilder.addItem(this.makeConstantAction()));
        } else if (this.cascadeDelete) {
            methodBuilder.push(-1);
        }
        String string4 = "org.apache.derby.iapi.sql.ResultSet[]";
        if (this.cascadeDelete) {
            string2 = this.targetTableDescriptor.getSchemaName() + "." + this.targetTableDescriptor.getName();
            LocalField localField = activationClassBuilder.newFieldDeclaration(2, string4);
            methodBuilder.pushNewArray("org.apache.derby.iapi.sql.ResultSet", this.dependentNodes.length);
            methodBuilder.setField(localField);
            for (int i = 0; i < this.dependentNodes.length; ++i) {
                this.dependentNodes[i].setRefActionInfo(this.fkIndexConglomNumbers[i], this.fkColArrays[i], string2, true);
                methodBuilder.getField(localField);
                if (methodBuilder.statementNumHitLimit(10)) {
                    MethodBuilder methodBuilder2 = activationClassBuilder.newGeneratedFun("org.apache.derby.iapi.sql.ResultSet", 2);
                    this.dependentNodes[i].generate(activationClassBuilder, methodBuilder2);
                    methodBuilder2.methodReturn();
                    methodBuilder2.complete();
                    methodBuilder.pushThis();
                    methodBuilder.callMethod((short)182, null, methodBuilder2.getName(), "org.apache.derby.iapi.sql.ResultSet", 0);
                } else {
                    this.dependentNodes[i].generate(activationClassBuilder, methodBuilder);
                }
                methodBuilder.setArrayElement(i);
            }
            methodBuilder.getField(localField);
        } else if (this.isDependentTable) {
            methodBuilder.pushNull(string4);
        }
        if (this.cascadeDelete || this.isDependentTable) {
            string2 = this.targetTableDescriptor.getSchemaName() + "." + this.targetTableDescriptor.getName();
            methodBuilder.push(string2);
        }
        methodBuilder.callMethod((short)185, null, string3, "org.apache.derby.iapi.sql.ResultSet", n2);
        if (!this.isDependentTable && this.cascadeDelete && (n = activationClassBuilder.getRowCount()) > 0) {
            MethodBuilder methodBuilder3 = activationClassBuilder.getConstructor();
            methodBuilder3.pushThis();
            methodBuilder3.pushNewArray("org.apache.derby.iapi.sql.execute.CursorResultSet", n);
            methodBuilder3.putField("org.apache.derby.impl.sql.execute.BaseActivation", "raParentResultSets", "org.apache.derby.iapi.sql.execute.CursorResultSet[]");
            methodBuilder3.endStatement();
        }
    }

    protected final int getStatementType() {
        return 4;
    }

    public FormatableBitSet getReadMap(DataDictionary dataDictionary, TableDescriptor tableDescriptor) throws StandardException {
        boolean[] blArray = new boolean[]{this.requiresDeferredProcessing()};
        ArrayList arrayList = new ArrayList();
        this.relevantTriggers = new GenericDescriptorList();
        FormatableBitSet formatableBitSet = DeleteNode.getDeleteReadMap(tableDescriptor, arrayList, this.relevantTriggers, blArray);
        this.markAffectedIndexes(arrayList);
        this.adjustDeferredFlag(blArray[0]);
        return formatableBitSet;
    }

    private StatementNode getDependentTableNode(String string2, int n, ColumnDescriptorList columnDescriptorList) throws StandardException {
        DMLModStatementNode dMLModStatementNode = null;
        int n2 = string2.indexOf(46);
        String string3 = string2.substring(0, n2);
        String string4 = string2.substring(n2 + 1);
        if (n == 0) {
            dMLModStatementNode = this.getEmptyDeleteNode(string3, string4);
        }
        if (n == 3) {
            dMLModStatementNode = this.getEmptyUpdateNode(string3, string4, columnDescriptorList);
        }
        if (dMLModStatementNode != null) {
            dMLModStatementNode.isDependentTable = true;
            dMLModStatementNode.dependentTables = this.dependentTables;
        }
        return dMLModStatementNode;
    }

    private DeleteNode getEmptyDeleteNode(String string2, String string3) throws StandardException {
        Object var3_3 = null;
        TableName tableName = new TableName();
        tableName.init(string2, string3);
        NodeFactory nodeFactory = this.getNodeFactory();
        FromList fromList = (FromList)nodeFactory.getNode(37, this.getContextManager());
        FromTable fromTable = (FromTable)nodeFactory.getNode(135, tableName, null, ReuseFactory.getInteger(2), null, this.getContextManager());
        FormatableProperties formatableProperties = new FormatableProperties();
        formatableProperties.put("index", "null");
        ((FromBaseTable)fromTable).setTableProperties(formatableProperties);
        fromList.addFromTable(fromTable);
        SelectNode selectNode = (SelectNode)nodeFactory.getNode(129, null, null, fromList, var3_3, null, null, null, this.getContextManager());
        return (DeleteNode)nodeFactory.getNode(101, tableName, selectNode, this.getContextManager());
    }

    private UpdateNode getEmptyUpdateNode(String string2, String string3, ColumnDescriptorList columnDescriptorList) throws StandardException {
        Object var4_4 = null;
        TableName tableName = new TableName();
        tableName.init(string2, string3);
        NodeFactory nodeFactory = this.getNodeFactory();
        FromList fromList = (FromList)nodeFactory.getNode(37, this.getContextManager());
        FromTable fromTable = (FromTable)nodeFactory.getNode(135, tableName, null, ReuseFactory.getInteger(2), null, this.getContextManager());
        FormatableProperties formatableProperties = new FormatableProperties();
        formatableProperties.put("index", "null");
        ((FromBaseTable)fromTable).setTableProperties(formatableProperties);
        fromList.addFromTable(fromTable);
        SelectNode selectNode = (SelectNode)nodeFactory.getNode(129, this.getSetClause(tableName, columnDescriptorList), null, fromList, var4_4, null, null, null, this.getContextManager());
        return (UpdateNode)nodeFactory.getNode(102, tableName, selectNode, this.getContextManager());
    }

    private ResultColumnList getSetClause(TableName tableName, ColumnDescriptorList columnDescriptorList) throws StandardException {
        NodeFactory nodeFactory = this.getNodeFactory();
        ResultColumnList resultColumnList = (ResultColumnList)nodeFactory.getNode(9, this.getContextManager());
        ValueNode valueNode = (ValueNode)nodeFactory.getNode(13, this.getContextManager());
        for (int i = 0; i < columnDescriptorList.size(); ++i) {
            ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(i);
            if (!columnDescriptor.getType().isNullable()) continue;
            ResultColumn resultColumn = (ResultColumn)nodeFactory.getNode(80, columnDescriptor, valueNode, this.getContextManager());
            resultColumnList.addResultColumn(resultColumn);
        }
        return resultColumnList;
    }

    public void optimizeStatement() throws StandardException {
        if (this.cascadeDelete) {
            for (int i = 0; i < this.dependentNodes.length; ++i) {
                this.dependentNodes[i].optimizeStatement();
            }
        }
        super.optimizeStatement();
    }

    private static FormatableBitSet getDeleteReadMap(TableDescriptor tableDescriptor, List list, GenericDescriptorList genericDescriptorList, boolean[] blArray) throws StandardException {
        int n = tableDescriptor.getMaxColumnID();
        FormatableBitSet formatableBitSet = new FormatableBitSet(n + 1);
        DMLModStatementNode.getXAffectedIndexes(tableDescriptor, null, formatableBitSet, list);
        tableDescriptor.getAllRelevantTriggers(4, null, genericDescriptorList);
        if (genericDescriptorList.size() > 0) {
            blArray[0] = true;
            boolean bl = false;
            Iterator iterator = genericDescriptorList.iterator();
            while (iterator.hasNext()) {
                TriggerDescriptor triggerDescriptor = (TriggerDescriptor)iterator.next();
                if (!triggerDescriptor.getReferencingNew() && !triggerDescriptor.getReferencingOld()) continue;
                bl = true;
                break;
            }
            if (bl) {
                for (int i = 1; i <= n; ++i) {
                    formatableBitSet.set(i);
                }
            }
        }
        return formatableBitSet;
    }

    private void correlateAddedColumns(ResultColumnList resultColumnList, FromTable fromTable) throws StandardException {
        String string2 = fromTable.getCorrelationName();
        if (string2 == null) {
            return;
        }
        TableName tableName = this.makeTableName(null, string2);
        int n = resultColumnList.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(i);
            ValueNode valueNode = resultColumn.getExpression();
            if (valueNode == null || !(valueNode instanceof ColumnReference)) continue;
            ColumnReference columnReference = (ColumnReference)valueNode;
            columnReference.setTableNameNode(tableName);
        }
    }
}

