/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.ClassBuilder;
import org.apache.derby.iapi.services.compiler.JavaFactory;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.ExpressionClassBuilderInterface;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.sql.compile.OrderedColumnList;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;

abstract class ExpressionClassBuilder
implements ExpressionClassBuilderInterface {
    protected static final String currentDatetimeFieldName = "cdt";
    protected ClassBuilder cb;
    protected GeneratedClass gc;
    protected int nextExprNum;
    protected int nextNonFastExpr;
    protected int nextFieldNum;
    protected MethodBuilder constructor;
    CompilerContext myCompCtx;
    MethodBuilder executeMethod;
    protected LocalField cdtField;
    private String currentRowScanResultSetName;
    private Object getDVF;
    private Object getRSF;
    private Object getEF;

    ExpressionClassBuilder(String string2, String string3, CompilerContext compilerContext) throws StandardException {
        int n = 17;
        this.myCompCtx = compilerContext;
        JavaFactory javaFactory = this.myCompCtx.getJavaFactory();
        if (string3 == null) {
            string3 = this.myCompCtx.getUniqueClassName();
        }
        this.cb = javaFactory.newClassBuilder(this.myCompCtx.getClassFactory(), this.getPackageName(), n, string3, string2);
        this.beginConstructor();
    }

    abstract String getPackageName();

    abstract int getRowCount() throws StandardException;

    abstract void setNumSubqueries() throws StandardException;

    abstract String getBaseClassName();

    MethodBuilder getConstructor() {
        return this.constructor;
    }

    ClassBuilder getClassBuilder() {
        return this.cb;
    }

    MethodBuilder getExecuteMethod() {
        if (this.executeMethod == null) {
            this.executeMethod = this.cb.newMethodBuilder(4, "void", "reinit");
            this.executeMethod.addThrownException("org.apache.derby.iapi.error.StandardException");
        }
        return this.executeMethod;
    }

    private final void beginConstructor() {
        MethodBuilder methodBuilder = this.cb.newConstructorBuilder(1);
        methodBuilder.callSuper();
        methodBuilder.methodReturn();
        methodBuilder.complete();
        this.constructor = this.cb.newMethodBuilder(1, "void", "postConstructor");
        this.constructor.addThrownException("org.apache.derby.iapi.error.StandardException");
    }

    void finishConstructor() throws StandardException {
        this.setNumSubqueries();
        int n = this.getRowCount();
        if (n >= 1) {
            this.addNewArrayOfRows(n);
        }
        this.constructor.methodReturn();
        this.constructor.complete();
    }

    private void addNewArrayOfRows(int n) {
        this.constructor.pushThis();
        this.constructor.pushNewArray("org.apache.derby.iapi.sql.execute.ExecRow", n);
        this.constructor.putField("org.apache.derby.impl.sql.execute.BaseActivation", "row", "org.apache.derby.iapi.sql.execute.ExecRow[]");
        this.constructor.endStatement();
    }

    LocalField newFieldDeclaration(int n, String string2, String string3) {
        return this.cb.addField(string2, string3, n);
    }

    LocalField newFieldDeclaration(int n, String string2) {
        return this.cb.addField(string2, this.newFieldName(), n);
    }

    MethodBuilder newGeneratedFun(String string2, int n) {
        return this.newGeneratedFun(string2, n, null);
    }

    MethodBuilder newGeneratedFun(String string2, int n, String[] stringArray) {
        String string3 = "g".concat(Integer.toString(this.nextNonFastExpr++));
        return this.newGeneratedFun(string3, string2, n, stringArray);
    }

    private MethodBuilder newGeneratedFun(String string2, String string3, int n, String[] stringArray) {
        MethodBuilder methodBuilder = stringArray == null ? this.cb.newMethodBuilder(n, string3, string2) : this.cb.newMethodBuilder(n, string3, string2, stringArray);
        methodBuilder.addThrownException("org.apache.derby.iapi.error.StandardException");
        return methodBuilder;
    }

    MethodBuilder newExprFun() {
        String string2 = "e".concat(Integer.toString(this.nextExprNum++));
        return this.newGeneratedFun(string2, "java.lang.Object", 1, null);
    }

    void pushMethodReference(MethodBuilder methodBuilder, MethodBuilder methodBuilder2) {
        methodBuilder.pushThis();
        methodBuilder.push(methodBuilder2.getName());
        methodBuilder.callMethod((short)185, "org.apache.derby.iapi.services.loader.GeneratedByteCode", "getMethod", "org.apache.derby.iapi.services.loader.GeneratedMethod", 1);
    }

    MethodBuilder newUserExprFun() {
        MethodBuilder methodBuilder = this.newExprFun();
        methodBuilder.addThrownException("java.lang.Exception");
        return methodBuilder;
    }

    void getCurrentDateExpression(MethodBuilder methodBuilder) {
        LocalField localField = this.getCurrentSetup();
        methodBuilder.getField(localField);
        methodBuilder.callMethod((short)182, null, "getCurrentDate", "java.sql.Date", 0);
    }

    void getCurrentTimeExpression(MethodBuilder methodBuilder) {
        LocalField localField = this.getCurrentSetup();
        methodBuilder.getField(localField);
        methodBuilder.callMethod((short)182, null, "getCurrentTime", "java.sql.Time", 0);
    }

    void getCurrentTimestampExpression(MethodBuilder methodBuilder) {
        LocalField localField = this.getCurrentSetup();
        methodBuilder.getField(localField);
        methodBuilder.callMethod((short)182, null, "getCurrentTimestamp", "java.sql.Timestamp", 0);
    }

    FormatableArrayHolder getColumnOrdering(ResultColumnList resultColumnList) {
        int n;
        int n2 = resultColumnList == null ? 0 : resultColumnList.size();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (resultColumnList.getResultColumn(n + 1).isGeneratedForUnmatchedColumnInInsert()) continue;
            ++n3;
        }
        Object[] objectArray = new IndexColumnOrder[n3];
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            if (resultColumnList.getResultColumn(n + 1).isGeneratedForUnmatchedColumnInInsert()) continue;
            objectArray[n4] = new IndexColumnOrder(n);
            ++n4;
        }
        return new FormatableArrayHolder(objectArray);
    }

    FormatableArrayHolder addColumnToOrdering(FormatableArrayHolder formatableArrayHolder, int n) {
        ColumnOrdering[] columnOrderingArray = (ColumnOrdering[])formatableArrayHolder.getArray(ColumnOrdering.class);
        int n2 = columnOrderingArray.length;
        for (int i = 0; i < n2; ++i) {
            if (columnOrderingArray[i].getColumnId() != n) continue;
            return formatableArrayHolder;
        }
        Object[] objectArray = new IndexColumnOrder[n2 + 1];
        System.arraycopy(columnOrderingArray, 0, objectArray, 0, n2);
        objectArray[n2] = new IndexColumnOrder(n);
        return new FormatableArrayHolder(objectArray);
    }

    FormatableArrayHolder getColumnOrdering(OrderedColumnList orderedColumnList) {
        int n;
        int n2 = n = orderedColumnList == null ? 0 : orderedColumnList.size();
        if (n == 0) {
            return new FormatableArrayHolder(new IndexColumnOrder[0]);
        }
        return new FormatableArrayHolder(orderedColumnList.getColumnOrdering());
    }

    int addItem(Object object) {
        return this.myCompCtx.addSavedObject(object);
    }

    void pushDataValueFactory(MethodBuilder methodBuilder) {
        if (this.getDVF == null) {
            this.getDVF = methodBuilder.describeMethod((short)182, this.getBaseClassName(), "getDataValueFactory", "org.apache.derby.iapi.types.DataValueFactory");
        }
        methodBuilder.pushThis();
        methodBuilder.callMethod(this.getDVF);
    }

    void pushGetResultSetFactoryExpression(MethodBuilder methodBuilder) {
        if (this.getRSF == null) {
            this.getRSF = methodBuilder.describeMethod((short)182, this.getBaseClassName(), "getResultSetFactory", "org.apache.derby.iapi.sql.execute.ResultSetFactory");
        }
        methodBuilder.pushThis();
        methodBuilder.callMethod(this.getRSF);
    }

    void pushGetExecutionFactoryExpression(MethodBuilder methodBuilder) {
        if (this.getEF == null) {
            this.getEF = methodBuilder.describeMethod((short)182, this.getBaseClassName(), "getExecutionFactory", "org.apache.derby.iapi.sql.execute.ExecutionFactory");
        }
        methodBuilder.pushThis();
        methodBuilder.callMethod(this.getEF);
    }

    void pushColumnReference(MethodBuilder methodBuilder, int n, int n2) {
        methodBuilder.pushThis();
        methodBuilder.push(n);
        methodBuilder.push(n2);
        methodBuilder.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "getColumnFromRow", "org.apache.derby.iapi.types.DataValueDescriptor", 2);
    }

    void pushPVSReference(MethodBuilder methodBuilder) {
        methodBuilder.pushThis();
        methodBuilder.getField("org.apache.derby.impl.sql.execute.BaseActivation", "pvs", "org.apache.derby.iapi.sql.ParameterValueSet");
    }

    protected LocalField getCurrentSetup() {
        if (this.cdtField != null) {
            return this.cdtField;
        }
        this.cdtField = this.newFieldDeclaration(2, "org.apache.derby.impl.sql.execute.CurrentDatetime", currentDatetimeFieldName);
        this.constructor.pushNewStart("org.apache.derby.impl.sql.execute.CurrentDatetime");
        this.constructor.pushNewComplete(0);
        this.constructor.setField(this.cdtField);
        return this.cdtField;
    }

    private String newFieldName() {
        return "e".concat(Integer.toString(this.nextFieldNum++));
    }

    protected TypeCompiler getTypeCompiler(TypeId typeId) {
        return this.myCompCtx.getTypeCompilerFactory().getTypeCompiler(typeId);
    }

    GeneratedClass getGeneratedClass(ByteArray byteArray) throws StandardException {
        if (this.gc != null) {
            return this.gc;
        }
        if (byteArray != null) {
            ByteArray byteArray2 = this.cb.getClassBytecode();
            byteArray.setBytes(byteArray2.getArray());
            byteArray.setLength(byteArray2.getLength());
        }
        this.gc = this.cb.getGeneratedClass();
        return this.gc;
    }

    void pushThisAsActivation(MethodBuilder methodBuilder) {
        methodBuilder.pushThis();
        methodBuilder.upCast("org.apache.derby.iapi.sql.Activation");
    }

    void generateNull(MethodBuilder methodBuilder, TypeCompiler typeCompiler, int n) {
        this.pushDataValueFactory(methodBuilder);
        methodBuilder.pushNull(typeCompiler.interfaceName());
        typeCompiler.generateNull(methodBuilder, n);
    }

    void generateNullWithExpress(MethodBuilder methodBuilder, TypeCompiler typeCompiler, int n) {
        this.pushDataValueFactory(methodBuilder);
        methodBuilder.swap();
        methodBuilder.cast(typeCompiler.interfaceName());
        typeCompiler.generateNull(methodBuilder, n);
    }

    void generateDataValue(MethodBuilder methodBuilder, TypeCompiler typeCompiler, int n, LocalField localField) {
        this.pushDataValueFactory(methodBuilder);
        methodBuilder.swap();
        typeCompiler.generateDataValue(methodBuilder, n, localField);
    }

    String newRowLocationScanResultSetName() {
        this.currentRowScanResultSetName = this.newFieldName();
        return this.currentRowScanResultSetName;
    }

    String getRowLocationScanResultSetName() {
        return this.currentRowScanResultSetName;
    }
}

