/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.lang.reflect.Member;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.catalog.types.TypeDescriptorImpl;
import org.apache.derby.catalog.types.UserDefinedTypeIdImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.TypeCompilerFactory;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.JSQLType;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.SQLToJavaValueNode;
import org.apache.derby.impl.sql.compile.SubqueryList;

abstract class MethodCallNode
extends JavaValueNode {
    String methodName;
    String javaClassName;
    RoutineAliasInfo routineInfo;
    boolean internalCall;
    private String[] procedurePrimitiveArrayType;
    protected JSQLType[] signature;
    protected JavaValueNode[] methodParms;
    protected Member method;
    protected String actualMethodReturnType;
    String[] methodParameterTypes;

    MethodCallNode() {
    }

    public void init(Object object) {
        this.methodName = (String)object;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public Member getResolvedMethod() {
        return this.method;
    }

    public RoutineAliasInfo getRoutineInfo() {
        return this.routineInfo;
    }

    public void addParms(List list) throws StandardException {
        this.methodParms = new JavaValueNode[list.size()];
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            QueryTreeNode queryTreeNode = (QueryTreeNode)list.get(i);
            if (!(queryTreeNode instanceof JavaValueNode)) {
                queryTreeNode = (QueryTreeNode)this.getNodeFactory().getNode(28, queryTreeNode, this.getContextManager());
            }
            this.methodParms[i] = (JavaValueNode)queryTreeNode;
        }
    }

    public Class[] getMethodParameterClasses() {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        Class[] classArray = new Class[this.methodParms.length];
        for (int i = 0; i < this.methodParms.length; ++i) {
            String string2 = this.methodParameterTypes[i];
            try {
                classArray[i] = classInspector.getClass(string2);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        return classArray;
    }

    void getCorrelationTables(JBitSet jBitSet) throws StandardException {
        CollectNodesVisitor collectNodesVisitor = new CollectNodesVisitor(ColumnReference.class);
        this.accept(collectNodesVisitor);
        Iterator iterator = collectNodesVisitor.getList().iterator();
        while (iterator.hasNext()) {
            ColumnReference columnReference = (ColumnReference)iterator.next();
            if (!columnReference.getCorrelated()) continue;
            jBitSet.set(columnReference.getTableNumber());
        }
    }

    public void printSubNodes(int n) {
    }

    public String toString() {
        return "";
    }

    final void bindParameters(FromList fromList, SubqueryList subqueryList, List list) throws StandardException {
        if (this.methodParms != null) {
            int n = this.methodParms.length;
            if (this.signature == null) {
                this.signature = new JSQLType[n];
            }
            for (int i = 0; i < n; ++i) {
                if (this.methodParms[i] == null) continue;
                this.methodParms[i] = this.methodParms[i].bindExpression(fromList, subqueryList, list);
                if (this.routineInfo != null) continue;
                this.signature[i] = this.methodParms[i].getJSQLType();
            }
        }
    }

    protected boolean areParametersQueryInvariant() throws StandardException {
        return this.getVariantTypeOfParams() == 2;
    }

    void throwNoMethodFound(String string2, String[] stringArray, String[] stringArray2) throws StandardException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.hasVarargs();
        int n = this.getFirstVarargIdx();
        int n2 = this.signature.length;
        for (int i = 0; i < n2; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            boolean bl2 = this.isVararg(i);
            String string3 = stringArray[i];
            if (stringArray[i].length() == 0) {
                string3 = "UNTYPED";
            } else if (bl2) {
                string3 = this.getVarargTypeName(string3);
            }
            stringBuffer.append(string3);
            if (stringArray2 == null || stringArray2[i].equals(stringArray[i])) continue;
            String string4 = stringArray2[i];
            if (bl2) {
                string4 = this.getVarargTypeName(string4);
            }
            stringBuffer.append("(" + string4 + ")");
        }
        throw StandardException.newException("42X50", (Object)string2, (Object)this.methodName, (Object)stringBuffer);
    }

    private String getVarargTypeName(String string2) {
        return this.stripOneArrayLevel(string2) + "...";
    }

    public void preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        if (this.methodParms != null) {
            for (int i = 0; i < this.methodParms.length; ++i) {
                if (this.methodParms[i] == null) continue;
                this.methodParms[i].preprocess(n, fromList, subqueryList, predicateList);
            }
        }
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        if (bl) {
            return false;
        }
        boolean bl2 = true;
        if (this.methodParms != null) {
            for (int i = 0; i < this.methodParms.length; ++i) {
                if (this.methodParms[i] == null) continue;
                bl2 = this.methodParms[i].categorize(jBitSet, bl) && bl2;
            }
        }
        return bl2;
    }

    public JavaValueNode remapColumnReferencesToExpressions() throws StandardException {
        if (this.methodParms != null) {
            for (int i = 0; i < this.methodParms.length; ++i) {
                if (this.methodParms[i] == null) continue;
                this.methodParms[i] = this.methodParms[i].remapColumnReferencesToExpressions();
            }
        }
        return this;
    }

    public boolean hasVarargs() {
        return this.routineInfo == null ? false : this.routineInfo.hasVarargs();
    }

    public int getFirstVarargIdx() {
        return this.signature.length - 1;
    }

    public boolean isVararg(int n) {
        if (!this.hasVarargs()) {
            return false;
        }
        return n >= this.getFirstVarargIdx();
    }

    public int generateParameters(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n = this.hasVarargs() ? this.routineInfo.getParameterCount() - 1 : this.methodParms.length;
        int n2 = this.hasVarargs() ? n + 1 : n;
        for (int i = 0; i < n; ++i) {
            this.generateAndCastOneParameter(expressionClassBuilder, methodBuilder, i, this.methodParameterTypes[i]);
        }
        if (this.hasVarargs()) {
            this.generateVarargs(expressionClassBuilder, methodBuilder);
        }
        return n2;
    }

    private void generateAndCastOneParameter(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, int n, String string2) throws StandardException {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        this.generateOneParameter(expressionClassBuilder, methodBuilder, n);
        String string3 = MethodCallNode.getParameterTypeName(this.methodParms[n]);
        if (!string2.equals(string3)) {
            if (ClassInspector.primitiveType(string2)) {
                methodBuilder.cast(string2);
            } else {
                if (this.routineInfo != null) {
                    return;
                }
                methodBuilder.upCast(string2);
            }
        }
    }

    private void generateVarargs(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n;
        String string2;
        int n2 = this.getFirstVarargIdx();
        String string3 = this.methodParameterTypes[n2];
        String string4 = string2 = this.stripOneArrayLevel(string3);
        if (this.routineInfo != null && this.routineInfo.getParameterModes()[n2] != 1) {
            string4 = this.stripOneArrayLevel(string4);
        }
        if ((n = this.methodParms.length - n2) < 0) {
            n = 0;
        }
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string3);
        MethodBuilder methodBuilder2 = expressionClassBuilder.getConstructor();
        methodBuilder2.pushNewArray(string2, n);
        methodBuilder2.setField(localField);
        for (int i = 0; i < n; ++i) {
            methodBuilder.getField(localField);
            this.generateAndCastOneParameter(expressionClassBuilder, methodBuilder, i + n2, string2);
            methodBuilder.setArrayElement(i);
        }
        methodBuilder.getField(localField);
    }

    protected int getRoutineArgIdx(int n) {
        if (this.routineInfo == null) {
            return n;
        }
        return this.getRoutineArgIdx(this.routineInfo, n);
    }

    protected int getRoutineArgIdx(RoutineAliasInfo routineAliasInfo, int n) {
        if (!routineAliasInfo.hasVarargs()) {
            return n;
        }
        int n2 = routineAliasInfo.getParameterCount() - 1;
        return n2 < n ? n2 : n;
    }

    public static String getParameterTypeName(JavaValueNode javaValueNode) throws StandardException {
        String string2 = javaValueNode.isPrimitiveType() ? javaValueNode.getPrimitiveTypeName() : javaValueNode.getJavaTypeName();
        return string2;
    }

    public void generateOneParameter(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, int n) throws StandardException {
        this.methodParms[n].generateExpression(expressionClassBuilder, methodBuilder);
    }

    public void setNullParameterInfo(String[] stringArray) throws StandardException {
        for (int i = 0; i < this.methodParms.length; ++i) {
            if (!this.methodParms[i].getJavaTypeName().equals("")) continue;
            DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getSQLDataTypeDescriptor(stringArray[i]);
            ((SQLToJavaValueNode)this.methodParms[i]).value.setType(dataTypeDescriptor);
            this.methodParms[i].setJavaTypeName(stringArray[i]);
            this.signature[i] = this.methodParms[i].getJSQLType();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void resolveMethodCall(String string2, boolean bl) throws StandardException {
        int n;
        int n2;
        String string3;
        String string4;
        String[] stringArray;
        if (this.routineInfo == null && !this.internalCall && (this.getCompilerContext().getReliability() & 0x400) != 0) {
            String string5;
            StringBuffer stringBuffer = new StringBuffer().append(string2);
            if (bl) {
                string5 = "::";
                throw StandardException.newException("42X01", stringBuffer.append(string5).append(this.methodName).toString());
            }
            string5 = ".";
            throw StandardException.newException("42X01", stringBuffer.append(string5).append(this.methodName).toString());
        }
        int n3 = this.signature.length;
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        String[] stringArray2 = null;
        boolean[] blArray = this.getIsParam();
        boolean bl2 = this.hasVarargs() ? false : this.routineInfo != null && n3 != 0 && n3 != this.methodParms.length;
        int n4 = this.methodName.indexOf(40);
        if (n4 != -1) {
            stringArray = this.parseValidateSignature(this.methodName, n4, bl2);
            this.methodName = this.methodName.substring(0, n4);
            bl2 = false;
        } else {
            stringArray = this.getObjectSignature();
        }
        if (this.hasVarargs()) {
            stringArray[n3 - 1] = stringArray[n3 - 1] + "[]";
        }
        try {
            this.method = classInspector.findPublicMethod(string2, this.methodName, stringArray, null, blArray, bl, bl2, this.hasVarargs());
            if (n4 == -1 && this.routineInfo == null && this.method == null) {
                stringArray2 = this.getPrimitiveSignature(false);
                this.method = classInspector.findPublicMethod(string2, this.methodName, stringArray, stringArray2, blArray, bl, bl2, this.hasVarargs());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.method = null;
        }
        if (this.method == null) {
            this.throwNoMethodFound(string2, stringArray, stringArray2);
        }
        this.actualMethodReturnType = string4 = classInspector.getType(this.method);
        if (this.routineInfo == null) {
            if (string4.equals("void") && !this.forCallStatement) {
                throw StandardException.newException("42Y09");
            }
        } else {
            Object object;
            String string6;
            string3 = null;
            TypeDescriptorImpl typeDescriptorImpl = (TypeDescriptorImpl)this.routineInfo.getReturnType();
            if (typeDescriptorImpl == null) {
                string6 = "void";
            } else {
                TypeId typeId = TypeId.getBuiltInTypeId(typeDescriptorImpl.getJDBCTypeId());
                if (typeDescriptorImpl.isRowMultiSet() && this.routineInfo.getParameterStyle() == 1) {
                    string6 = ResultSet.class.getName();
                } else if (typeDescriptorImpl.getTypeId().userType()) {
                    string6 = ((UserDefinedTypeIdImpl)typeDescriptorImpl.getTypeId()).getClassName();
                } else {
                    string6 = typeId.getCorrespondingJavaTypeName();
                    if (!string6.equals(string4)) {
                        switch (typeDescriptorImpl.getJDBCTypeId()) {
                            case -5: 
                            case 4: 
                            case 5: 
                            case 7: 
                            case 8: 
                            case 16: {
                                object = this.getTypeCompiler(typeId);
                                string6 = object.getCorrespondingPrimitiveTypeName();
                                if (this.routineInfo.calledOnNullInput() || this.routineInfo.getParameterCount() == 0) break;
                                string3 = typeId.getCorrespondingJavaTypeName();
                                break;
                            }
                        }
                    }
                }
            }
            if (ResultSet.class.getName().equals(string6)) {
                try {
                    object = classInspector.getClass(string4);
                    n2 = ResultSet.class.isAssignableFrom((Class<?>)object);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    n2 = 0;
                }
            } else {
                n2 = string6.equals(string4);
            }
            if (n2 == 0) {
                this.throwNoMethodFound(string6 + " " + string2, stringArray, stringArray2);
            }
            if (string3 != null) {
                string4 = string3;
            }
            if (this.routineInfo.getReturnType() != null) {
                this.setCollationType(this.routineInfo.getReturnType().getCollationType());
            }
        }
        this.setJavaTypeName(string4);
        this.methodParameterTypes = classInspector.getParameterTypes(this.method);
        string3 = null;
        block12: for (n = 0; n < this.methodParameterTypes.length; ++n) {
            string3 = this.methodParameterTypes[n];
            if (this.routineInfo != null && n < this.routineInfo.getParameterCount()) {
                int n5 = this.routineInfo.getParameterModes()[this.getRoutineArgIdx(n)];
                switch (n5) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        string3 = this.stripOneArrayLevel(string3);
                        break;
                    }
                    case 4: {
                        continue block12;
                    }
                }
            }
            if (this.hasVarargs() && n >= this.getFirstVarargIdx()) {
                string3 = this.stripOneArrayLevel(string3);
            }
            if (!ClassInspector.primitiveType(string3) || n >= this.methodParms.length) continue;
            this.methodParms[n].castToPrimitive(true);
        }
        if (this.hasVarargs()) {
            n = this.getFirstVarargIdx();
            int n6 = this.methodParms.length - n;
            for (n2 = 1; n2 < n6; ++n2) {
                if (!ClassInspector.primitiveType(string3)) continue;
                this.methodParms[n2 + n].castToPrimitive(true);
            }
        }
        if (this.someParametersAreNull()) {
            this.setNullParameterInfo(this.methodParameterTypes);
        }
        DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getSQLDataTypeDescriptor(string4);
        if (!this.getCompilerContext().getReturnParameterFlag()) return;
        this.getCompilerContext().getParameterTypes()[0] = dataTypeDescriptor;
    }

    protected String stripOneArrayLevel(String string2) {
        return string2.substring(0, string2.length() - 2);
    }

    private String[] parseValidateSignature(String string2, int n, boolean bl) throws StandardException {
        String[] stringArray;
        int n2 = string2.length();
        if (n + 1 == n2 || string2.charAt(n2 - 1) != ')') {
            throw StandardException.newException("46J01");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(n + 1, n2 - 1), ",", true);
        String[] stringArray2 = new String[this.signature.length];
        boolean bl2 = false;
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String[] stringArray3;
            Object object;
            stringArray = stringTokenizer.nextToken().trim();
            if (",".equals(stringArray)) {
                if (!bl2) {
                    throw StandardException.newException("46J01");
                }
                bl2 = false;
                continue;
            }
            if (stringArray.length() == 0) {
                throw StandardException.newException("46J01");
            }
            bl2 = true;
            if (++n3 > this.signature.length) {
                if (bl) {
                    object = this.signature[this.signature.length - 1].getSQLType().getTypeId().getCorrespondingJavaTypeName();
                    if (!stringArray.equals(object)) {
                        throw StandardException.newException("22005", (Object)stringArray, object);
                    }
                    if (stringArray2.length == this.signature.length) {
                        stringArray3 = new String[stringTokenizer.countTokens()];
                        System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
                        stringArray2 = stringArray3;
                    }
                    stringArray2[n3 - 1] = stringArray;
                    continue;
                }
                throw StandardException.newException("46J02", (Object)Integer.toString(n3), (Object)Integer.toString(this.signature.length));
            }
            object = this.signature[n3 - 1].getSQLType().getTypeId();
            if (stringArray.equals(((TypeId)object).getCorrespondingJavaTypeName())) {
                stringArray2[n3 - 1] = stringArray;
                continue;
            }
            if ((((TypeId)object).isNumericTypeId() && !((TypeId)object).isDecimalTypeId() || ((TypeId)object).isBooleanTypeId()) && stringArray.equals((stringArray3 = this.getTypeCompiler((TypeId)object)).getCorrespondingPrimitiveTypeName())) {
                stringArray2[n3 - 1] = stringArray;
                continue;
            }
            throw StandardException.newException("22005", (Object)stringArray, (Object)((TypeId)object).getSQLTypeName());
        }
        if (n3 != 0 && !bl2) {
            throw StandardException.newException("46J01");
        }
        if (n3 < stringArray2.length) {
            if (bl && n3 == this.signature.length - 1) {
                stringArray = new String[n3];
                System.arraycopy(stringArray2, 0, stringArray, 0, n3);
                return stringArray;
            }
            throw StandardException.newException("46J02", (Object)Integer.toString(n3), (Object)Integer.toString(this.signature.length));
        }
        return stringArray2;
    }

    protected boolean someParametersAreNull() {
        int n = this.signature.length;
        for (int i = 0; i < n; ++i) {
            if (this.signature[i] != null) continue;
            return true;
        }
        return false;
    }

    protected String[] getObjectSignature() throws StandardException {
        int n = this.signature.length;
        String[] stringArray = new String[n];
        TypeCompilerFactory typeCompilerFactory = this.routineInfo == null ? null : this.getCompilerContext().getTypeCompilerFactory();
        for (int i = 0; i < n; ++i) {
            stringArray[i] = MethodCallNode.getObjectTypeName(this.signature[i], typeCompilerFactory);
        }
        return stringArray;
    }

    protected boolean[] getIsParam() {
        if (this.methodParms == null) {
            return new boolean[0];
        }
        boolean[] blArray = new boolean[this.methodParms.length];
        for (int i = 0; i < this.methodParms.length; ++i) {
            if (!(this.methodParms[i] instanceof SQLToJavaValueNode)) continue;
            SQLToJavaValueNode sQLToJavaValueNode = (SQLToJavaValueNode)this.methodParms[i];
            if (!sQLToJavaValueNode.value.requiresTypeFromContext()) continue;
            blArray[i] = true;
        }
        return blArray;
    }

    static String getObjectTypeName(JSQLType jSQLType, TypeCompilerFactory typeCompilerFactory) throws StandardException {
        if (jSQLType != null) {
            switch (jSQLType.getCategory()) {
                case 0: {
                    TypeId typeId = MethodCallNode.mapToTypeID(jSQLType);
                    if (typeId == null) {
                        return null;
                    }
                    switch (typeId.getJDBCTypeId()) {
                        case -5: 
                        case 4: 
                        case 5: 
                        case 7: 
                        case 8: 
                        case 16: {
                            if (typeCompilerFactory == null) break;
                            return typeCompilerFactory.getTypeCompiler(typeId).getCorrespondingPrimitiveTypeName();
                        }
                    }
                    return typeId.getCorrespondingJavaTypeName();
                }
                case 1: {
                    return jSQLType.getJavaClassName();
                }
                case 2: {
                    return JSQLType.getPrimitiveName(jSQLType.getPrimitiveKind());
                }
            }
        }
        return "";
    }

    String[] getPrimitiveSignature(boolean bl) throws StandardException {
        int n = this.signature.length;
        String[] stringArray = new String[n];
        block5: for (int i = 0; i < n; ++i) {
            JSQLType jSQLType = this.signature[i];
            if (jSQLType == null) {
                stringArray[i] = "";
                continue;
            }
            switch (jSQLType.getCategory()) {
                case 0: {
                    if (this.procedurePrimitiveArrayType != null && i < this.procedurePrimitiveArrayType.length && this.procedurePrimitiveArrayType[i] != null) {
                        stringArray[i] = this.procedurePrimitiveArrayType[i];
                        continue block5;
                    }
                    TypeId typeId = MethodCallNode.mapToTypeID(jSQLType);
                    if (typeId.isNumericTypeId() && !typeId.isDecimalTypeId() || typeId.isBooleanTypeId()) {
                        TypeCompiler typeCompiler = this.getTypeCompiler(typeId);
                        stringArray[i] = typeCompiler.getCorrespondingPrimitiveTypeName();
                        if (!bl) continue block5;
                        this.methodParms[i].castToPrimitive(true);
                        continue block5;
                    }
                    stringArray[i] = typeId.getCorrespondingJavaTypeName();
                    continue block5;
                }
                case 1: {
                    stringArray[i] = jSQLType.getJavaClassName();
                    continue block5;
                }
                case 2: {
                    stringArray[i] = JSQLType.getPrimitiveName(jSQLType.getPrimitiveKind());
                    if (!bl) continue block5;
                    this.methodParms[i].castToPrimitive(true);
                    continue block5;
                }
            }
        }
        return stringArray;
    }

    protected int getOrderableVariantType() throws StandardException {
        return this.getVariantTypeOfParams();
    }

    private int getVariantTypeOfParams() throws StandardException {
        int n = 2;
        if (this.methodParms != null) {
            for (int i = 0; i < this.methodParms.length; ++i) {
                if (this.methodParms[i] != null) {
                    int n2 = this.methodParms[i].getOrderableVariantType();
                    if (n2 >= n) continue;
                    n = n2;
                    continue;
                }
                n = 0;
            }
        }
        return n;
    }

    public DataTypeDescriptor getDataType() throws StandardException {
        TypeDescriptor typeDescriptor;
        if (this.routineInfo != null && (typeDescriptor = this.routineInfo.getReturnType()) != null) {
            return DataTypeDescriptor.getType(typeDescriptor);
        }
        return super.getDataType();
    }

    public JavaValueNode[] getMethodParms() {
        return this.methodParms;
    }

    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        for (int i = 0; !visitor.stopTraversal() && i < this.methodParms.length; ++i) {
            if (this.methodParms[i] == null) continue;
            this.methodParms[i] = (JavaValueNode)this.methodParms[i].accept(visitor);
        }
    }
}

