/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class NormalizeResultSetNode
extends SingleChildResultSetNode {
    private boolean forUpdate;

    public void init(Object object, Object object2, Object object3, Object object4) throws StandardException {
        super.init(object, object3);
        this.forUpdate = (Boolean)object4;
        ResultSetNode resultSetNode = (ResultSetNode)object;
        ResultColumnList resultColumnList = resultSetNode.getResultColumns();
        ResultColumnList resultColumnList2 = (ResultColumnList)object2;
        ResultColumnList resultColumnList3 = resultColumnList;
        resultSetNode.setResultColumns(resultColumnList.copyListAndObjects());
        resultColumnList3.removeGeneratedGroupingColumns();
        resultColumnList3.removeOrderByColumns();
        resultColumnList3.genVirtualColumnNodes(resultSetNode, resultSetNode.getResultColumns());
        this.resultColumns = resultColumnList3;
        if (resultSetNode.getReferencedTableMap() != null) {
            this.setReferencedTableMap((JBitSet)this.getReferencedTableMap().clone());
        }
        if (object2 != null) {
            int n = Math.min(resultColumnList2.size(), this.resultColumns.size());
            for (int i = 0; i < n; ++i) {
                ResultColumn resultColumn = (ResultColumn)this.resultColumns.elementAt(i);
                ResultColumn resultColumn2 = (ResultColumn)resultColumnList2.elementAt(i);
                resultColumn.setType(resultColumn2.getTypeServices());
            }
        }
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.assignResultSetNumber();
        this.costEstimate = this.childResult.getFinalCostEstimate();
        int n = activationClassBuilder.addItem(this.makeResultDescription());
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        this.childResult.generate(activationClassBuilder, methodBuilder);
        methodBuilder.push(this.resultSetNumber);
        methodBuilder.push(n);
        methodBuilder.push(this.costEstimate.rowCount());
        methodBuilder.push(this.costEstimate.getEstimatedCost());
        methodBuilder.push(this.forUpdate);
        methodBuilder.callMethod((short)185, null, "getNormalizeResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 6);
    }

    public void setRefActionInfo(long l, int[] nArray, String string2, boolean bl) {
        this.childResult.setRefActionInfo(l, nArray, string2, bl);
    }

    void pushOrderByList(OrderByList orderByList) {
        this.childResult.pushOrderByList(orderByList);
    }

    void pushOffsetFetchFirst(ValueNode valueNode, ValueNode valueNode2, boolean bl) {
        this.childResult.pushOffsetFetchFirst(valueNode, valueNode2, bl);
    }
}

