/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.FileInfoDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.io.StorageFile;

public class JarUtil {
    private LanguageConnectionContext lcc;
    private String schemaName;
    private String sqlName;
    private FileResource fr;
    private DataDictionary dd;
    private DataDescriptorGenerator ddg;

    private JarUtil(LanguageConnectionContext languageConnectionContext, String string2, String string3) throws StandardException {
        this.schemaName = string2;
        this.sqlName = string3;
        this.lcc = languageConnectionContext;
        this.fr = languageConnectionContext.getTransactionExecute().getFileHandler();
        this.dd = languageConnectionContext.getDataDictionary();
        this.ddg = this.dd.getDataDescriptorGenerator();
    }

    public static long install(LanguageConnectionContext languageConnectionContext, String string2, String string3, String string4) throws StandardException {
        JarUtil jarUtil = new JarUtil(languageConnectionContext, string2, string3);
        InputStream inputStream = null;
        try {
            inputStream = JarUtil.openJarURL(string4);
            long l = jarUtil.add(inputStream);
            return l;
        }
        catch (IOException iOException) {
            throw StandardException.newException("46001", iOException, (Object)string4);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long add(InputStream inputStream) throws StandardException {
        this.dd.startWriting(this.lcc);
        FileInfoDescriptor fileInfoDescriptor = this.getInfo();
        if (fileInfoDescriptor != null) {
            throw StandardException.newException("X0Y32.S", fileInfoDescriptor.getDescriptorType(), (Object)this.sqlName, (Object)fileInfoDescriptor.getSchemaDescriptor().getDescriptorType(), (Object)this.schemaName);
        }
        SchemaDescriptor schemaDescriptor = this.dd.getSchemaDescriptor(this.schemaName, null, true);
        try {
            this.notifyLoader(false);
            this.dd.invalidateAllSPSPlans();
            UUID uUID = Monitor.getMonitor().getUUIDFactory().createUUID();
            String string2 = JarUtil.mkExternalName(uUID, this.schemaName, this.sqlName, this.fr.getSeparatorChar());
            long l = this.setJar(string2, inputStream, true, 0L);
            fileInfoDescriptor = this.ddg.newFileInfoDescriptor(uUID, schemaDescriptor, this.sqlName, l);
            this.dd.addDescriptor(fileInfoDescriptor, schemaDescriptor, 12, false, this.lcc.getTransactionExecute());
            long l2 = l;
            return l2;
        }
        finally {
            this.notifyLoader(true);
        }
    }

    public static void drop(LanguageConnectionContext languageConnectionContext, String string2, String string3) throws StandardException {
        JarUtil jarUtil = new JarUtil(languageConnectionContext, string2, string3);
        jarUtil.drop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drop() throws StandardException {
        Object object;
        this.dd.startWriting(this.lcc);
        FileInfoDescriptor fileInfoDescriptor = this.getInfo();
        if (fileInfoDescriptor == null) {
            throw StandardException.newException("X0X13.S", (Object)this.sqlName, (Object)this.schemaName);
        }
        String string2 = PropertyUtil.getServiceProperty(this.lcc.getTransactionExecute(), "derby.database.classpath");
        if (string2 != null) {
            object = IdUtil.parseDbClassPath(string2);
            boolean bl = false;
            for (int i = 0; i < ((String[][])object).length; ++i) {
                if (((String[][])object).length != 2 || !((String)object[i][0]).equals(this.schemaName) || !((String)object[i][1]).equals(this.sqlName)) continue;
                bl = true;
            }
            if (bl) {
                throw StandardException.newException("X0X07.S", (Object)IdUtil.mkQualifiedName(this.schemaName, this.sqlName), (Object)string2);
            }
        }
        try {
            this.notifyLoader(false);
            this.dd.invalidateAllSPSPlans();
            object = this.dd.getDependencyManager();
            object.invalidateFor(fileInfoDescriptor, 17, this.lcc);
            UUID uUID = fileInfoDescriptor.getUUID();
            this.dd.dropFileInfoDescriptor(fileInfoDescriptor);
            this.fr.remove(JarUtil.mkExternalName(uUID, this.schemaName, this.sqlName, this.fr.getSeparatorChar()), fileInfoDescriptor.getGenerationId());
        }
        finally {
            this.notifyLoader(true);
        }
    }

    public static long replace(LanguageConnectionContext languageConnectionContext, String string2, String string3, String string4) throws StandardException {
        JarUtil jarUtil = new JarUtil(languageConnectionContext, string2, string3);
        InputStream inputStream = null;
        try {
            inputStream = JarUtil.openJarURL(string4);
            long l = jarUtil.replace(inputStream);
            return l;
        }
        catch (IOException iOException) {
            throw StandardException.newException("46001", iOException, (Object)string4);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long replace(InputStream inputStream) throws StandardException {
        this.dd.startWriting(this.lcc);
        FileInfoDescriptor fileInfoDescriptor = this.getInfo();
        if (fileInfoDescriptor == null) {
            throw StandardException.newException("X0X13.S", (Object)this.sqlName, (Object)this.schemaName);
        }
        try {
            this.notifyLoader(false);
            this.dd.invalidateAllSPSPlans();
            this.dd.dropFileInfoDescriptor(fileInfoDescriptor);
            String string2 = JarUtil.mkExternalName(fileInfoDescriptor.getUUID(), this.schemaName, this.sqlName, this.fr.getSeparatorChar());
            long l = this.setJar(string2, inputStream, false, fileInfoDescriptor.getGenerationId());
            FileInfoDescriptor fileInfoDescriptor2 = this.ddg.newFileInfoDescriptor(fileInfoDescriptor.getUUID(), fileInfoDescriptor.getSchemaDescriptor(), this.sqlName, l);
            this.dd.addDescriptor(fileInfoDescriptor2, fileInfoDescriptor.getSchemaDescriptor(), 12, false, this.lcc.getTransactionExecute());
            long l2 = l;
            return l2;
        }
        finally {
            this.notifyLoader(true);
        }
    }

    private FileInfoDescriptor getInfo() throws StandardException {
        SchemaDescriptor schemaDescriptor = this.dd.getSchemaDescriptor(this.schemaName, null, true);
        return this.dd.getFileInfoDescriptor(schemaDescriptor, this.sqlName);
    }

    private void notifyLoader(boolean bl) throws StandardException {
        ClassFactory classFactory = this.lcc.getLanguageConnectionFactory().getClassFactory();
        classFactory.notifyModifyJar(bl);
    }

    private static InputStream openJarURL(final String string2) throws IOException {
        try {
            return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    try {
                        return new URL(string2).openStream();
                    }
                    catch (MalformedURLException malformedURLException) {
                        return new FileInputStream(string2);
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private long setJar(final String string2, final InputStream inputStream, final boolean bl, final long l) throws StandardException {
        try {
            return (Long)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws StandardException {
                    long l2 = bl ? JarUtil.this.fr.add(string2, inputStream) : JarUtil.this.fr.replace(string2, l, inputStream);
                    return new Long(l2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (StandardException)privilegedActionException.getException();
        }
    }

    public static String mkExternalName(UUID uUID, String string2, String string3, char c) throws StandardException {
        return JarUtil.mkExternalNameInternal(uUID, string2, string3, c, false, false);
    }

    private static String mkExternalNameInternal(UUID uUID, String string2, String string3, char c, boolean bl, boolean bl2) throws StandardException {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append("jar");
        stringBuffer.append(c);
        boolean bl3 = false;
        if (!bl) {
            LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)ContextService.getContextOrNull("LanguageConnectionContext");
            bl3 = languageConnectionContext.getDataDictionary().checkVersion(210, null);
        }
        if (!bl && bl3 || bl && bl2) {
            stringBuffer.append(uUID.toString());
            stringBuffer.append(".jar");
        } else {
            stringBuffer.append(string2);
            stringBuffer.append(c);
            stringBuffer.append(string3);
            stringBuffer.append(".jar");
        }
        return stringBuffer.toString();
    }

    public static void upgradeJar(TransactionController transactionController, FileInfoDescriptor fileInfoDescriptor) throws StandardException {
        FileResource fileResource = transactionController.getFileHandler();
        StorageFile storageFile = fileResource.getAsFile(JarUtil.mkExternalNameInternal(fileInfoDescriptor.getUUID(), fileInfoDescriptor.getSchemaDescriptor().getSchemaName(), fileInfoDescriptor.getName(), File.separatorChar, true, false), fileInfoDescriptor.getGenerationId());
        StorageFile storageFile2 = fileResource.getAsFile(JarUtil.mkExternalNameInternal(fileInfoDescriptor.getUUID(), fileInfoDescriptor.getSchemaDescriptor().getSchemaName(), fileInfoDescriptor.getName(), File.separatorChar, true, true), fileInfoDescriptor.getGenerationId());
        FileUtil.copyFile(new File(storageFile.getPath()), new File(storageFile2.getPath()), null);
    }
}

