/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.jdbc.JDBCBoot;
import org.apache.derby.jdbc.AutoloadedDriver;

public class EmbeddedDriver
implements Driver {
    public EmbeddedDriver() {
        EmbeddedDriver.boot();
    }

    public boolean acceptsURL(String string2) throws SQLException {
        return this.getDriverModule().acceptsURL(string2);
    }

    public Connection connect(String string2, Properties properties) throws SQLException {
        return this.getDriverModule().connect(string2, properties);
    }

    public DriverPropertyInfo[] getPropertyInfo(String string2, Properties properties) throws SQLException {
        return this.getDriverModule().getPropertyInfo(string2, properties);
    }

    public int getMajorVersion() {
        try {
            return this.getDriverModule().getMajorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public int getMinorVersion() {
        try {
            return this.getDriverModule().getMinorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public boolean jdbcCompliant() {
        try {
            return this.getDriverModule().jdbcCompliant();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    private Driver getDriverModule() throws SQLException {
        return AutoloadedDriver.getDriverModule();
    }

    static void boot() {
        PrintWriter printWriter = DriverManager.getLogWriter();
        if (printWriter == null) {
            printWriter = new PrintWriter(System.err, true);
        }
        new JDBCBoot().boot("jdbc:derby:", printWriter);
    }

    static {
        EmbeddedDriver.boot();
    }
}

