/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.security.AccessControlException;
import java.security.Permission;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.services.jmx.ManagementService;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedDatabaseMetaData;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.JDBC;
import org.apache.derby.mbeans.JDBCMBean;
import org.apache.derby.security.SystemPermission;

public abstract class InternalDriver
implements ModuleControl {
    private static final Object syncMe = new Object();
    private static InternalDriver activeDriver;
    private Object mbean;
    protected boolean active;
    private ContextService contextServiceFactory = ContextService.getFactory();
    private AuthenticationService authenticationService;
    private static boolean deregister;

    public static final InternalDriver activeDriver() {
        return activeDriver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void boot(boolean bl, Properties properties) throws StandardException {
        Object object = syncMe;
        synchronized (object) {
            activeDriver = this;
        }
        this.active = true;
        this.mbean = ((ManagementService)Monitor.getSystemModule("org.apache.derby.iapi.services.jmx.ManagementService")).registerMBean(new JDBC(this), JDBCMBean.class, "type=JDBC");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = syncMe;
        synchronized (object) {
            activeDriver = null;
        }
        ((ManagementService)Monitor.getSystemModule("org.apache.derby.iapi.services.jmx.ManagementService")).unregisterMBean(this.mbean);
        this.active = false;
        this.contextServiceFactory = null;
    }

    public boolean acceptsURL(String string2) throws SQLException {
        return this.active && InternalDriver.embeddedDriverAcceptsURL(string2);
    }

    public static boolean embeddedDriverAcceptsURL(String string2) throws SQLException {
        if (string2 == null) {
            throw Util.generateCsSQLException("XJ028.C", "null");
        }
        return !string2.startsWith("jdbc:derby:net:") && !string2.startsWith("jdbc:derby://") && (string2.startsWith("jdbc:derby:") || string2.equals("jdbc:default:connection"));
    }

    public Connection connect(String string2, Properties properties, int n) throws SQLException {
        if (!this.acceptsURL(string2)) {
            return null;
        }
        if (EmbedConnection.memoryState.isLowMemory()) {
            throw EmbedConnection.NO_MEM;
        }
        boolean bl = string2.equals("jdbc:default:connection");
        if (bl) {
            ConnectionContext connectionContext = this.getConnectionContext();
            if (connectionContext != null) {
                return connectionContext.getNestedConnection(false);
            }
            return null;
        }
        FormatableProperties formatableProperties = null;
        try {
            formatableProperties = this.getAttributes(string2, properties);
            properties = null;
            boolean bl2 = Boolean.valueOf(formatableProperties.getProperty("shutdown"));
            if (bl2 && InternalDriver.getDatabaseName(string2, formatableProperties).length() == 0) {
                if (this.getAuthenticationService() == null) {
                    throw Util.generateCsSQLException("08004", MessageService.getTextMessage("A001"));
                }
                if (!this.getAuthenticationService().authenticate(null, formatableProperties)) {
                    throw Util.generateCsSQLException("08004.C.1", MessageService.getTextMessage("A020"));
                }
                if (formatableProperties.getProperty("deregister") != null) {
                    boolean bl3 = Boolean.valueOf(formatableProperties.getProperty("deregister"));
                    InternalDriver.setDeregister(bl3);
                }
                Monitor.getMonitor().shutdown();
                throw Util.generateCsSQLException("XJ015.M");
            }
            EmbedConnection embedConnection = n <= 0 ? this.getNewEmbedConnection(string2, formatableProperties) : this.timeLogin(string2, formatableProperties, n);
            if (embedConnection.isClosed()) {
                Connection connection = null;
                return connection;
            }
            EmbedConnection embedConnection2 = embedConnection;
            return embedConnection2;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            EmbedConnection.memoryState.setLowMemory();
            throw EmbedConnection.NO_MEM;
        }
        finally {
            if (formatableProperties != null) {
                formatableProperties.clearDefaults();
            }
        }
    }

    protected abstract EmbedConnection timeLogin(String var1, Properties var2, int var3) throws SQLException;

    public abstract void checkSystemPrivileges(String var1, Permission var2) throws Exception;

    private void checkShutdownPrivileges(String string2) throws SQLException {
        if (System.getSecurityManager() == null) {
            return;
        }
        try {
            SystemPermission systemPermission = new SystemPermission("engine", "shutdown");
            this.checkSystemPrivileges(string2, systemPermission);
        }
        catch (AccessControlException accessControlException) {
            throw Util.generateCsSQLException("08004.C.9", (Object)string2, (Object)accessControlException);
        }
        catch (Exception exception) {
            throw Util.generateCsSQLException("08004.C.9", (Object)string2, (Object)exception);
        }
    }

    public int getMajorVersion() {
        return Monitor.getMonitor().getEngineVersion().getMajorVersion();
    }

    public int getMinorVersion() {
        return Monitor.getMonitor().getEngineVersion().getMinorVersion();
    }

    public boolean jdbcCompliant() {
        return true;
    }

    protected FormatableProperties getAttributes(String string2, Properties properties) throws SQLException {
        FormatableProperties formatableProperties = new FormatableProperties(properties);
        properties = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n = string3.indexOf(61);
            if (n == -1) {
                throw Util.generateCsSQLException("XJ028.C", string2);
            }
            formatableProperties.put(string3.substring(0, n).trim(), string3.substring(n + 1).trim());
        }
        InternalDriver.checkBoolean(formatableProperties, "dataEncryption");
        InternalDriver.checkBoolean(formatableProperties, "create");
        InternalDriver.checkBoolean(formatableProperties, "shutdown");
        InternalDriver.checkBoolean(formatableProperties, "deregister");
        InternalDriver.checkBoolean(formatableProperties, "upgrade");
        return formatableProperties;
    }

    private static void checkBoolean(Properties properties, String string2) throws SQLException {
        String[] stringArray = new String[]{"true", "false"};
        InternalDriver.checkEnumeration(properties, string2, stringArray);
    }

    private static void checkEnumeration(Properties properties, String string2, String[] stringArray) throws SQLException {
        String string3 = properties.getProperty(string2);
        if (string3 == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string3.toUpperCase(Locale.ENGLISH).equals(stringArray[i].toUpperCase(Locale.ENGLISH))) continue;
            return;
        }
        String string4 = "{";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                string4 = string4 + "|";
            }
            string4 = string4 + stringArray[i];
        }
        throw Util.generateCsSQLException("XJ05B.C", string2, string3, string4 + "}");
    }

    public static String getDatabaseName(String string2, Properties properties) {
        if (string2.equals("jdbc:default:connection")) {
            return "";
        }
        int n = string2.indexOf(59);
        String string3 = n == -1 ? string2.substring("jdbc:derby:".length()) : string2.substring("jdbc:derby:".length(), n);
        if (string3.length() == 0 && properties != null) {
            string3 = properties.getProperty("databaseName", string3);
        }
        string3 = string3.trim();
        return string3;
    }

    public final ContextService getContextServiceFactory() {
        return this.contextServiceFactory;
    }

    public AuthenticationService getAuthenticationService() {
        if (this.authenticationService == null) {
            this.authenticationService = (AuthenticationService)Monitor.findService("org.apache.derby.iapi.jdbc.AuthenticationService", "authentication");
        }
        return this.authenticationService;
    }

    protected abstract EmbedConnection getNewEmbedConnection(String var1, Properties var2) throws SQLException;

    private ConnectionContext getConnectionContext() {
        ContextManager contextManager = this.getCurrentContextManager();
        ConnectionContext connectionContext = null;
        if (contextManager != null) {
            connectionContext = (ConnectionContext)((Object)contextManager.getContext("JDBC_ConnectionContext"));
        }
        return connectionContext;
    }

    private ContextManager getCurrentContextManager() {
        return this.getContextServiceFactory().getCurrentContextManager();
    }

    public boolean isActive() {
        return this.active;
    }

    public abstract Connection getNewNestedConnection(EmbedConnection var1);

    public Statement newEmbedStatement(EmbedConnection embedConnection, boolean bl, int n, int n2, int n3) {
        return new EmbedStatement(embedConnection, bl, n, n2, n3);
    }

    public abstract PreparedStatement newEmbedPreparedStatement(EmbedConnection var1, String var2, boolean var3, int var4, int var5, int var6, int var7, int[] var8, String[] var9) throws SQLException;

    public abstract CallableStatement newEmbedCallableStatement(EmbedConnection var1, String var2, int var3, int var4, int var5) throws SQLException;

    public DatabaseMetaData newEmbedDatabaseMetaData(EmbedConnection embedConnection, String string2) throws SQLException {
        return new EmbedDatabaseMetaData(embedConnection, string2);
    }

    public abstract EmbedResultSet newEmbedResultSet(EmbedConnection var1, ResultSet var2, boolean var3, EmbedStatement var4, boolean var5) throws SQLException;

    public EmbedResultSetMetaData newEmbedResultSetMetaData(ResultColumnDescriptor[] resultColumnDescriptorArray) {
        return new EmbedResultSetMetaData(resultColumnDescriptorArray);
    }

    static void setDeregister(boolean bl) {
        deregister = bl;
    }

    static boolean getDeregister() {
        return deregister;
    }

    static {
        deregister = true;
    }
}

