/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.generic;

import java.util.Map;
import java.util.WeakHashMap;
import org.glassfish.gmbal.generic.DprintUtil;
import org.glassfish.gmbal.generic.MethodMonitor;
import org.glassfish.gmbal.generic.OperationTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodMonitorFactory {
    private static final MethodMonitor noopImpl = new MethodMonitorBase("NoOpImpl"){

        public void enter(boolean enabled, String name, Object ... args) {
        }

        public void exit(boolean enabled, Object result) {
        }
    };
    public static final MethodMonitor operationTracer = new MethodMonitorBase("OperationTracer"){

        public void enter(boolean enabled, String name, Object ... args) {
            OperationTracer.enter(name, args);
        }

        public void exit(boolean enabled, Object result) {
            OperationTracer.exit();
        }

        public void clear() {
            OperationTracer.clear();
        }
    };
    private static Map<Class<?>, MethodMonitor> stdMap = new WeakHashMap();

    private MethodMonitorFactory() {
    }

    public static MethodMonitor getNoOp() {
        return noopImpl;
    }

    public static MethodMonitor compose(final MethodMonitor ... mms) {
        return new MethodMonitorBase("ComposeImpl"){

            public void enter(boolean enabled, String name, Object ... args) {
                for (MethodMonitor mm3 : mms) {
                    mm3.enter(enabled, name, args);
                }
            }

            public void info(boolean enabled, Object ... args) {
                for (MethodMonitor mm3 : mms) {
                    mm3.info(enabled, args);
                }
            }

            public void exit(boolean enabled, Object result) {
                for (MethodMonitor mm3 : mms) {
                    mm3.exit(enabled, result);
                }
            }
        };
    }

    public static MethodMonitor dprintUtil(Class<?> cls) {
        final DprintUtil dputil = DprintUtil.getDprintUtil(cls);
        return new MethodMonitorBase("DprintUtil"){

            public void enter(boolean enabled, String name, Object ... args) {
                if (enabled) {
                    dputil.enter(name, args);
                }
            }

            public void info(boolean enabled, Object ... args) {
                if (enabled) {
                    dputil.info(args);
                }
            }

            public void exit(boolean enabled, Object result) {
                if (enabled) {
                    dputil.exit(result);
                }
            }
        };
    }

    private static MethodMonitor standardImpl(Class<?> cls) {
        final DprintUtil dputil = DprintUtil.getDprintUtil(cls);
        return new MethodMonitorBase("StandardImpl"){

            public void enter(boolean enabled, String name, Object ... args) {
                OperationTracer.enter(name, args);
                if (enabled) {
                    dputil.enter(name, args);
                }
            }

            public void info(boolean enabled, Object ... args) {
                if (enabled) {
                    dputil.info(args);
                }
            }

            public void exit(boolean enabled, Object result) {
                OperationTracer.exit();
                if (enabled) {
                    dputil.exit(result);
                }
            }

            public void clear() {
                OperationTracer.clear();
            }
        };
    }

    public static MethodMonitor makeStandard(Class<?> cls) {
        MethodMonitor result = stdMap.get(cls);
        if (result == null) {
            result = MethodMonitorFactory.standardImpl(cls);
            stdMap.put(cls, result);
        }
        return result;
    }

    private static abstract class MethodMonitorBase
    implements MethodMonitor {
        private String name;

        MethodMonitorBase(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public abstract void enter(boolean var1, String var2, Object ... var3);

        public void info(boolean enabled, Object ... args) {
        }

        public abstract void exit(boolean var1, Object var2);

        public void exit(boolean enabled) {
            this.exit(enabled, null);
        }

        public void clear() {
        }
    }
}

