/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.validation;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.xerces.util.XMLCatalogResolver;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.xml.sax.SAXException;

public class XmlSchemaCompiler {
    private static final Logger LOGR = Logger.getLogger(XmlSchemaCompiler.class.getPackage().getName());
    private XMLCatalogResolver resolver = new XMLCatalogResolver();
    private ValidationErrorHandler errHandler;

    public XmlSchemaCompiler(URL catalog) {
        if (null != catalog) {
            String[] catalogList = new String[]{catalog.toString()};
            this.resolver.setCatalogList(catalogList);
        }
        this.errHandler = new ValidationErrorHandler();
    }

    public ValidationErrorHandler getErrorHandler() {
        return this.errHandler;
    }

    public Schema compileXmlSchema(URI ... schemaURIs) throws SAXException, IOException {
        ArrayList<StreamSource> sources = new ArrayList<StreamSource>();
        for (URI schemaURI : schemaURIs) {
            String catalogEntry = this.lookupSchemaByURI(schemaURI);
            if (null != catalogEntry) {
                LOGR.log(Level.FINE, "Found catalog entry for schema: {0}", catalogEntry);
                schemaURI = URI.create(catalogEntry);
            }
            File schemaFile = this.dereferenceURI(schemaURI);
            StreamSource source = new StreamSource(schemaFile);
            source.setSystemId(schemaURI.toString());
            LOGR.log(Level.FINE, "Adding schema source: {0}", source.getSystemId());
            sources.add(source);
        }
        return this.compileXmlSchema(sources.toArray(new Source[sources.size()]));
    }

    public Schema compileXmlSchema(Source ... xsdSources) throws SAXException {
        LOGR.log(Level.FINE, "Compiling {0} schema sources.", xsdSources.length);
        SchemaFactory xsdFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        this.errHandler.reset();
        xsdFactory.setErrorHandler(this.errHandler);
        xsdFactory.setResourceResolver(this.resolver);
        Schema schema = xsdFactory.newSchema(xsdSources);
        return schema;
    }

    String lookupSchemaByURI(URI uri) {
        String schemaRef = null;
        try {
            schemaRef = this.resolver.resolveSystem(uri.toString());
            if (null == schemaRef) {
                schemaRef = this.resolver.resolveURI(uri.toString());
            }
        }
        catch (IOException e) {
            LOGR.log(Level.WARNING, "Error reading schema catalog. {0}", e.getCause());
        }
        return schemaRef;
    }

    File dereferenceURI(URI schemaURI) throws IOException {
        if (null == schemaURI || !schemaURI.isAbsolute()) {
            throw new IllegalArgumentException("Schema reference is not an absolute URI: " + schemaURI);
        }
        if (schemaURI.getScheme().equalsIgnoreCase("file")) {
            return new File(schemaURI);
        }
        LOGR.log(Level.FINE, "Attempting to retrieve schema from {0}", schemaURI);
        Path destFilePath = Files.createTempFile("schema-", ".xsd", new FileAttribute[0]);
        Charset utf8 = Charset.forName("UTF-8");
        URLConnection conn = schemaURI.toURL().openConnection();
        conn.setConnectTimeout(5000);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), utf8));
             BufferedWriter writer = Files.newBufferedWriter(destFilePath, utf8, new OpenOption[0]);){
            String line = null;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
            }
        }
        return destFilePath.toFile();
    }
}

