/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.testng.ITestObjectFactory;
import org.testng.TestNG;
import org.testng.collections.CollectionUtils;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.Utils;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlGroups;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlMethodSelectors;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlTest;
import org.testng.xml.XmlUtils;
import org.testng.xml.dom.OnElement;
import org.testng.xml.dom.OnElementList;
import org.testng.xml.dom.Tag;

public class XmlSuite
implements Serializable,
Cloneable {
    public static final String SKIP = "skip";
    public static final String CONTINUE = "continue";
    private String m_test;
    private static final String DEFAULT_SUITE_NAME = "Default Suite";
    private String m_name = "Default Suite";
    public static final Integer DEFAULT_VERBOSE = 1;
    private Integer m_verbose = null;
    public static final ParallelMode DEFAULT_PARALLEL = ParallelMode.FALSE;
    private ParallelMode m_parallel = DEFAULT_PARALLEL;
    private String m_parentModule = "";
    private String m_guiceStage = "";
    public static final String DEFAULT_CONFIG_FAILURE_POLICY = "skip";
    private String m_configFailurePolicy = "skip";
    public static final Boolean DEFAULT_JUNIT = Boolean.FALSE;
    private Boolean m_isJUnit = DEFAULT_JUNIT;
    public static final Boolean DEFAULT_MIXED = Boolean.FALSE;
    private Boolean m_isMixed = DEFAULT_MIXED;
    public static final Boolean DEFAULT_SKIP_FAILED_INVOCATION_COUNTS = Boolean.FALSE;
    private Boolean m_skipFailedInvocationCounts = DEFAULT_SKIP_FAILED_INVOCATION_COUNTS;
    public static final Integer DEFAULT_THREAD_COUNT = 5;
    private int m_threadCount = DEFAULT_THREAD_COUNT;
    public static final Integer DEFAULT_DATA_PROVIDER_THREAD_COUNT = 10;
    private int m_dataProviderThreadCount = DEFAULT_DATA_PROVIDER_THREAD_COUNT;
    public static final Boolean DEFAULT_GROUP_BY_INSTANCES = false;
    private Boolean m_groupByInstances = DEFAULT_GROUP_BY_INSTANCES;
    public static final Boolean DEFAULT_ALLOW_RETURN_VALUES = Boolean.FALSE;
    private Boolean m_allowReturnValues = DEFAULT_ALLOW_RETURN_VALUES;
    private List<XmlPackage> m_xmlPackages = Lists.newArrayList();
    private String m_expression = null;
    private List<XmlMethodSelector> m_methodSelectors = Lists.newArrayList();
    private List<XmlTest> m_tests = Lists.newArrayList();
    private Map<String, String> m_parameters = Maps.newHashMap();
    private String m_fileName;
    private String m_timeOut;
    private List<XmlSuite> m_childSuites = Lists.newArrayList();
    private XmlSuite m_parentSuite;
    private List<String> m_suiteFiles = Lists.newArrayList();
    private ITestObjectFactory m_objectFactory;
    private List<String> m_listeners = Lists.newArrayList();
    private static final long serialVersionUID = 4999962288272750226L;
    public static final String DEFAULT_PRESERVE_ORDER = "true";
    private String m_preserveOrder = "true";
    private List<String> m_includedGroups = Lists.newArrayList();
    private List<String> m_excludedGroups = Lists.newArrayList();
    private XmlMethodSelectors m_xmlMethodSelectors;
    private XmlGroups m_xmlGroups;

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public ParallelMode getParallel() {
        return this.m_parallel;
    }

    public String getParentModule() {
        return this.m_parentModule;
    }

    public String getGuiceStage() {
        return this.m_guiceStage;
    }

    public ITestObjectFactory getObjectFactory() {
        return this.m_objectFactory;
    }

    public void setObjectFactory(ITestObjectFactory objectFactory) {
        this.m_objectFactory = objectFactory;
    }

    @Deprecated
    public void setParallel(String parallel) {
        if (parallel == null) {
            this.setParallel((ParallelMode)null);
        } else {
            this.setParallel(ParallelMode.getValidParallel(parallel));
        }
    }

    public void setParallel(ParallelMode parallel) {
        this.m_parallel = parallel == null ? DEFAULT_PARALLEL : parallel;
    }

    public void setParentModule(String parentModule) {
        this.m_parentModule = parentModule;
    }

    public void setGuiceStage(String guiceStage) {
        this.m_guiceStage = guiceStage;
    }

    public void setConfigFailurePolicy(String configFailurePolicy) {
        this.m_configFailurePolicy = configFailurePolicy;
    }

    public String getConfigFailurePolicy() {
        return this.m_configFailurePolicy;
    }

    public Integer getVerbose() {
        return this.m_verbose != null ? this.m_verbose : TestNG.DEFAULT_VERBOSE;
    }

    public void setVerbose(Integer verbose) {
        this.m_verbose = verbose;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getTest() {
        return this.m_test;
    }

    public List<XmlTest> getTests() {
        return this.m_tests;
    }

    public void setTests(List<XmlTest> tests) {
        this.m_tests = tests;
    }

    public List<XmlMethodSelector> getMethodSelectors() {
        if (this.m_xmlMethodSelectors != null) {
            return this.m_xmlMethodSelectors.getMethodSelectors();
        }
        return this.m_methodSelectors;
    }

    public void setMethodSelectors(List<XmlMethodSelector> methodSelectors) {
        this.m_methodSelectors = Lists.newArrayList(methodSelectors);
    }

    private void updateParameters() {
        if (this.m_parentSuite != null) {
            Set<String> keySet = this.m_parentSuite.getParameters().keySet();
            for (String name : keySet) {
                if (this.m_parameters.containsKey(name)) continue;
                this.m_parameters.put(name, this.m_parentSuite.getParameter(name));
            }
        }
    }

    public void setParameters(Map<String, String> parameters) {
        this.m_parameters = parameters;
        this.updateParameters();
    }

    public Map<String, String> getParameters() {
        return this.m_parameters;
    }

    public Map<String, String> getAllParameters() {
        Map<String, String> result = Maps.newHashMap();
        for (Map.Entry<String, String> entry : this.m_parameters.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        for (XmlTest test : this.getTests()) {
            Map<String, String> tp = test.getLocalParameters();
            for (Map.Entry<String, String> entry : tp.entrySet()) {
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public String getParameter(String name) {
        return this.m_parameters.get(name);
    }

    public int getThreadCount() {
        return this.m_threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.m_threadCount = threadCount;
    }

    public Boolean isJUnit() {
        return this.m_isJUnit;
    }

    public void setJUnit(Boolean isJUnit) {
        this.m_isJUnit = isJUnit;
    }

    public void setJunit(Boolean j) {
        this.setJUnit(j);
    }

    public Boolean skipFailedInvocationCounts() {
        return this.m_skipFailedInvocationCounts;
    }

    public void setSkipFailedInvocationCounts(boolean skip) {
        this.m_skipFailedInvocationCounts = skip;
    }

    public void setXmlPackages(List<XmlPackage> packages) {
        this.m_xmlPackages = Lists.newArrayList(packages);
    }

    public List<XmlPackage> getXmlPackages() {
        return this.m_xmlPackages;
    }

    public List<XmlPackage> getPackages() {
        return this.getXmlPackages();
    }

    @Tag(name="method-selectors")
    public void setMethodSelectors(XmlMethodSelectors xms) {
        this.m_xmlMethodSelectors = xms;
    }

    public void setPackages(List<XmlPackage> packages) {
        this.setXmlPackages(packages);
    }

    public String toXml() {
        ParallelMode parallel;
        XMLStringBuffer xsb = new XMLStringBuffer();
        xsb.setDocType("suite SYSTEM \"http://testng.org/testng-1.0.dtd\"");
        Properties p = new Properties();
        p.setProperty("name", this.getName());
        if (this.getVerbose() != null) {
            XmlUtils.setProperty(p, "verbose", this.getVerbose().toString(), DEFAULT_VERBOSE.toString());
        }
        if ((parallel = this.getParallel()) != null && !DEFAULT_PARALLEL.equals((Object)parallel)) {
            p.setProperty("parallel", parallel.toString());
        }
        XmlUtils.setProperty(p, "group-by-instances", String.valueOf(this.getGroupByInstances()), DEFAULT_GROUP_BY_INSTANCES.toString());
        XmlUtils.setProperty(p, "configfailurepolicy", this.getConfigFailurePolicy(), "skip");
        XmlUtils.setProperty(p, "thread-count", String.valueOf(this.getThreadCount()), DEFAULT_THREAD_COUNT.toString());
        XmlUtils.setProperty(p, "data-provider-thread-count", String.valueOf(this.getDataProviderThreadCount()), DEFAULT_DATA_PROVIDER_THREAD_COUNT.toString());
        if (!DEFAULT_JUNIT.equals(this.m_isJUnit)) {
            p.setProperty("junit", this.m_isJUnit != null ? this.m_isJUnit.toString() : "false");
        }
        XmlUtils.setProperty(p, "skipfailedinvocationcounts", this.m_skipFailedInvocationCounts.toString(), DEFAULT_SKIP_FAILED_INVOCATION_COUNTS.toString());
        if (null != this.m_objectFactory) {
            p.setProperty("object-factory", this.m_objectFactory.getClass().getName());
        }
        if (Utils.isStringNotEmpty(this.m_parentModule)) {
            p.setProperty("parent-module", this.getParentModule());
        }
        if (Utils.isStringNotEmpty(this.m_guiceStage)) {
            p.setProperty("guice-stage", this.getGuiceStage());
        }
        XmlUtils.setProperty(p, "allow-return-values", String.valueOf(this.getAllowReturnValues()), DEFAULT_ALLOW_RETURN_VALUES.toString());
        xsb.push("suite", p);
        XmlUtils.dumpParameters(xsb, this.m_parameters);
        if (CollectionUtils.hasElements(this.m_listeners)) {
            xsb.push("listeners");
            for (String string2 : this.m_listeners) {
                Properties listenerProps = new Properties();
                listenerProps.setProperty("class-name", string2);
                xsb.addEmptyElement("listener", listenerProps);
            }
            xsb.pop("listeners");
        }
        if (CollectionUtils.hasElements(this.getXmlPackages())) {
            xsb.push("packages");
            for (XmlPackage xmlPackage : this.getXmlPackages()) {
                xsb.getStringBuffer().append(xmlPackage.toXml("    "));
            }
            xsb.pop("packages");
        }
        if (this.getXmlMethodSelectors() != null) {
            xsb.getStringBuffer().append(this.getXmlMethodSelectors().toXml("  "));
        } else if (CollectionUtils.hasElements(this.getMethodSelectors())) {
            xsb.push("method-selectors");
            for (XmlMethodSelector xmlMethodSelector : this.getMethodSelectors()) {
                xsb.getStringBuffer().append(xmlMethodSelector.toXml("  "));
            }
            xsb.pop("method-selectors");
        }
        List<String> suiteFiles = this.getSuiteFiles();
        if (suiteFiles.size() > 0) {
            xsb.push("suite-files");
            for (String sf : suiteFiles) {
                Properties prop = new Properties();
                prop.setProperty("path", sf);
                xsb.addEmptyElement("suite-file", prop);
            }
            xsb.pop("suite-files");
        }
        List<String> list = this.getIncludedGroups();
        List<String> excluded = this.getExcludedGroups();
        if (CollectionUtils.hasElements(list) || CollectionUtils.hasElements(excluded)) {
            xsb.push("groups");
            xsb.push("run");
            for (String g2 : list) {
                xsb.addEmptyElement("include", "name", g2);
            }
            for (String g2 : excluded) {
                xsb.addEmptyElement("exclude", "name", g2);
            }
            xsb.pop("run");
            xsb.pop("groups");
        }
        if (this.m_xmlGroups != null) {
            xsb.getStringBuffer().append(this.m_xmlGroups.toXml("  "));
        }
        for (XmlTest test : this.getTests()) {
            xsb.getStringBuffer().append(test.toXml("  "));
        }
        xsb.pop("suite");
        return xsb.toXML();
    }

    @Tag(name="method-selectors")
    public void setXmlMethodSelectors(XmlMethodSelectors xms) {
        this.m_xmlMethodSelectors = xms;
    }

    private XmlMethodSelectors getXmlMethodSelectors() {
        return this.m_xmlMethodSelectors;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[Suite: \"").append(this.m_name).append("\" ");
        for (XmlTest t : this.m_tests) {
            result.append("  ").append(t.toString()).append(' ');
        }
        for (XmlMethodSelector ms : this.m_methodSelectors) {
            result.append(" methodSelector:" + ms);
        }
        result.append(']');
        return result.toString();
    }

    private static void ppp(String s2) {
        System.out.println("[XmlSuite] " + s2);
    }

    public Object clone() {
        XmlSuite result = new XmlSuite();
        result.setExcludedGroups(this.getExcludedGroups());
        result.setIncludedGroups(this.getIncludedGroups());
        result.setGroupByInstances(this.getGroupByInstances());
        result.setGroups(this.getGroups());
        result.setMethodSelectors(this.getXmlMethodSelectors());
        result.setPackages(this.getPackages());
        result.setParentSuite(this.getParentSuite());
        result.setPreserveOrder(this.getPreserveOrder());
        result.setSuiteFiles(this.getSuiteFiles());
        result.setTests(this.getTests());
        result.setXmlMethodSelectors(this.getXmlMethodSelectors());
        result.setName(this.getName());
        result.setFileName(this.getFileName());
        result.setListeners(this.getListeners());
        result.setParallel(this.getParallel());
        result.setParentModule(this.getParentModule());
        result.setGuiceStage(this.getGuiceStage());
        result.setConfigFailurePolicy(this.getConfigFailurePolicy());
        result.setThreadCount(this.getThreadCount());
        result.setDataProviderThreadCount(this.getDataProviderThreadCount());
        result.setParameters(this.getAllParameters());
        result.setVerbose(this.getVerbose());
        result.setXmlPackages(this.getXmlPackages());
        result.setMethodSelectors(this.getMethodSelectors());
        result.setJUnit(this.isJUnit());
        result.setSkipFailedInvocationCounts(this.skipFailedInvocationCounts());
        result.setObjectFactory(this.getObjectFactory());
        result.setAllowReturnValues(this.getAllowReturnValues());
        result.setTimeOut(this.getTimeOut());
        return result;
    }

    public void setTimeOut(String timeOut) {
        this.m_timeOut = timeOut;
    }

    public String getTimeOut() {
        return this.m_timeOut;
    }

    public long getTimeOut(long def) {
        long result = def;
        if (this.m_timeOut != null) {
            result = Long.parseLong(this.m_timeOut);
        }
        return result;
    }

    public void setSuiteFiles(List<String> files) {
        this.m_suiteFiles = files;
    }

    public List<String> getSuiteFiles() {
        return this.m_suiteFiles;
    }

    public void setListeners(List<String> listeners) {
        this.m_listeners = listeners;
    }

    public List<String> getListeners() {
        if (this.m_parentSuite != null) {
            List<String> listeners = this.m_parentSuite.getListeners();
            for (String listener : listeners) {
                if (this.m_listeners.contains(listener)) continue;
                this.m_listeners.add(listener);
            }
        }
        return this.m_listeners;
    }

    public void setDataProviderThreadCount(int count) {
        this.m_dataProviderThreadCount = count;
    }

    public int getDataProviderThreadCount() {
        String s2 = System.getProperty("dataproviderthreadcount");
        if (s2 != null) {
            try {
                int nthreads = Integer.parseInt(s2);
                return nthreads;
            }
            catch (NumberFormatException nfe) {
                System.err.println("Parsing System property 'dataproviderthreadcount': " + nfe);
            }
        }
        return this.m_dataProviderThreadCount;
    }

    public void setParentSuite(XmlSuite parentSuite) {
        this.m_parentSuite = parentSuite;
        this.updateParameters();
    }

    public XmlSuite getParentSuite() {
        return this.m_parentSuite;
    }

    public List<XmlSuite> getChildSuites() {
        return this.m_childSuites;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_configFailurePolicy == null ? 0 : this.m_configFailurePolicy.hashCode());
        result = 31 * result + this.m_dataProviderThreadCount;
        result = 31 * result + (this.m_expression == null ? 0 : this.m_expression.hashCode());
        result = 31 * result + (this.m_fileName == null ? 0 : this.m_fileName.hashCode());
        result = 31 * result + (this.m_isJUnit == null ? 0 : this.m_isJUnit.hashCode());
        result = 31 * result + (this.m_listeners == null ? 0 : this.m_listeners.hashCode());
        result = 31 * result + (this.m_methodSelectors == null ? 0 : this.m_methodSelectors.hashCode());
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        result = 31 * result + (this.m_objectFactory == null ? 0 : this.m_objectFactory.hashCode());
        result = 31 * result + (this.m_parallel == null ? 0 : this.m_parallel.hashCode());
        result = 31 * result + (this.m_skipFailedInvocationCounts == null ? 0 : this.m_skipFailedInvocationCounts.hashCode());
        result = 31 * result + (this.m_suiteFiles == null ? 0 : this.m_suiteFiles.hashCode());
        result = 31 * result + (this.m_test == null ? 0 : this.m_test.hashCode());
        result = 31 * result + (this.m_tests == null ? 0 : this.m_tests.hashCode());
        result = 31 * result + this.m_threadCount;
        result = 31 * result + (this.m_timeOut == null ? 0 : this.m_timeOut.hashCode());
        result = 31 * result + (this.m_verbose == null ? 0 : this.m_verbose.hashCode());
        result = 31 * result + (this.m_xmlPackages == null ? 0 : this.m_xmlPackages.hashCode());
        return result;
    }

    static boolean f() {
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return XmlSuite.f();
        }
        if (this.getClass() != obj.getClass()) {
            return XmlSuite.f();
        }
        XmlSuite other = (XmlSuite)obj;
        if (this.m_configFailurePolicy == null ? other.m_configFailurePolicy != null : !this.m_configFailurePolicy.equals(other.m_configFailurePolicy)) {
            return XmlSuite.f();
        }
        if (this.m_dataProviderThreadCount != other.m_dataProviderThreadCount) {
            return XmlSuite.f();
        }
        if (this.m_expression == null ? other.m_expression != null : !this.m_expression.equals(other.m_expression)) {
            return XmlSuite.f();
        }
        if (this.m_isJUnit == null ? other.m_isJUnit != null : !this.m_isJUnit.equals(other.m_isJUnit)) {
            return XmlSuite.f();
        }
        if (this.m_listeners == null ? other.m_listeners != null : !this.m_listeners.equals(other.m_listeners)) {
            return XmlSuite.f();
        }
        if (this.m_methodSelectors == null ? other.m_methodSelectors != null : !this.m_methodSelectors.equals(other.m_methodSelectors)) {
            return XmlSuite.f();
        }
        if (this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name)) {
            return XmlSuite.f();
        }
        if (this.m_objectFactory == null ? other.m_objectFactory != null : !this.m_objectFactory.equals(other.m_objectFactory)) {
            return XmlSuite.f();
        }
        if (this.m_parallel == null ? other.m_parallel != null : !this.m_parallel.equals((Object)other.m_parallel)) {
            return XmlSuite.f();
        }
        if (this.m_skipFailedInvocationCounts == null ? other.m_skipFailedInvocationCounts != null : !this.m_skipFailedInvocationCounts.equals(other.m_skipFailedInvocationCounts)) {
            return XmlSuite.f();
        }
        if (this.m_suiteFiles == null ? other.m_suiteFiles != null : !this.m_suiteFiles.equals(other.m_suiteFiles)) {
            return XmlSuite.f();
        }
        if (this.m_test == null ? other.m_test != null : !this.m_test.equals(other.m_test)) {
            return XmlSuite.f();
        }
        if (this.m_tests == null ? other.m_tests != null : !this.m_tests.equals(other.m_tests)) {
            return XmlSuite.f();
        }
        if (this.m_threadCount != other.m_threadCount) {
            return XmlSuite.f();
        }
        if (this.m_timeOut == null ? other.m_timeOut != null : !this.m_timeOut.equals(other.m_timeOut)) {
            return XmlSuite.f();
        }
        if (this.m_verbose == null ? other.m_verbose != null : !this.m_verbose.equals(other.m_verbose)) {
            return XmlSuite.f();
        }
        if (this.m_xmlPackages == null ? other.m_xmlPackages != null : !this.m_xmlPackages.equals(other.m_xmlPackages)) {
            return XmlSuite.f();
        }
        return true;
    }

    private boolean eq(String o1, String o2, String def) {
        boolean result = false;
        if (o1 == null && o2 == null) {
            result = true;
        } else if (o1 != null) {
            result = o1.equals(o2) || def.equals(o1) && o2 == null;
        } else if (o2 != null) {
            result = o2.equals(o1) || def.equals(o2) && o1 == null;
        }
        return result;
    }

    public void setPreserveOrder(String f) {
        this.m_preserveOrder = f;
    }

    public String getPreserveOrder() {
        return this.m_preserveOrder;
    }

    public List<String> getIncludedGroups() {
        if (this.m_xmlGroups != null) {
            return this.m_xmlGroups.getRun().getIncludes();
        }
        return this.m_includedGroups;
    }

    public void addIncludedGroup(String g2) {
        this.m_includedGroups.add(g2);
    }

    public void setIncludedGroups(List<String> g2) {
        this.m_includedGroups = g2;
    }

    public void setExcludedGroups(List<String> g2) {
        this.m_excludedGroups = g2;
    }

    public List<String> getExcludedGroups() {
        if (this.m_xmlGroups != null) {
            return this.m_xmlGroups.getRun().getExcludes();
        }
        return this.m_excludedGroups;
    }

    public void addExcludedGroup(String g2) {
        this.m_excludedGroups.add(g2);
    }

    public Boolean getGroupByInstances() {
        return this.m_groupByInstances;
    }

    public void setGroupByInstances(boolean f) {
        this.m_groupByInstances = f;
    }

    public void addListener(String listener) {
        this.m_listeners.add(listener);
    }

    public Boolean getAllowReturnValues() {
        return this.m_allowReturnValues;
    }

    public void setAllowReturnValues(Boolean allowReturnValues) {
        this.m_allowReturnValues = allowReturnValues;
    }

    public void setGroups(XmlGroups xmlGroups) {
        this.m_xmlGroups = xmlGroups;
    }

    @OnElement(tag="parameter", attributes={"name", "value"})
    public void onParameterElement(String name, String value) {
        this.getParameters().put(name, value);
    }

    @OnElementList(tag="listeners", attributes={"class-name"})
    public void onListenerElement(String className) {
        this.addListener(className);
    }

    @OnElementList(tag="suite-files", attributes={"path"})
    public void onSuiteFilesElement(String path) {
        this.getSuiteFiles().add(path);
    }

    @OnElementList(tag="packages", attributes={"name"})
    public void onPackagesElement(String name) {
        this.getPackages().add(new XmlPackage(name));
    }

    public void onMethodSelectorElement(String language, String name, String priority) {
        System.out.println("Language:" + language);
    }

    public XmlGroups getGroups() {
        return this.m_xmlGroups;
    }

    public void addTest(XmlTest test) {
        this.getTests().add(test);
    }

    public Collection<String> getPackageNames() {
        List<String> result = Lists.newArrayList();
        for (XmlPackage p : this.getPackages()) {
            result.add(p.getName());
        }
        return result;
    }

    public static enum ParallelMode {
        TESTS,
        METHODS,
        CLASSES,
        INSTANCES,
        NONE,
        TRUE,
        FALSE;


        public static ParallelMode getValidParallel(String parallel) {
            if (parallel == null) {
                return null;
            }
            try {
                return ParallelMode.valueOf(parallel.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

