/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te;

import com.occamlab.te.vocabulary.CITE;
import com.occamlab.te.vocabulary.CONTENT;
import com.occamlab.te.vocabulary.EARL;
import com.occamlab.te.vocabulary.HTTP;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.jena.rdf.model.Bag;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Seq;
import org.apache.jena.vocabulary.DCTerms;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CtlEarlReporter {
    private static final Logger LOG = Logger.getLogger(CtlEarlReporter.class.getName());
    private String langCode = "en";
    private Resource testRun;
    private int resultCount = 0;
    private Resource assertor;
    private Resource testSubject;
    private Model earlModel = ModelFactory.createDefaultModel();
    private Seq reqs;
    private int cPassCount;
    private int cFailCount;
    private int cSkipCount;
    private int cContinueCount;
    private int cBestPracticeCount;
    private int cNotTestedCount;
    private int cWarningCount;
    private int cInheritedFailureCount;
    private int totalPassCount = 0;
    private int totalFailCount = 0;
    private int totalSkipCount = 0;
    private int totalContinueCount = 0;
    private int totalBestPracticeCount = 0;
    private int totalNotTestedCount = 0;
    private int totalWarningCount = 0;
    private int totalInheritedFailureCount = 0;
    private Boolean areCoreConformanceClassesPassed = true;

    public void generateEarlReport(File outputDirectory, File reportFile, String suiteName, Map params) throws UnsupportedEncodingException {
        Document document;
        DocumentBuilderFactory docFactory = this.createDcumentBuilder();
        try {
            document = docFactory.newDocumentBuilder().parse(reportFile);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
        document.getDocumentElement().normalize();
        Model earlReport = this.generateEarlReport(suiteName, params, document);
        try {
            this.writeModel(earlReport, outputDirectory, true);
        }
        catch (IOException iox) {
            throw new RuntimeException("Failed to serialize EARL results", iox);
        }
    }

    public void generateEarlReport(OutputStream targetEarlReport, InputStream report, String suiteName, Map params) throws UnsupportedEncodingException {
        Document document;
        DocumentBuilderFactory docFactory = this.createDcumentBuilder();
        try {
            document = docFactory.newDocumentBuilder().parse(report);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
        document.getDocumentElement().normalize();
        Model earlReport = this.generateEarlReport(suiteName, params, document);
        try {
            this.writeModel(earlReport, targetEarlReport, true);
        }
        catch (IOException iox) {
            throw new RuntimeException("Failed to serialize EARL results", iox);
        }
    }

    private DocumentBuilderFactory createDcumentBuilder() {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        docFactory.setXIncludeAware(true);
        return docFactory;
    }

    private Model generateEarlReport(String suiteName, Map params, Document document) throws UnsupportedEncodingException {
        Model model = this.initializeModel(suiteName);
        this.addTestInputs(model, params);
        this.reqs = model.createSeq();
        NodeList executionList = document.getElementsByTagName("execution");
        for (int temp = 0; temp < executionList.getLength(); ++temp) {
            Node executionNode = executionList.item(temp);
            Element executionElement = (Element)executionNode;
            NodeList logList = executionElement.getElementsByTagName("log");
            Element logElement = (Element)logList.item(0);
            NodeList testcallList = logElement.getElementsByTagName("testcall");
            this.getSubtestResult(model, testcallList, logList);
        }
        this.testRun.addProperty(CITE.requirements, (RDFNode)this.reqs);
        this.testRun.addLiteral(CITE.testsPassed, (Object)new Integer(this.totalPassCount));
        this.testRun.addLiteral(CITE.testsFailed, (Object)new Integer(this.totalFailCount));
        this.testRun.addLiteral(CITE.testsSkipped, (Object)new Integer(this.totalSkipCount));
        this.testRun.addLiteral(CITE.testsContinue, (Object)new Integer(this.totalContinueCount));
        this.testRun.addLiteral(CITE.testsBestPractice, (Object)new Integer(this.totalBestPracticeCount));
        this.testRun.addLiteral(CITE.testsNotTested, (Object)new Integer(this.totalNotTestedCount));
        this.testRun.addLiteral(CITE.testsWarning, (Object)new Integer(this.totalWarningCount));
        this.testRun.addLiteral(CITE.testsInheritedFailure, (Object)new Integer(this.totalInheritedFailureCount));
        this.testRun.addLiteral(CITE.testSuiteType, (Object)"ctl");
        this.testRun.addLiteral(CITE.areCoreConformanceClassesPassed, (Object)this.areCoreConformanceClassesPassed);
        this.earlModel.add(model);
        return this.earlModel;
    }

    private void getSubtestResult(Model model, NodeList testcallList, NodeList logList) throws UnsupportedEncodingException {
        String conformanceClass = "";
        for (int k = 0; k < testcallList.getLength(); ++k) {
            Element testcallElement = (Element)testcallList.item(k);
            String testcallPath = testcallElement.getAttribute("path");
            Element logElements = this.findMatchingLogElement(logList, testcallPath);
            if (logElements == null) continue;
            TestInfo testInfo = this.getTestinfo(logElements);
            if (testInfo.isConformanceClass) {
                conformanceClass = testInfo.testName;
                this.cPassCount = 0;
                this.cFailCount = 0;
                this.cSkipCount = 0;
                this.cContinueCount = 0;
                this.cBestPracticeCount = 0;
                this.cNotTestedCount = 0;
                this.cWarningCount = 0;
                this.cInheritedFailureCount = 0;
                this.addTestRequirements(model, testInfo);
            }
            this.processTestResults(model, logElements, logList, conformanceClass, null);
            Resource testReq = model.createResource(conformanceClass);
            testReq.addLiteral(CITE.testsPassed, (Object)new Integer(this.cPassCount));
            testReq.addLiteral(CITE.testsFailed, (Object)new Integer(this.cFailCount));
            testReq.addLiteral(CITE.testsSkipped, (Object)new Integer(this.cSkipCount));
            testReq.addLiteral(CITE.testsContinue, (Object)new Integer(this.cContinueCount));
            testReq.addLiteral(CITE.testsBestPractice, (Object)new Integer(this.cBestPracticeCount));
            testReq.addLiteral(CITE.testsNotTested, (Object)new Integer(this.cNotTestedCount));
            testReq.addLiteral(CITE.testsWarning, (Object)new Integer(this.cWarningCount));
            testReq.addLiteral(CITE.testsInheritedFailure, (Object)new Integer(this.cInheritedFailureCount));
            if (testInfo.isBasic && (this.cFailCount > 0 || this.cInheritedFailureCount > 0)) {
                this.areCoreConformanceClassesPassed = false;
            }
            this.totalPassCount += this.cPassCount;
            this.totalFailCount += this.cFailCount;
            this.totalSkipCount += this.cSkipCount;
            this.totalContinueCount += this.cContinueCount;
            this.totalBestPracticeCount += this.cBestPracticeCount;
            this.totalNotTestedCount += this.cNotTestedCount;
            this.totalWarningCount += this.cWarningCount;
            this.totalInheritedFailureCount += this.cInheritedFailureCount;
        }
    }

    private Element findMatchingLogElement(NodeList logList, String testcallPath) throws UnsupportedEncodingException {
        for (int j = 0; j < logList.getLength(); ++j) {
            Element logElement = (Element)logList.item(j);
            String decodedBaseURL = URLDecoder.decode(logElement.getAttribute("xml:base"), "UTF-8");
            String logtestcall = this.parseLogTestCall("", decodedBaseURL);
            if (!testcallPath.equals(logtestcall)) continue;
            return logElement;
        }
        return null;
    }

    private TestInfo getTestinfo(Element logElements) {
        Element starttestElements = this.getElementByTagName(logElements, "starttest");
        Element endtestElements = this.getElementByTagName(logElements, "endtest");
        String assertion = this.parseTextContent(logElements, "assertion");
        if (assertion == null) {
            assertion = "Null";
        }
        String testName = starttestElements.getAttribute("local-name");
        int result = Integer.parseInt(endtestElements.getAttribute("result"));
        Element ccElement = this.getElementByTagName(logElements, "conformanceClass");
        boolean isCC = ccElement != null;
        boolean isBasic = false;
        if (ccElement != null && ccElement.hasAttribute("isBasic") && Boolean.valueOf(ccElement.getAttribute("isBasic")).booleanValue()) {
            isBasic = true;
        }
        return new TestInfo(assertion, testName, result, isCC, isBasic);
    }

    private Model initializeModel(String suiteName) {
        Model model = ModelFactory.createDefaultModel();
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put("earl", "http://www.w3.org/ns/earl#");
        nsBindings.put("dct", "http://purl.org/dc/terms/");
        nsBindings.put("cite", "http://cite.opengeospatial.org/");
        nsBindings.put("http", "http://www.w3.org/2011/http#");
        nsBindings.put("cnt", "http://www.w3.org/2011/content#");
        model.setNsPrefixes(nsBindings);
        this.testRun = model.createResource(CITE.TestRun);
        this.testRun.addProperty(DCTerms.title, suiteName);
        String nowUTC = ZonedDateTime.now(ZoneId.of("Z")).format(DateTimeFormatter.ISO_INSTANT);
        this.testRun.addProperty(DCTerms.created, nowUTC);
        this.assertor = model.createResource("https://github.com/opengeospatial/teamengine", EARL.Assertor);
        this.assertor.addProperty(DCTerms.title, "OGC TEAM Engine", this.langCode);
        this.assertor.addProperty(DCTerms.description, "Official test harness of the OGC conformance testing program (CITE).", this.langCode);
        this.testSubject = model.createResource("", EARL.TestSubject);
        return model;
    }

    private void addTestRequirements(Model earl, TestInfo testInfo) {
        Resource testReq = earl.createResource(testInfo.testName.replaceAll("\\s", "-"), EARL.TestRequirement);
        testReq.addProperty(DCTerms.title, testInfo.testName);
        testReq.addProperty(CITE.isBasic, Boolean.toString(testInfo.isBasic));
        this.reqs.add((RDFNode)testReq);
    }

    private void processTestResults(Model earl, Element logElement, NodeList logList, String conformanceClass, Resource parentTestCase) throws UnsupportedEncodingException {
        NodeList childtestcallList = logElement.getElementsByTagName("testcall");
        for (int l = 0; l < childtestcallList.getLength(); ++l) {
            Element childtestcallElement = (Element)childtestcallList.item(l);
            String testcallPath = childtestcallElement.getAttribute("path");
            Element childlogElement = this.findMatchingLogElement(logList, testcallPath);
            if (childlogElement == null) {
                throw new NullPointerException("Failed to get Test-Info due to null log element.");
            }
            TestInfo testDetails = this.getTestinfo(childlogElement);
            GregorianCalendar calTime = new GregorianCalendar(TimeZone.getDefault());
            Resource assertion = earl.createResource("assert-" + ++this.resultCount, EARL.Assertion);
            assertion.addProperty(EARL.mode, (RDFNode)EARL.AutomaticMode);
            assertion.addProperty(EARL.assertedBy, (RDFNode)this.assertor);
            assertion.addProperty(EARL.subject, (RDFNode)this.testSubject);
            Resource earlResult = earl.createResource("result-" + this.resultCount, EARL.TestResult);
            earlResult.addProperty(DCTerms.date, (RDFNode)earl.createTypedLiteral((Calendar)calTime));
            this.processTestResult(childlogElement, testDetails, earlResult);
            this.processRequests(earlResult, childlogElement, earl);
            assertion.addProperty(EARL.result, (RDFNode)earlResult);
            String testName = testDetails.testName;
            StringBuilder testCaseId = new StringBuilder(testcallPath);
            testCaseId.append('#').append(testName);
            Resource testCase = earl.createResource(testCaseId.toString(), EARL.TestCase);
            testCase.addProperty(DCTerms.title, testName);
            testCase.addProperty(DCTerms.description, testDetails.assertion);
            assertion.addProperty(EARL.test, (RDFNode)testCase);
            if (parentTestCase != null) {
                parentTestCase.addProperty(DCTerms.hasPart, (RDFNode)testCase);
            } else {
                earl.createResource(conformanceClass).addProperty(DCTerms.hasPart, (RDFNode)testCase);
            }
            this.processTestResults(earl, childlogElement, logList, conformanceClass, testCase);
        }
    }

    private void processTestResult(Element childlogElement, TestInfo testDetails, Resource earlResult) {
        switch (testDetails.result) {
            case 0: {
                earlResult.addProperty(EARL.outcome, (RDFNode)CITE.Continue);
                ++this.cContinueCount;
                break;
            }
            case 2: {
                earlResult.addProperty(EARL.outcome, (RDFNode)CITE.Not_Tested);
                ++this.cNotTestedCount;
                break;
            }
            case 6: {
                earlResult.addProperty(EARL.outcome, (RDFNode)EARL.Fail);
                String errorMessage = this.parseTextContent(childlogElement, "exception");
                if (errorMessage != null) {
                    earlResult.addProperty(DCTerms.description, errorMessage);
                }
                ++this.cFailCount;
                break;
            }
            case 3: {
                earlResult.addProperty(EARL.outcome, (RDFNode)EARL.NotTested);
                ++this.cSkipCount;
                break;
            }
            case 4: {
                earlResult.addProperty(EARL.outcome, (RDFNode)CITE.Warning);
                ++this.cWarningCount;
                break;
            }
            case 5: {
                earlResult.addProperty(EARL.outcome, (RDFNode)CITE.Inherited_Failure);
                ++this.cInheritedFailureCount;
                break;
            }
            default: {
                earlResult.addProperty(EARL.outcome, (RDFNode)EARL.Pass);
                ++this.cPassCount;
            }
        }
    }

    private void processRequests(Resource earlResult, Element childlogElements, Model earl) {
        NodeList requestList = childlogElements.getElementsByTagName("request");
        for (int i = 0; i < requestList.getLength(); ++i) {
            Element reqElement = (Element)requestList.item(i);
            this.processRequest(earlResult, earl, reqElement);
        }
    }

    private void processRequest(Resource earlResult, Model earl, Element reqElement) {
        Resource httpReq = this.createEarlRequest(earl, reqElement);
        if (httpReq == null) {
            return;
        }
        String response = this.parseNodeAsString(reqElement, "response");
        if (response != null) {
            Resource httpRsp = earl.createResource(HTTP.Response);
            Resource rspContent = earl.createResource(CONTENT.ContentAsXML);
            rspContent.addProperty(CONTENT.rest, response);
            httpRsp.addProperty(HTTP.body, (RDFNode)rspContent);
            httpReq.addProperty(HTTP.resp, (RDFNode)httpRsp);
        }
        earlResult.addProperty(CITE.message, (RDFNode)httpReq);
    }

    private Resource createEarlRequest(Model earl, Element reqElement) {
        Element requestNode = this.getElementByTagName(reqElement, "http://www.occamlab.com/ctl", "request");
        if (requestNode != null) {
            String httpMethod = this.parseTextContent(requestNode, "http://www.occamlab.com/ctl", "method");
            String url = this.parseTextContent(requestNode, "http://www.occamlab.com/ctl", "url");
            Resource earlRequest = earl.createResource(HTTP.Request);
            if ("GET".equalsIgnoreCase(httpMethod)) {
                Map<String, String> parameters = this.parseParameters(requestNode);
                String urlWithQueryString = this.createUrlWithQueryString(url, parameters);
                earlRequest.addProperty(HTTP.methodName, httpMethod);
                earlRequest.addProperty(HTTP.requestURI, urlWithQueryString);
                return earlRequest;
            }
            if ("POST".equalsIgnoreCase(httpMethod)) {
                try {
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.setOutputProperty("indent", "yes");
                    StreamResult result = new StreamResult(new StringWriter());
                    DOMSource source = new DOMSource(requestNode);
                    transformer.transform(source, result);
                    String xmlString = result.getWriter().toString();
                    result.getWriter().close();
                    Resource reqContent = earl.createResource(CONTENT.ContentAsXML);
                    reqContent.addProperty(CONTENT.rest, xmlString);
                    earlRequest.addProperty(HTTP.body, (RDFNode)reqContent);
                    return earlRequest;
                }
                catch (Exception e) {
                    new RuntimeException("Request content is not well-formatted. " + e.getMessage());
                }
            }
        }
        return null;
    }

    private String createUrlWithQueryString(String url, Map<String, String> parameters) {
        if (parameters.isEmpty()) {
            return url;
        }
        StringBuilder urlWithQueryString = new StringBuilder(url);
        if (!url.contains("?")) {
            urlWithQueryString.append("?");
        }
        if (!url.endsWith("?") && !url.endsWith("&")) {
            urlWithQueryString.append("&");
        }
        boolean isFirst = true;
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            if (!isFirst) {
                urlWithQueryString.append("&");
            }
            urlWithQueryString.append(parameter.getKey());
            urlWithQueryString.append("=");
            urlWithQueryString.append(parameter.getValue());
            isFirst = false;
        }
        return urlWithQueryString.toString();
    }

    private Map<String, String> parseParameters(Element requestNode) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        NodeList paramNodes = requestNode.getElementsByTagNameNS("http://www.occamlab.com/ctl", "param");
        for (int paramNodeIndex = 0; paramNodeIndex < paramNodes.getLength(); ++paramNodeIndex) {
            Element paramNode = (Element)paramNodes.item(paramNodeIndex);
            String paramName = paramNode.getAttribute("name");
            String paramValue = paramNode.getTextContent();
            parameters.put(paramName, paramValue);
        }
        return parameters;
    }

    private Element getElementByTagName(Element element, String tagName) {
        return this.getElementByTagName(element, null, tagName);
    }

    private Element getElementByTagName(Element element, String tagNamespaceUri, String tagName) {
        NodeList elementsByTagName = tagNamespaceUri != null ? element.getElementsByTagNameNS(tagNamespaceUri, tagName) : element.getElementsByTagName(tagName);
        if (elementsByTagName.getLength() > 0) {
            return (Element)elementsByTagName.item(0);
        }
        return null;
    }

    private String parseTextContent(Element element, String tagName) {
        return this.parseTextContent(element, null, tagName);
    }

    private String parseTextContent(Element element, String tagNamespaceUri, String tagName) {
        Element elementByTagName = this.getElementByTagName(element, tagNamespaceUri, tagName);
        if (elementByTagName != null) {
            return elementByTagName.getTextContent();
        }
        return null;
    }

    private String parseNodeAsString(Element element, String tagName) {
        Element elementByTagName = this.getElementByTagName(element, tagName);
        if (elementByTagName != null) {
            try {
                TransformerFactory transFactory = TransformerFactory.newInstance();
                Transformer transformer = transFactory.newTransformer();
                StringWriter buffer = new StringWriter();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.transform(new DOMSource(elementByTagName), new StreamResult(buffer));
                return buffer.toString();
            }
            catch (TransformerException e) {
                LOG.warning("Could not parse node as string: " + e.getMessage());
            }
        }
        return null;
    }

    private void addTestInputs(Model earl, Map<String, String> params) {
        Bag inputs = earl.createBag();
        if (!params.equals("") && params != null) {
            String value = "";
            for (String key : params.keySet()) {
                value = params.get(key);
                Resource testInputs = earl.createResource();
                testInputs.addProperty(DCTerms.title, key);
                testInputs.addProperty(DCTerms.description, value);
                inputs.add((RDFNode)testInputs);
            }
        }
        this.testRun.addProperty(CITE.inputs, (RDFNode)inputs);
    }

    private void writeModel(Model earlModel, File outputDirectory, boolean abbreviated) throws IOException {
        File outputFile = new File(outputDirectory, "earl-results.rdf");
        if (!outputFile.createNewFile()) {
            outputFile.delete();
            outputFile.createNewFile();
        }
        String baseUri = "http://example.org/earl/" + outputDirectory.getName() + '/';
        FileOutputStream outStream = new FileOutputStream(outputFile);
        this.writeModel(earlModel, outStream, abbreviated, baseUri);
    }

    private void writeModel(Model earlModel, OutputStream targetEarlReport, boolean abbreviated) throws IOException {
        String baseUri = "http://example.org/earl/";
        this.writeModel(earlModel, targetEarlReport, abbreviated, baseUri);
    }

    private void writeModel(Model earlModel, OutputStream outStream, boolean abbreviated, String baseUri) throws IOException {
        String syntax = abbreviated ? "RDF/XML-ABBREV" : "RDF/XML";
        try (OutputStreamWriter writer = new OutputStreamWriter(outStream, StandardCharsets.UTF_8);){
            earlModel.write((Writer)writer, syntax, baseUri);
        }
    }

    private String parseLogTestCall(String logtestcall, String decodedBaseURL) {
        if (decodedBaseURL.contains("users")) {
            String baseUrl = decodedBaseURL.substring(decodedBaseURL.indexOf("users"));
            int first = baseUrl.indexOf(System.getProperty("file.separator"));
            int second = baseUrl.indexOf(System.getProperty("file.separator"), first + 1);
            logtestcall = baseUrl.substring(second + 1, baseUrl.lastIndexOf(System.getProperty("file.separator")));
        } else if (decodedBaseURL.contains("temp")) {
            String baseUrl = decodedBaseURL.substring(decodedBaseURL.indexOf("temp"));
            logtestcall = baseUrl.substring(baseUrl.indexOf(System.getProperty("file.separator")) + 1, baseUrl.lastIndexOf(System.getProperty("file.separator")));
        } else if (decodedBaseURL.contains("unittest")) {
            String baseUrl = decodedBaseURL.substring(decodedBaseURL.indexOf("unittest"));
            logtestcall = baseUrl.substring(baseUrl.indexOf("/") + 1, baseUrl.lastIndexOf("/"));
        }
        if (logtestcall.contains("\\")) {
            logtestcall = logtestcall.replace("\\", "/");
        }
        return logtestcall;
    }

    private class TestInfo {
        private String assertion;
        private String testName;
        private int result;
        private boolean isConformanceClass;
        private boolean isBasic;

        public TestInfo(String assertion, String testName, int result, boolean isConformanceClass, boolean isBasic) {
            this.assertion = assertion;
            this.testName = testName;
            this.result = result;
            this.isConformanceClass = isConformanceClass;
            this.isBasic = isBasic;
        }
    }
}

