/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.parsers;

import com.google.common.collect.ImmutableList;
import com.occamlab.te.ErrorHandlerImpl;
import com.occamlab.te.parsers.XmlErrorHandler;
import com.occamlab.te.parsers.xml.CachingSchemaLoader;
import com.occamlab.te.parsers.xml.InMemorySchemaSupplier;
import com.occamlab.te.parsers.xml.SchemaSupplier;
import com.occamlab.te.parsers.xml.XsdSchemaLoader;
import com.occamlab.te.util.DomUtils;
import com.occamlab.te.util.URLConnectionUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLProtocolException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class XMLValidatingParser {
    static TransformerFactory TF = null;
    static DocumentBuilderFactory nonValidatingDBF = null;
    static DocumentBuilderFactory schemaValidatingDBF = null;
    static DocumentBuilderFactory dtdValidatingDBF = null;
    ArrayList<SchemaSupplier> schemaList = new ArrayList();
    ArrayList<Object> dtdList = new ArrayList();
    private final CachingSchemaLoader schemaLoader = new CachingSchemaLoader(new XsdSchemaLoader());
    private static final Logger jlogger = Logger.getLogger("com.occamlab.te.parsers.XMLValidatingParser");

    private List<Object> loadSchemaList(Document schemaLinks, String schemaType) throws Exception {
        NodeList nodes = schemaLinks.getElementsByTagNameNS("http://www.occamlab.com/te/parsers", schemaType);
        if (nodes.getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> schemas = new ArrayList<Object>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            Serializable schema = null;
            String type = e.getAttribute("type");
            if (type.equals("url")) {
                schema = new URL(e.getTextContent());
            } else if (type.equals("file")) {
                schema = new File(e.getTextContent());
            } else if (type.equals("resource")) {
                String resource;
                ClassLoader cl = this.getClass().getClassLoader();
                URL url = cl.getResource(resource = e.getTextContent());
                if (url == null) {
                    String msg = "Can't find schema resource on classpath at " + resource;
                    jlogger.warning(msg);
                    throw new Exception(msg);
                }
                schema = url;
            } else {
                throw new Exception("Unknown schema resource type " + type);
            }
            jlogger.finer("Adding schema reference " + schema.toString());
            schemas.add(schema);
        }
        return schemas;
    }

    private void loadSchemaLists(Node schemaLinks, ArrayList<SchemaSupplier> schemas, ArrayList<Object> dtds) throws Exception {
        if (null == schemaLinks) {
            return;
        }
        jlogger.finer("Received schemaLinks\n" + DomUtils.serializeNode(schemaLinks));
        Document configDoc = schemaLinks instanceof Document ? (Document)schemaLinks : schemaLinks.getOwnerDocument();
        ArrayList<SchemaSupplier> schemaSuppliers = new ArrayList<SchemaSupplier>();
        for (Object schemaObj : this.loadSchemaList(configDoc, "schema")) {
            schemaSuppliers.add(SchemaSupplier.makeSupplier(schemaObj));
        }
        schemas.addAll(schemaSuppliers);
        dtds.addAll(this.loadSchemaList(configDoc, "dtd"));
        NodeList nodes = configDoc.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            CharArrayWriter caw = new CharArrayWriter();
            Transformer t = TF.newTransformer();
            t.transform(new DOMSource(e), new StreamResult(caw));
            schemas.add(new InMemorySchemaSupplier(caw.toCharArray()));
        }
    }

    public XMLValidatingParser() {
        if (nonValidatingDBF == null) {
            String property_name = "javax.xml.parsers.DocumentBuilderFactory";
            String oldprop = System.getProperty(property_name);
            System.setProperty(property_name, "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            nonValidatingDBF = DocumentBuilderFactory.newInstance();
            nonValidatingDBF.setExpandEntityReferences(false);
            nonValidatingDBF.setNamespaceAware(true);
            schemaValidatingDBF = DocumentBuilderFactory.newInstance();
            schemaValidatingDBF.setNamespaceAware(true);
            schemaValidatingDBF.setValidating(true);
            schemaValidatingDBF.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            dtdValidatingDBF = DocumentBuilderFactory.newInstance();
            dtdValidatingDBF.setNamespaceAware(true);
            dtdValidatingDBF.setValidating(true);
            dtdValidatingDBF.setExpandEntityReferences(false);
            if (oldprop == null) {
                System.clearProperty(property_name);
            } else {
                System.setProperty(property_name, oldprop);
            }
        }
        if (TF == null) {
            TF = TransformerFactory.newInstance();
            try {
                TF.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (Exception e) {
                jlogger.warning("Failed to secure Transformer");
            }
        }
    }

    public XMLValidatingParser(Document schema_links) throws Exception {
        this();
        if (null != schema_links) {
            this.loadSchemaLists(schema_links, this.schemaList, this.dtdList);
        }
    }

    public Document parse(URLConnection uc, Element instruction, PrintWriter logger) throws SSLProtocolException {
        if (null == uc) {
            throw new NullPointerException("Unable to parse resource: URLConnection is null.");
        }
        jlogger.fine("Received URLConnection object for " + uc.getURL());
        Document doc = null;
        try (InputStream inStream = URLConnectionUtils.getInputStream(uc);){
            doc = this.parse(inStream, instruction, logger);
        }
        catch (SSLProtocolException sslep) {
            throw new SSLProtocolException("[SSL ERROR] Failed to connect with the requested URL due to \"Invalid server_name\" found!! :" + uc.getURL() + ":" + sslep.getClass() + " : " + sslep.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to parse resource from %s", uc.getURL()), e);
        }
        return doc;
    }

    Document parse(Object input, Element parserConfig, PrintWriter logger) throws Exception {
        String s;
        jlogger.finer("Received XML resource of type " + input.getClass().getName());
        Document resultDoc = null;
        ErrorHandlerImpl errHandler = new ErrorHandlerImpl("Parsing", logger);
        if (input instanceof InputStream) {
            DocumentBuilderFactory dbf = nonValidatingDBF;
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(errHandler);
            try (InputStream xmlInput = (InputStream)input;){
                resultDoc = db.parse(xmlInput);
            }
            catch (Exception e) {
                jlogger.log(Level.INFO, "Error parsing InputStream", e);
            }
        } else if (input instanceof Document) {
            resultDoc = (Document)input;
        } else {
            throw new IllegalArgumentException("XML input must be an InputStream or a Document object.");
        }
        if (null == resultDoc) {
            throw new RuntimeException("Failed to parse input: " + input.getClass().getName());
        }
        errHandler.setRole("Validation");
        this.validate(resultDoc, parserConfig, errHandler);
        int error_count = errHandler.getErrorCount();
        int warning_count = errHandler.getWarningCount();
        if (error_count > 0 || warning_count > 0) {
            String msg = "";
            if (error_count > 0) {
                msg = msg + error_count + " validation error" + (error_count == 1 ? "" : "s");
                if (warning_count > 0) {
                    msg = msg + " and ";
                }
            }
            if (warning_count > 0) {
                msg = msg + warning_count + " warning" + (warning_count == 1 ? "" : "s");
            }
            msg = msg + " detected.";
            logger.println(msg);
        }
        if (error_count > 0) {
            String string = s = null != parserConfig ? parserConfig.getAttribute("ignoreErrors") : "false";
            if (s.length() == 0 || !Boolean.parseBoolean(s)) {
                resultDoc = null;
            }
        }
        if (warning_count > 0) {
            String string = s = null != parserConfig ? parserConfig.getAttribute("ignoreWarnings") : "true";
            if (s.length() > 0 && !Boolean.parseBoolean(s)) {
                resultDoc = null;
            }
        }
        return resultDoc;
    }

    public boolean checkXMLRules(Document doc, Document instruction) throws Exception {
        PrintWriter logger;
        if (doc == null || doc.getDocumentElement() == null) {
            return false;
        }
        Element e = instruction.getDocumentElement();
        Document parsedDoc = this.parse(doc, e, logger = new PrintWriter(System.out));
        return parsedDoc != null;
    }

    public NodeList validate(Document doc, Document instruction) throws Exception {
        return this.schemaValidation(doc, instruction).toNodeList();
    }

    public Element validateSingleResult(Document doc, Document instruction) throws Exception {
        return this.schemaValidation(doc, instruction).toRootElement();
    }

    XmlErrorHandler schemaValidation(Document doc, Document instruction) throws Exception {
        if (doc == null || doc.getDocumentElement() == null) {
            throw new NullPointerException("Input document is null.");
        }
        XmlErrorHandler errHandler = new XmlErrorHandler();
        this.validate(doc, instruction, errHandler);
        return errHandler;
    }

    private void validate(Document doc, Node instruction, ErrorHandler errHandler) throws Exception {
        ArrayList<SchemaSupplier> schemas = new ArrayList<SchemaSupplier>();
        ArrayList<Object> dtds = new ArrayList<Object>();
        schemas.addAll(this.schemaList);
        dtds.addAll(this.dtdList);
        this.loadSchemaLists(instruction, schemas, dtds);
        if (null == doc.getDoctype() && dtds.isEmpty()) {
            this.validateAgainstXMLSchemaList(doc, schemas, errHandler);
        } else {
            this.validateAgainstDTDList(doc, dtds, errHandler);
        }
    }

    void validateAgainstXMLSchemaList(Document doc, List<SchemaSupplier> xsdList, ErrorHandler errHandler) throws SAXException, IOException {
        jlogger.fine("Validating XML resource from " + doc.getDocumentURI() + " with these specified schemas: " + xsdList);
        Schema schema = !xsdList.isEmpty() ? this.schemaLoader.loadSchema((ImmutableList<SchemaSupplier>)ImmutableList.copyOf(xsdList)) : this.schemaLoader.defaultSchema();
        Validator validator = schema.newValidator();
        validator.setErrorHandler(errHandler);
        DOMSource source = new DOMSource(doc, doc.getBaseURI());
        validator.validate(source);
    }

    private void validateAgainstDTDList(Document doc, ArrayList<Object> dtdList, ErrorHandler errHandler) throws Exception {
        jlogger.finer("Validating XML resource from " + doc.getDocumentURI());
        DocumentBuilder db = dtdValidatingDBF.newDocumentBuilder();
        db.setErrorHandler(errHandler);
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Exception e) {
            jlogger.warning("Failed to secure Transformer");
        }
        Transformer copier = tf.newTransformer();
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        StreamResult copy = new StreamResult(content);
        if (dtdList.isEmpty()) {
            DocumentType doctype = doc.getDoctype();
            if (null == doctype) {
                return;
            }
            URI systemId = URI.create(doctype.getSystemId());
            if (!systemId.isAbsolute() && null != doc.getBaseURI()) {
                systemId = URI.create(doc.getBaseURI()).resolve(systemId);
            }
            copier.setOutputProperty("doctype-system", systemId.toString());
            copier.transform(new DOMSource(doc), copy);
            db.parse(new ByteArrayInputStream(content.toByteArray()));
        } else {
            for (Object dtdRef : dtdList) {
                content.reset();
                copier.setOutputProperty("doctype-system", dtdRef.toString());
                copier.transform(new DOMSource(doc), copy);
                db.parse(new ByteArrayInputStream(content.toByteArray()));
            }
        }
    }
}

