/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat20.dgiwg10.util;

import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;

public class ClientUtils {
    public static ClientRequest buildGetRequest(URI endpoint, Map<String, String> qryParams, MediaType ... mediaTypes) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)endpoint);
        if (null != qryParams) {
            for (Map.Entry<String, String> param : qryParams.entrySet()) {
                uriBuilder.queryParam(param.getKey(), new Object[]{param.getValue()});
            }
        }
        URI uri = uriBuilder.build(new Object[0]);
        ClientRequest.Builder reqBuilder = ClientRequest.create();
        reqBuilder = null == mediaTypes || mediaTypes.length == 0 ? (ClientRequest.Builder)reqBuilder.accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}) : (ClientRequest.Builder)reqBuilder.accept(mediaTypes);
        ClientRequest req = reqBuilder.build(uri, "GET");
        return req;
    }

    public static Source getResponseEntityAsSource(ClientResponse response, String targetURI) {
        Source source = (Source)response.getEntity(DOMSource.class);
        if (null != targetURI && !targetURI.isEmpty()) {
            source.setSystemId(targetURI);
        }
        if (response.getEntityInputStream().markSupported()) {
            try {
                response.getEntityInputStream().reset();
            }
            catch (IOException ex) {
                Logger.getLogger(ClientUtils.class.getName()).log(Level.WARNING, "Failed to reset response entity.", ex);
            }
        }
        return source;
    }

    public static Document getResponseEntityAsDocument(ClientResponse response, String targetURI) {
        DOMSource domSource = (DOMSource)ClientUtils.getResponseEntityAsSource(response, targetURI);
        Document entityDoc = (Document)domSource.getNode();
        entityDoc.setDocumentURI(domSource.getSystemId());
        return entityDoc;
    }
}

