/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.parsers;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.net.ssl.SSLProtocolException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ImageParser {
    private static Logger jlogger = Logger.getLogger("com.occamlab.te.parsers.ImageParser");
    private Element initialInstruction = null;

    public ImageParser(Document init) {
        this.initialInstruction = init.getDocumentElement();
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static String HexString(int num, int digits) {
        String s = Integer.toHexString(num);
        if (digits > s.length()) {
            return "00000000".substring(0, digits - s.length()) + s;
        }
        return s;
    }

    private static String getBase64Data(BufferedImage buffImage, String formatName, Node node) throws Exception {
        int numBytes = buffImage.getWidth() * buffImage.getHeight() * 4;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(numBytes);
        ImageOutputStream ios = ImageIO.createImageOutputStream(baos);
        boolean status = ImageIO.write((RenderedImage)buffImage, formatName, ios);
        if (!status) {
            throw new Exception("No suitable ImageIO writer found by ImageParser.getBase64Data() for image format " + formatName);
        }
        byte[] imageData = baos.toByteArray();
        byte[] base64Data = Base64.encodeBase64Chunked((byte[])imageData);
        String base64String = new String(base64Data, "UTF-8");
        return base64String;
    }

    private static String checkTransparentNodata(BufferedImage buffImage, Node node) throws Exception {
        String transparentNodata = "NA";
        boolean noData = false;
        boolean transparent = true;
        int[] bandIndexes = new int[]{3, 2, 1, 0};
        WritableRaster raster = buffImage.getRaster();
        int minx = raster.getMinX();
        int maxx = minx + raster.getWidth();
        int miny = raster.getMinY();
        int maxy = miny + raster.getHeight();
        int[][] bands = new int[bandIndexes.length][raster.getWidth()];
        for (int y = miny; y < maxy; ++y) {
            for (int i = 0; i < bandIndexes.length; ++i) {
                raster.getSamples(minx, y, maxx, 1, bandIndexes[i], bands[i]);
            }
            for (int x = minx; x < maxx; ++x) {
                int a = bands[0][x];
                int b = bands[1][x];
                int g = bands[2][x];
                int r = bands[3][x];
                if (b != 0 || g != 0 || r != 0) continue;
                noData = true;
                if (a == 0) continue;
                transparent = false;
            }
        }
        transparentNodata = noData ? (transparent ? "true" : "false") : "NA";
        return transparentNodata;
    }

    private static void processBufferedImage(BufferedImage buffimage, String formatName, NodeList nodes) throws Exception {
        String band;
        Node node;
        HashMap bandMap = new HashMap();
        for (int i = 0; i < nodes.getLength(); ++i) {
            node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("subimage")) {
                Element e = (Element)node;
                int x = Integer.parseInt(e.getAttribute("x"));
                int y = Integer.parseInt(e.getAttribute("y"));
                int w = Integer.parseInt(e.getAttribute("width"));
                int h = Integer.parseInt(e.getAttribute("height"));
                ImageParser.processBufferedImage(buffimage.getSubimage(x, y, w, h), formatName, e.getChildNodes());
                continue;
            }
            if (node.getLocalName().equals("checksum")) {
                DataBufferByte buffer;
                CRC32 checksum = new CRC32();
                WritableRaster raster = buffimage.getRaster();
                if (node.getParentNode().getLocalName().equals("subimage")) {
                    WritableRaster outRaster = raster.createCompatibleWritableRaster();
                    buffimage.copyData(outRaster);
                    buffer = (DataBufferByte)outRaster.getDataBuffer();
                } else {
                    buffer = (DataBufferByte)raster.getDataBuffer();
                }
                int numbanks = buffer.getNumBanks();
                for (int j = 0; j < numbanks; ++j) {
                    checksum.update(buffer.getData(j));
                }
                Document doc = node.getOwnerDocument();
                node.appendChild(doc.createTextNode(Long.toString(checksum.getValue())));
                continue;
            }
            if (node.getLocalName().equals("count")) {
                band = ((Element)node).getAttribute("bands");
                String sample = ((Element)node).getAttribute("sample");
                if (sample.equals("all")) {
                    bandMap.put(band, null);
                    continue;
                }
                HashMap<Integer, Integer> sampleMap = (HashMap<Integer, Integer>)bandMap.get(band);
                if (sampleMap == null && !bandMap.containsKey(band)) {
                    sampleMap = new HashMap<Integer, Integer>();
                    bandMap.put(band, sampleMap);
                }
                sampleMap.put(Integer.decode(sample), new Integer(0));
                continue;
            }
            if (!node.getLocalName().equals("transparentNodata")) continue;
            String transparentNodata = ImageParser.checkTransparentNodata(buffimage, node);
            node.setTextContent(transparentNodata);
        }
        for (String band_str : bandMap.keySet()) {
            boolean addall;
            int[] band_indexes;
            if (buffimage.getType() == 12 || buffimage.getType() == 10) {
                band_indexes = new int[]{0};
            } else {
                band_indexes = new int[band_str.length()];
                for (int i = 0; i < band_str.length(); ++i) {
                    if (band_str.charAt(i) == 'A') {
                        band_indexes[i] = 3;
                    }
                    if (band_str.charAt(i) == 'B') {
                        band_indexes[i] = 2;
                    }
                    if (band_str.charAt(i) == 'G') {
                        band_indexes[i] = 1;
                    }
                    if (band_str.charAt(i) != 'R') continue;
                    band_indexes[i] = 0;
                }
            }
            WritableRaster raster = buffimage.getRaster();
            HashMap<Integer, Integer> sampleMap = (HashMap<Integer, Integer>)bandMap.get(band_str);
            boolean bl = addall = sampleMap == null;
            if (sampleMap == null) {
                sampleMap = new HashMap<Integer, Integer>();
                bandMap.put(band_str, sampleMap);
            }
            int minx = raster.getMinX();
            int maxx = minx + raster.getWidth();
            int miny = raster.getMinY();
            int maxy = miny + raster.getHeight();
            int[][] bands = new int[band_indexes.length][raster.getWidth()];
            for (int y = miny; y < maxy; ++y) {
                for (int i = 0; i < band_indexes.length; ++i) {
                    raster.getSamples(minx, y, maxx, 1, band_indexes[i], bands[i]);
                }
                for (int x = minx; x < maxx; ++x) {
                    int sample = 0;
                    for (int i = 0; i < band_indexes.length; ++i) {
                        sample |= bands[i][x] << (band_indexes.length - i - 1) * 8;
                    }
                    Integer sampleObj = new Integer(sample);
                    boolean add = addall;
                    if (!addall) {
                        add = sampleMap.containsKey(sampleObj);
                    }
                    if (!add) continue;
                    Integer count = (Integer)sampleMap.get(sampleObj);
                    if (count == null) {
                        count = new Integer(0);
                    }
                    count = new Integer(count + 1);
                    sampleMap.put(sampleObj, count);
                }
            }
        }
        for (node = nodes.item(0); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getLocalName().equals("count")) continue;
            band = ((Element)node).getAttribute("bands");
            String sample = ((Element)node).getAttribute("sample");
            HashMap sampleMap = (HashMap)bandMap.get(band);
            Document doc = node.getOwnerDocument();
            if (sample.equals("all")) {
                String prefix;
                int digits;
                Node parent = node.getParentNode();
                Node prevSibling = node.getPreviousSibling();
                Iterator sampleIt = sampleMap.keySet().iterator();
                Element countnode = null;
                switch (buffimage.getType()) {
                    case 12: {
                        digits = 1;
                        prefix = "";
                        break;
                    }
                    case 10: {
                        digits = 2;
                        prefix = "0x";
                        break;
                    }
                    default: {
                        prefix = "0x";
                        digits = band.length() * 2;
                    }
                }
                while (sampleIt.hasNext()) {
                    countnode = doc.createElementNS(node.getNamespaceURI(), "count");
                    Integer sampleInt = (Integer)sampleIt.next();
                    Integer count = (Integer)sampleMap.get(sampleInt);
                    if (band.length() > 0) {
                        countnode.setAttribute("bands", band);
                    }
                    countnode.setAttribute("sample", prefix + ImageParser.HexString(sampleInt, digits));
                    Text textnode = doc.createTextNode(count.toString());
                    countnode.appendChild(textnode);
                    parent.insertBefore(countnode, node);
                    if (!sampleIt.hasNext() || prevSibling == null || prevSibling.getNodeType() != 3) continue;
                    parent.insertBefore(prevSibling.cloneNode(false), node);
                }
                parent.removeChild(node);
                if (countnode == null) {
                    countnode = (Element)node;
                    jlogger.log(Level.SEVERE, "Error processing image node");
                }
                node = countnode;
                continue;
            }
            Integer count = (Integer)sampleMap.get(Integer.decode(sample));
            if (count == null) {
                count = new Integer(0);
            }
            Text textnode = doc.createTextNode(count.toString());
            node.appendChild(textnode);
        }
    }

    public static int getImageWidth(String imageLoc) {
        InputStream is = null;
        try {
            URI imageUri = new URI(imageLoc);
            URL imageUrl = imageUri.toURL();
            is = imageUrl.openStream();
        }
        catch (Exception e) {
            jlogger.log(Level.SEVERE, "getImageWidth", e);
            return -1;
        }
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(is);
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            if (!iter.hasNext()) {
                return -1;
            }
            ImageReader reader = iter.next();
            reader.setInput(iis, true);
            int width = reader.getWidth(0);
            iis.close();
            return width;
        }
        catch (IOException e) {
            jlogger.log(Level.SEVERE, "getImageWidth", e);
            return -1;
        }
    }

    public static int getImageHeight(String imageLoc) {
        InputStream is = null;
        try {
            URI imageUri = new URI(imageLoc);
            URL imageUrl = imageUri.toURL();
            is = imageUrl.openStream();
        }
        catch (Exception e) {
            jlogger.log(Level.SEVERE, "getImageWidth", e);
            return -1;
        }
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(is);
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            if (!iter.hasNext()) {
                return -1;
            }
            ImageReader reader = iter.next();
            reader.setInput(iis, true);
            int height = reader.getHeight(0);
            iis.close();
            return height;
        }
        catch (IOException e) {
            jlogger.log(Level.SEVERE, "getImageWidth", e);
            return -1;
        }
    }

    public static String getImageType(String imageLoc) {
        InputStream is = null;
        try {
            URI imageUri = new URI(imageLoc);
            URL imageUrl = imageUri.toURL();
            is = imageUrl.openStream();
        }
        catch (Exception e) {
            jlogger.log(Level.SEVERE, "getImageType", e);
            return null;
        }
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(is);
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            if (!iter.hasNext()) {
                return null;
            }
            ImageReader reader = iter.next();
            iis.close();
            return reader.getFormatName();
        }
        catch (IOException e) {
            jlogger.log(Level.SEVERE, "getImageType", e);
            return null;
        }
    }

    public static String getSupportedImageTypes() {
        String[] readers = ImageIO.getReaderFormatNames();
        ArrayList<String> imageArray = new ArrayList<String>();
        String str = "";
        for (int i = 0; i < readers.length; ++i) {
            String current = readers[i].toLowerCase();
            if (imageArray.contains(current)) continue;
            imageArray.add(current);
            str = str + current + ",";
        }
        return str.substring(0, str.lastIndexOf(","));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(URLConnection uc, Element instruction, PrintWriter logger) throws SSLProtocolException {
        Document doc = null;
        InputStream is = null;
        try {
            is = uc.getInputStream();
            doc = ImageParser.parse(is, instruction, logger);
        }
        catch (SSLProtocolException sslep) {
            throw new SSLProtocolException("[SSL ERROR] Failed to connect with the requested URL due to \"Invalid server_name\" found!! :" + uc.getURL() + ":" + sslep.getClass() + " : " + sslep.getMessage());
        }
        catch (Exception e) {
            String msg = String.format("Failed to parse %s resource from %s %n %s", uc.getContentType(), uc.getURL(), e.getMessage());
            jlogger.warning(msg);
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return doc;
    }

    public Document parseAsInitialized(URLConnection uc, Element instruction, PrintWriter logger) throws Exception {
        if (this.initialInstruction == null) {
            throw new Exception("Parser was not initialized");
        }
        return ImageParser.parse(uc, this.initialInstruction, logger);
    }

    private static Node processFrame(ImageReader reader, int frame, NodeList nodes, PrintWriter logger) throws Exception {
        if (nodes.getLength() == 0) {
            return null;
        }
        String formatName = reader.getFormatName().toLowerCase();
        BufferedImage image = reader.read(frame);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("type")) {
                node.setTextContent(formatName);
                continue;
            }
            if (node.getLocalName().equals("height")) {
                node.setTextContent(Integer.toString(image.getHeight()));
                continue;
            }
            if (node.getLocalName().equals("width")) {
                node.setTextContent(Integer.toString(image.getWidth()));
                continue;
            }
            if (node.getLocalName().equals("metadata")) {
                try {
                    IIOMetadata metadata = reader.getImageMetadata(frame);
                    if (metadata == null) continue;
                    String format = ((Element)node).getAttribute("format");
                    if (format.length() == 0) {
                        format = metadata.getNativeMetadataFormatName();
                    }
                    Node tree = metadata.getAsTree(format);
                    TransformerFactory tf = TransformerFactory.newInstance();
                    tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    Transformer t = tf.newTransformer();
                    t.transform(new DOMSource(tree), new DOMResult(node));
                }
                catch (IIOException e) {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setExpandEntityReferences(false);
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document doc = db.newDocument();
                    String format = reader.getFormatName().toLowerCase();
                    String formatEltName = "javax_imageio_" + format + "_1.0";
                    Element formatElt = doc.createElement(formatEltName);
                    TransformerFactory tf = TransformerFactory.newInstance();
                    tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    Transformer t = tf.newTransformer();
                    t.transform(new DOMSource(formatElt), new DOMResult(node));
                }
                continue;
            }
            if (node.getLocalName().equals("model")) {
                ImageTracker tracker;
                Graphics2D g2;
                boolean done;
                int imagetype = -1;
                String model = ((Element)node).getAttribute("value");
                if (model.equals("MONOCHROME")) {
                    imagetype = 12;
                } else if (model.equals("GRAY")) {
                    imagetype = 10;
                } else if (model.equals("RGB")) {
                    imagetype = 5;
                } else if (model.equals("ARGB")) {
                    imagetype = 6;
                } else {
                    model = "CUSTOM";
                }
                ((Element)node).setAttribute("value", model);
                BufferedImage buffImage = image;
                if (image.getType() != imagetype && imagetype != -1 && !(done = (g2 = (buffImage = new BufferedImage(image.getWidth(), image.getHeight(), imagetype)).createGraphics()).drawImage((Image)image, 0, 0, tracker = new ImageTracker()))) {
                    while (!tracker.done) {
                        ImageParser.sleep(50L);
                    }
                }
                ImageParser.processBufferedImage(buffImage, formatName, node.getChildNodes());
                continue;
            }
            if (node.getLocalName().equals("transparency")) {
                int transparency = image.getTransparency();
                String transparencyName = null;
                switch (transparency) {
                    case 1: {
                        transparencyName = "Opaque";
                        break;
                    }
                    case 2: {
                        transparencyName = "Bitmask";
                        break;
                    }
                    case 3: {
                        transparencyName = "Translucent";
                        break;
                    }
                    default: {
                        transparencyName = "Unknown";
                    }
                }
                node.setTextContent(transparencyName);
                continue;
            }
            if (node.getLocalName().equals("base64Data")) {
                String base64Data = ImageParser.getBase64Data(image, formatName, node);
                node.setTextContent(base64Data);
                continue;
            }
            logger.println("ImageParser Error: Invalid tag " + node.getNodeName());
        }
        return null;
    }

    public static Document parseBase64(String base64Data, Element instruction) throws Exception {
        byte[] imageData = Base64.decodeBase64((String)base64Data);
        ByteArrayInputStream bais = new ByteArrayInputStream(imageData);
        StringWriter swLogger = new StringWriter();
        PrintWriter pwLogger = new PrintWriter(swLogger);
        return ImageParser.parse(bais, instruction, pwLogger);
    }

    private static Document parse(InputStream source, Element instruction, PrintWriter logger) throws Exception {
        ImageReader reader;
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(source);
            reader = ImageIO.getImageReaders(iis).next();
            reader.setInput(iis);
        }
        catch (Exception e) {
            logger.println("No image handlers available for the data stream. " + e.getMessage());
            throw e;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setExpandEntityReferences(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer t = tf.newTransformer();
        t.transform(new DOMSource(instruction), new DOMResult(doc));
        Element new_instruction = doc.getDocumentElement();
        int framesRead = 0;
        boolean containsFrames = false;
        Element framesElement = null;
        Element metadataElement = null;
        NodeList nodes = new_instruction.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            int frame;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("type")) {
                node.setTextContent(reader.getFormatName().toLowerCase());
                continue;
            }
            if (node.getLocalName().equals("frames")) {
                framesElement = (Element)node;
                containsFrames = true;
                continue;
            }
            if (node.getLocalName().equals("metadata")) {
                metadataElement = (Element)node;
                continue;
            }
            if (!node.getLocalName().equals("frame")) continue;
            String frameStr = ((Element)node).getAttribute("num");
            if (frameStr.length() == 0) {
                frame = framesRead++;
                ((Element)node).setAttribute("num", Integer.toString(frame));
            } else {
                frame = Integer.parseInt(frameStr);
                framesRead = frame + 1;
            }
            ImageParser.processFrame(reader, frame, node.getChildNodes(), logger);
            containsFrames = true;
        }
        if (containsFrames) {
            IIOMetadata metadata;
            if (metadataElement != null && (metadata = reader.getStreamMetadata()) != null) {
                String format = metadataElement.getAttribute("format");
                if (format.length() == 0) {
                    format = metadata.getNativeMetadataFormatName();
                }
                Node tree = metadata.getAsTree(format);
                t.transform(new DOMSource(tree), new DOMResult(metadataElement));
            }
            if (framesElement != null) {
                boolean allowSearch = !reader.isSeekForwardOnly();
                int frames = reader.getNumImages(allowSearch);
                if (frames == -1) {
                    try {
                        while (true) {
                            reader.read(framesRead);
                            ++framesRead;
                        }
                    }
                    catch (Exception e) {
                        jlogger.log(Level.SEVERE, "", e);
                        frames = framesRead + 1;
                    }
                }
                framesElement.setTextContent(Integer.toString(frames));
            }
        } else {
            ImageParser.processFrame(reader, 0, nodes, logger);
            framesRead = 1;
        }
        return doc;
    }

    public static void main(String[] args) throws Exception {
        URL image_url;
        URL xml_url;
        if (args.length < 2) {
            System.err.println("Parameters: xml_url image_url");
            return;
        }
        try {
            xml_url = new URL(args[0]);
        }
        catch (Exception e) {
            jlogger.log(Level.INFO, "Error building xmlurl, will prefix file://", e);
            xml_url = new URL("file://" + args[0]);
        }
        try {
            image_url = new URL(args[1]);
        }
        catch (Exception e) {
            jlogger.log(Level.INFO, "Error building xmlurl, will prefix file://", e);
            image_url = new URL("file://" + args[1]);
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setExpandEntityReferences(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(xml_url.openStream());
        Element instruction = doc.getDocumentElement();
        PrintWriter logger = new PrintWriter(System.out);
        InputStream image_is = image_url.openConnection().getInputStream();
        Document result = ImageParser.parse(image_is, instruction, logger);
        logger.flush();
        image_is.close();
        if (result != null) {
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            try {
                tf.setAttribute("http://saxon.sf.net/feature/strip-whitespace", "all");
            }
            catch (IllegalArgumentException e) {
                jlogger.log(Level.INFO, "setAttribute(\"http://saxon.sf.net/feature/strip-whitespace\", \"all\");", e);
            }
            Transformer t = tf.newTransformer();
            t.setOutputProperty("indent", "yes");
            t.transform(new DOMSource(result), new StreamResult(System.out));
        }
        System.exit(0);
    }

    private static class ImageTracker
    implements ImageObserver {
        volatile boolean done = false;

        private ImageTracker() {
        }

        @Override
        public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            this.done = (infoflags & 0xC0) != 0 ? true : (infoflags & 0x30) != 0;
            return !this.done;
        }
    }
}

