/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te;

import java.io.PrintWriter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class ErrorHandlerImpl
implements ErrorHandler {
    private int ErrorCount = 0;
    private int WarningCount = 0;
    private PrintWriter Logger;
    private String Prefix = "";

    public ErrorHandlerImpl() {
        this(null, new PrintWriter(System.out));
    }

    public ErrorHandlerImpl(String role, PrintWriter logger) {
        this.setRole(role);
        this.setLogger(logger);
    }

    public void setRole(String role) {
        if (role != null) {
            this.Prefix = role + " ";
        }
    }

    public void setLogger(PrintWriter logger) {
        this.Logger = logger;
    }

    public String getErrorCounts() {
        String msg = "";
        if (this.ErrorCount > 0 || this.WarningCount > 0) {
            if (this.ErrorCount > 0) {
                msg = msg + this.ErrorCount + " error" + (this.ErrorCount == 1 ? "" : "s");
                if (this.WarningCount > 0) {
                    msg = msg + " and ";
                }
            }
            if (this.WarningCount > 0) {
                msg = msg + this.WarningCount + " warning" + (this.WarningCount == 1 ? "" : "s");
            }
        } else {
            msg = "No errors or warnings";
        }
        msg = msg + " detected.";
        return msg;
    }

    private void error(String type, SAXParseException e) {
        this.Logger.print(type);
        if (e.getLineNumber() >= 0) {
            this.Logger.print(" at line " + e.getLineNumber());
            if (e.getColumnNumber() >= 0) {
                this.Logger.print(", column " + e.getColumnNumber());
            }
            if (e.getSystemId() != null) {
                this.Logger.print(" of " + e.getSystemId());
            }
        } else if (e.getSystemId() != null) {
            this.Logger.print(" in " + e.getSystemId());
        }
        this.Logger.println(":");
        this.Logger.println("  " + e.getMessage());
        this.Logger.flush();
    }

    public int getErrorCount() {
        return this.ErrorCount;
    }

    public int getWarningCount() {
        return this.WarningCount;
    }

    @Override
    public void error(SAXParseException exception) {
        this.error(this.Prefix + "error", exception);
        ++this.ErrorCount;
    }

    @Override
    public void fatalError(SAXParseException exception) {
        this.error("Fatal " + this.Prefix + "error", exception);
        ++this.ErrorCount;
    }

    @Override
    public void warning(SAXParseException exception) {
        this.error(this.Prefix + "warning", exception);
        ++this.WarningCount;
    }
}

