/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.config;

import com.occamlab.te.config.ConfigComparator;
import com.occamlab.te.config.ConfigEntry;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class ConfigFileBuilder {
    public static void main(String[] args) throws Exception {
        ConfigEntry config;
        File[] scriptDirs;
        String home = "";
        String scriptsDir = "webapps/teamengine/WEB-INF/scripts";
        String workDir = "webapps/teamengine/WEB-INF/work";
        String usersDir = "webapps/teamengine/WEB-INF/users";
        String resourcesDir = null;
        String defaultRevision = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-home=")) {
                home = args[i].substring(6);
                continue;
            }
            if (args[i].startsWith("-scriptsdir=")) {
                scriptsDir = args[i].substring(12);
                continue;
            }
            if (args[i].startsWith("-resourcesdir=")) {
                scriptsDir = args[i].substring(14);
                continue;
            }
            if (args[i].startsWith("-usersdir=")) {
                usersDir = args[i].substring(10);
                continue;
            }
            if (args[i].startsWith("-workdir=")) {
                workDir = args[i].substring(9);
                continue;
            }
            if (!args[i].startsWith("-defaultrev=")) continue;
            defaultRevision = args[i].substring(12);
        }
        if (resourcesDir == null) {
            resourcesDir = scriptsDir;
        }
        TreeSet<ConfigEntry> configs = new TreeSet<ConfigEntry>(new ConfigComparator());
        for (File dir2 : scriptDirs = new File(".").listFiles()) {
            File file = new File(dir2, "config.xml");
            if (!file.canRead()) continue;
            ConfigEntry config2 = new ConfigEntry(file);
            File profilesDir = new File(dir2, "profiles");
            if (profilesDir.isDirectory()) {
                File[] profileDirs;
                for (File pdir : profileDirs = profilesDir.listFiles()) {
                    File pfile = new File(pdir, "config.xml");
                    if (!pfile.canRead()) continue;
                    config2.add(new ConfigEntry(pfile));
                }
            }
            configs.add(config2);
        }
        System.out.println("<config>");
        System.out.println("  <home>" + home + "</home>");
        System.out.println("  <scriptsdir>" + scriptsDir + "</scriptsdir>");
        System.out.println("  <resourcesdir>" + resourcesDir + "</resourcesdir>");
        System.out.println("  <usersdir>" + usersDir + "</usersdir>");
        System.out.println("  <workdir>" + workDir + "</workdir>");
        System.out.println("  <scripts>");
        Iterator it = configs.iterator();
        ConfigEntry configEntry = config = it.hasNext() ? (ConfigEntry)it.next() : null;
        while (config != null) {
            String organization = config.organization;
            System.out.println("    <organization>");
            System.out.println("      <name>" + organization + "</name>");
            while (config != null && config.organization.equals(organization)) {
                String standard = config.standard;
                System.out.println("      <standard>");
                System.out.println("        <name>" + standard + "</name>");
                while (config != null && config.organization.equals(organization) && config.standard.equals(standard)) {
                    String version = config.version;
                    System.out.println("        <version>");
                    System.out.println("          <name>" + version + "</name>");
                    System.out.println("          <suite>");
                    System.out.println("            <namespace-uri>" + config.suite.getNamespaceURI() + "</namespace-uri>");
                    System.out.println("            <prefix>" + config.suite.getPrefix() + "</prefix>");
                    System.out.println("            <local-name>" + config.suite.getLocalPart() + "</local-name>");
                    String title = config.title;
                    if (title == null) {
                        title = organization + " " + standard + " " + version + " Test Suite";
                    }
                    System.out.println("            <title>" + title + "</title>");
                    if (config.description != null) {
                        System.out.println("            <description>" + config.description + "</description>");
                    }
                    if (config.link != null) {
                        System.out.println("            <link>" + config.link + "</link>");
                    }
                    if (config.dataLink != null) {
                        System.out.println("            <link type=\"data\">" + config.dataLink + "</link>");
                    }
                    System.out.println("          </suite>");
                    while (config != null && config.organization.equals(organization) && config.standard.equals(standard) && config.version.equals(version)) {
                        ArrayList<QName> profiles = new ArrayList<QName>();
                        ArrayList<String> profileTitles = new ArrayList<String>();
                        ArrayList<String> profileDescriptions = new ArrayList<String>();
                        ArrayList<File> sources = new ArrayList<File>();
                        while (config != null && config.suite == null) {
                            profiles.addAll(config.profiles);
                            profileTitles.addAll(config.profileTitles);
                            profileDescriptions.addAll(config.profileDescriptions);
                            sources.addAll(config.sources);
                            config = it.hasNext() ? (ConfigEntry)it.next() : null;
                        }
                        if (config == null) continue;
                        profiles.addAll(config.profiles);
                        profileTitles.addAll(config.profileTitles);
                        profileDescriptions.addAll(config.profileDescriptions);
                        sources.addAll(config.sources);
                        String revision = config.revision;
                        if (revision == null) {
                            revision = defaultRevision;
                        }
                        System.out.println("          <revision>");
                        System.out.println("            <name>" + revision + "</name>");
                        System.out.println("            <sources>");
                        for (File source : sources) {
                            String path = source.getPath().substring(2).replace('\\', '/');
                            System.out.println("              <source>" + path + "</source>");
                        }
                        System.out.println("            </sources>");
                        if (config.resources != null) {
                            String path = config.resources.getPath().substring(2).replace('\\', '/');
                            System.out.println("            <resources>" + path + "</resources>");
                        }
                        if (config.webdir != null) {
                            System.out.println("            <webdir>" + config.webdir + "</webdir>");
                        }
                        for (int i = 0; i < profiles.size(); ++i) {
                            System.out.println("            <profile>");
                            System.out.println("              <namespace-uri>" + ((QName)profiles.get(i)).getNamespaceURI() + "</namespace-uri>");
                            System.out.println("              <prefix>" + ((QName)profiles.get(i)).getPrefix() + "</prefix>");
                            System.out.println("              <local-name>" + ((QName)profiles.get(i)).getLocalPart() + "</local-name>");
                            String profileTitle = (String)profileTitles.get(i);
                            if (profileTitle == null) {
                                profileTitle = ((QName)profiles.get(i)).getLocalPart();
                            }
                            System.out.println("              <title>" + profileTitle + "</title>");
                            String profileDescription = (String)profileDescriptions.get(i);
                            if (profileDescription != null) {
                                System.out.println("              <description>" + profileDescription + "</description>");
                            }
                            System.out.println("            </profile>");
                        }
                        System.out.println("          </revision>");
                        config = it.hasNext() ? (ConfigEntry)it.next() : null;
                    }
                    System.out.println("        </version>");
                }
                System.out.println("      </standard>");
            }
            System.out.println("    </organization>");
        }
        System.out.println("  </scripts>");
        System.out.println("</config>");
    }
}

