/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat20.dgiwg10.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class NamespaceBindings
implements NamespaceContext {
    private Map<String, String> bindings = new HashMap<String, String>();

    @Override
    public String getNamespaceURI(String prefix) {
        String nsName = null;
        for (Map.Entry<String, String> binding : this.bindings.entrySet()) {
            if (!binding.getValue().equals(prefix)) continue;
            nsName = binding.getKey();
            break;
        }
        return nsName;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.bindings.get(namespaceURI);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        return Arrays.asList(this.getPrefix(namespaceURI)).iterator();
    }

    public void addNamespaceBinding(String namespaceURI, String prefix) {
        this.bindings.put(namespaceURI, prefix);
    }

    public void addAllBindings(Map<String, String> nsBindings) {
        if (null != nsBindings) {
            this.bindings.putAll(nsBindings);
        }
    }

    public Map<String, String> getAllBindings() {
        return Collections.unmodifiableMap(this.bindings);
    }

    public static NamespaceBindings withStandardBindings() {
        NamespaceBindings nsBindings = new NamespaceBindings();
        nsBindings.addNamespaceBinding("http://www.opengis.net/ows", "ows");
        nsBindings.addNamespaceBinding("http://www.w3.org/1999/xlink", "xlink");
        nsBindings.addNamespaceBinding("http://www.opengis.net/cat/csw/2.0.2", "csw");
        nsBindings.addNamespaceBinding("http://purl.org/dc/elements/1.1/", "dc");
        nsBindings.addNamespaceBinding("http://www.opengis.net/ogc", "ogc");
        nsBindings.addNamespaceBinding("http://www.isotc211.org/2005/gmd", "gmd");
        return nsBindings;
    }

    public String toString() {
        return "NamespaceBindings:\n" + this.bindings;
    }
}

