/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat20.dgiwg10.util;

import java.net.URI;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.opengis.cite.cat20.dgiwg10.ProtocolBinding;
import org.opengis.cite.cat20.dgiwg10.util.NamespaceBindings;
import org.opengis.cite.cat20.dgiwg10.util.TestSuiteLogger;
import org.opengis.cite.cat20.dgiwg10.util.XMLUtils;
import org.w3c.dom.Document;

public class ServiceMetadataUtils {
    public static URI getOperationEndpoint(Document capabilitiesDoc, String opName, ProtocolBinding binding) {
        if (null == binding || binding.equals((Object)ProtocolBinding.ANY)) {
            binding = ServiceMetadataUtils.getOperationBindings(capabilitiesDoc, opName).iterator().next();
        }
        NamespaceBindings nsBindings = NamespaceBindings.withStandardBindings();
        String expr = String.format("//ows:Operation[@name='%s']//ows:%s/@xlink:href", opName, binding.getElementName());
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(nsBindings);
        URI endpoint = null;
        try {
            String href = xpath.evaluate(expr, capabilitiesDoc);
            endpoint = URI.create(href);
        }
        catch (XPathExpressionException ex) {
            TestSuiteLogger.log(Level.INFO, ex.getMessage());
        }
        String queryString = endpoint.getQuery();
        if (queryString != null) {
            String uri = endpoint.toString();
            if (queryString.trim().isEmpty()) {
                endpoint = URI.create(uri.substring(0, uri.indexOf(63)));
            } else if (!uri.endsWith("&")) {
                endpoint = URI.create(uri + "&");
            }
        }
        return endpoint;
    }

    public static Set<ProtocolBinding> getOperationBindings(Document capabilitiesDoc, String opName) {
        HashSet<ProtocolBinding> protoBindings = new HashSet<ProtocolBinding>();
        String expr = "//ows:Operation[@name='%s']//ows:%s";
        for (ProtocolBinding binding : EnumSet.allOf(ProtocolBinding.class)) {
            String elementName = binding.getElementName();
            if (elementName == null) continue;
            String xpath = String.format(expr, opName, elementName);
            try {
                if (XMLUtils.evaluateXPath(capabilitiesDoc, xpath, null).getLength() <= 0) continue;
                protoBindings.add(binding);
            }
            catch (XPathExpressionException xpe) {
                throw new RuntimeException("Error evaluating XPath expression against capabilities doc. ", xpe);
            }
        }
        return protoBindings;
    }
}

