/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat20.dgiwg10.util;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.opengis.cite.cat20.dgiwg10.util.NamespaceBindings;
import org.opengis.cite.cat20.dgiwg10.util.TestSuiteLogger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtils {
    private static final XPathFactory XPATH_FACTORY = XMLUtils.initXPathFactory();

    private static XPathFactory initXPathFactory() {
        XPathFactory factory = XPathFactory.newInstance();
        return factory;
    }

    public static String writeNodeToString(Node node) {
        if (null == node) {
            return "";
        }
        Object writer = null;
        try {
            Transformer idTransformer = TransformerFactory.newInstance().newTransformer();
            Properties outProps = new Properties();
            outProps.setProperty("encoding", "US-ASCII");
            outProps.setProperty("omit-xml-declaration", "yes");
            outProps.setProperty("indent", "yes");
            idTransformer.setOutputProperties(outProps);
            writer = new StringWriter();
            idTransformer.transform(new DOMSource(node), new StreamResult((Writer)writer));
        }
        catch (TransformerException ex) {
            TestSuiteLogger.log(Level.WARNING, "Failed to serialize node " + node.getNodeName(), ex);
        }
        return writer.toString();
    }

    public static NodeList evaluateXPath(Node context, String expr, Map<String, String> namespaceBindings) throws XPathExpressionException {
        Object result = XMLUtils.evaluateXPath(context, expr, namespaceBindings, XPathConstants.NODESET);
        if (!NodeList.class.isInstance(result)) {
            throw new XPathExpressionException("Expression does not evaluate to a NodeList: " + expr);
        }
        return (NodeList)result;
    }

    public static Object evaluateXPath(Node context, String expr, Map<String, String> namespaceBindings, QName returnType) throws XPathExpressionException {
        NamespaceBindings bindings = NamespaceBindings.withStandardBindings();
        bindings.addAllBindings(namespaceBindings);
        XPathFactory factory = XPATH_FACTORY;
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(bindings);
        Object result = xpath.evaluate(expr, context, returnType);
        return result;
    }

    public static int parseAsInteger(Node context, String xpath) throws XPathExpressionException {
        try {
            String valueAsString = (String)XMLUtils.evaluateXPath(context, xpath, null, XPathConstants.STRING);
            return Integer.parseInt(valueAsString);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }
}

