/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat20.dgiwg10.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opengis.cite.cat20.dgiwg10.util.ElementSetName;
import org.opengis.cite.cat20.dgiwg10.util.OutputSchema;
import org.opengis.cite.cat20.dgiwg10.util.TestSuiteLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RequestCreator {
    private static final Logger LOG = Logger.getLogger(RequestCreator.class.getName());
    private DocumentBuilder docBuilder;

    public RequestCreator() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            this.docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to create DOM parser", e);
        }
    }

    public Document createGetRecordsRequest(OutputSchema outputSchema, ElementSetName elementSetName) {
        return this.createGetRecordsRequest(outputSchema, elementSetName, null);
    }

    public Document createGetRecordsRequest(OutputSchema outputSchema, ElementSetName elementSetName, Node filter) {
        Document request;
        try {
            InputStream requestAsStream = this.getClass().getResourceAsStream("/org/opengis/cite/cat20/dgiwg10/getrecords/GetRecords-request.xml");
            request = this.docBuilder.parse(requestAsStream);
        }
        catch (IOException | SAXException e) {
            LOG.log(Level.SEVERE, "GetRecords request could not be created", e);
            throw new IllegalArgumentException("GetRecords request could not be created");
        }
        Element getRecords = request.getDocumentElement();
        getRecords.setAttribute("outputSchema", outputSchema.getOutputSchema());
        Element query = (Element)getRecords.getElementsByTagNameNS("http://www.opengis.net/cat/csw/2.0.2", "Query").item(0);
        query.setAttribute("typeNames", outputSchema.getTypeName());
        Element elementSetNameElement = (Element)query.getElementsByTagNameNS("http://www.opengis.net/cat/csw/2.0.2", "ElementSetName").item(0);
        elementSetNameElement.setTextContent(elementSetName.name().toLowerCase());
        this.appendFilter(request, query, filter);
        return request;
    }

    public Document createGetRecordById(OutputSchema outputSchema, ElementSetName elementSetName, String identifier) {
        Document request;
        try {
            InputStream requestAsStream = this.getClass().getResourceAsStream("/org/opengis/cite/cat20/dgiwg10/getrecordbyid/GetRecordById-request.xml");
            request = this.docBuilder.parse(requestAsStream);
        }
        catch (IOException | SAXException e) {
            LOG.log(Level.SEVERE, "GetRecords request could not be created", e);
            throw new IllegalArgumentException("GetRecords request could not be created");
        }
        Element getRecordById = request.getDocumentElement();
        getRecordById.setAttribute("outputSchema", outputSchema.getOutputSchema());
        Element id = (Element)getRecordById.getElementsByTagNameNS("http://www.opengis.net/cat/csw/2.0.2", "Id").item(0);
        id.setTextContent(identifier);
        Element elementSetNameElement = (Element)getRecordById.getElementsByTagNameNS("http://www.opengis.net/cat/csw/2.0.2", "ElementSetName").item(0);
        elementSetNameElement.setTextContent(elementSetName.name().toLowerCase());
        return request;
    }

    public Document createInsertRequest(RECORDTYPE recordType) {
        try {
            String requestResource = this.getInsertRequestResource(recordType);
            InputStream requestAsStream = this.getClass().getResourceAsStream(requestResource);
            return this.docBuilder.parse(requestAsStream);
        }
        catch (IOException | SAXException e) {
            LOG.log(Level.SEVERE, "Insert request could not be created", e);
            throw new IllegalArgumentException("Insert request could not be created");
        }
    }

    public Document createUpdateRequest(RECORDTYPE recordType) {
        try {
            String requestResource = this.getUpdateRequestResource(recordType);
            InputStream requestAsStream = this.getClass().getResourceAsStream(requestResource);
            return this.docBuilder.parse(requestAsStream);
        }
        catch (IOException | SAXException e) {
            LOG.log(Level.SEVERE, "Update request could not be created", e);
            throw new IllegalArgumentException("Update request could not be created");
        }
    }

    public Document createDeleteRequest(String identifier) {
        Document document;
        try {
            InputStream requestAsStream = this.getClass().getResourceAsStream("/org/opengis/cite/cat20/dgiwg10/transaction/delete-request.xml");
            document = this.docBuilder.parse(requestAsStream);
        }
        catch (IOException | SAXException e) {
            LOG.log(Level.SEVERE, "Delete request could not be created", e);
            throw new IllegalArgumentException("Delete request could not be created");
        }
        Element transaction = document.getDocumentElement();
        Element delete = (Element)transaction.getElementsByTagNameNS("http://www.opengis.net/cat/csw/2.0.2", "Delete").item(0);
        Element constraint = (Element)delete.getElementsByTagNameNS("http://www.opengis.net/cat/csw/2.0.2", "Constraint").item(0);
        Element filter = (Element)constraint.getElementsByTagNameNS("http://www.opengis.net/ogc", "Filter").item(0);
        Element propertyIsEqualTo = (Element)filter.getElementsByTagNameNS("http://www.opengis.net/ogc", "PropertyIsEqualTo").item(0);
        Element literal = (Element)propertyIsEqualTo.getElementsByTagNameNS("http://www.opengis.net/ogc", "Literal").item(0);
        literal.setTextContent(identifier);
        return document;
    }

    public Document createHarvest(String source) {
        Document document;
        try {
            InputStream requestAsStream = this.getClass().getResourceAsStream("/org/opengis/cite/cat20/dgiwg10/transaction/harvest-request.xml");
            document = this.docBuilder.parse(requestAsStream);
        }
        catch (IOException | SAXException e) {
            LOG.log(Level.SEVERE, "Delete request could not be created", e);
            throw new IllegalArgumentException("Delete request could not be created");
        }
        Element harvest = document.getDocumentElement();
        Element sourceElement = (Element)harvest.getElementsByTagNameNS("http://www.opengis.net/cat/csw/2.0.2", "Source").item(0);
        sourceElement.setTextContent(source);
        return document;
    }

    private void appendFilter(Document request, Element query, Node filter) {
        if (filter == null) {
            return;
        }
        if (!"Filter".equals(filter.getLocalName())) {
            throw new IllegalArgumentException("filter has no local name 'Filter'");
        }
        Element constraint = request.createElementNS("http://www.opengis.net/cat/csw/2.0.2", "Constraint");
        constraint.setAttribute("version", "1.1.0");
        constraint.appendChild(request.importNode(filter, true));
        query.appendChild(constraint);
    }

    private String getInsertRequestResource(RECORDTYPE recordType) {
        String name = RECORDTYPE.SERVICE.equals((Object)recordType) ? "/org/opengis/cite/cat20/dgiwg10/transaction/insert-DMFMetadata-service-request.xml" : "/org/opengis/cite/cat20/dgiwg10/transaction/insert-DMFMetadata-request.xml";
        return name;
    }

    private String getUpdateRequestResource(RECORDTYPE recordType) {
        String name = RECORDTYPE.SERVICE.equals((Object)recordType) ? "/org/opengis/cite/cat20/dgiwg10/transaction/update-DMFMetadata-request.xml" : "/org/opengis/cite/cat20/dgiwg10/transaction/update-DMFMetadata-service-request.xml";
        return name;
    }

    public static enum RECORDTYPE {
        SERVICE,
        DATASET;

    }
}

