/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Random;
import org.testng.reporters.Files;
import org.testng.reporters.IBuffer;

public class FileStringBuffer
implements IBuffer {
    private static int MAX = 100000;
    private static final boolean VERBOSE = System.getProperty("fileStringBuffer") != null;
    private File m_file;
    private StringBuilder m_sb = new StringBuilder();
    private final int m_maxCharacters;

    public FileStringBuffer() {
        this(MAX);
    }

    public FileStringBuffer(int maxCharacters) {
        this.m_maxCharacters = maxCharacters;
    }

    @Override
    public FileStringBuffer append(CharSequence s2) {
        if (s2 == null) {
            throw new IllegalArgumentException("CharSequence (Argument 0 of FileStringBuffer#append) should not be null");
        }
        if (this.m_sb.length() > this.m_maxCharacters) {
            this.flushToFile();
        }
        if (s2.length() < MAX) {
            this.m_sb.append(s2);
        } else {
            this.flushToFile();
            try {
                FileStringBuffer.copy(new StringReader(s2.toString()), new FileWriter(this.m_file, true));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    @Override
    public void toWriter(Writer fw) {
        if (fw == null) {
            throw new IllegalArgumentException("Writer (Argument 0 of FileStringBuffer#toWriter) should not be null");
        }
        try {
            BufferedWriter bw = new BufferedWriter(fw);
            if (this.m_file == null) {
                bw.write(this.m_sb.toString());
                bw.close();
            } else {
                this.flushToFile();
                FileStringBuffer.copy(new FileReader(this.m_file), bw);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void copy(Reader input, Writer output) throws IOException {
        int length;
        char[] buf = new char[MAX];
        while ((length = input.read(buf)) >= 0) {
            output.write(buf, 0, length);
        }
        try {
            input.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        try {
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void flushToFile() {
        if (this.m_sb.length() == 0) {
            return;
        }
        if (this.m_file == null) {
            try {
                this.m_file = File.createTempFile("testng", "fileStringBuffer");
                this.m_file.deleteOnExit();
                FileStringBuffer.p("Created temp file " + this.m_file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileStringBuffer.p("Size " + this.m_sb.length() + ", flushing to " + this.m_file);
        try (FileWriter fw = new FileWriter(this.m_file, true);){
            fw.append(this.m_sb);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_sb = new StringBuilder();
    }

    private static void p(String s2) {
        if (VERBOSE) {
            System.out.println("[FileStringBuffer] " + s2);
        }
    }

    public String toString() {
        String result = null;
        if (this.m_file != null) {
            this.flushToFile();
            try {
                result = Files.readFile(this.m_file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            result = this.m_sb.toString();
        }
        return result;
    }

    private static void save(File expected, String s2) throws IOException {
        expected.delete();
        try (FileWriter expectedWriter = new FileWriter(expected);){
            expectedWriter.append(s2);
        }
    }

    public static void main(String[] args) throws IOException {
        String s2 = "abcdefghijklmnopqrstuvwxyz";
        FileStringBuffer fsb = new FileStringBuffer(10);
        StringBuilder control = new StringBuilder();
        Random r = new Random();
        for (int i = 0; i < 1000; ++i) {
            int start = Math.abs(r.nextInt() % 26);
            int length = Math.abs(r.nextInt() % (26 - start));
            String fragment = s2.substring(start, start + length);
            FileStringBuffer.p("... Appending " + fragment);
            fsb.append(fragment);
            control.append(fragment);
        }
        File expected = new File("/tmp/expected");
        expected.delete();
        FileWriter expectedWriter = new FileWriter(expected);
        expectedWriter.append(control);
        expectedWriter.close();
        File actual = new File("/tmp/actual");
        actual.delete();
        FileWriter actualWriter = new FileWriter(actual);
        fsb.toWriter(actualWriter);
        actualWriter.close();
    }
}

