/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat20.dgiwg10;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opengis.cite.cat20.dgiwg10.ETSAssert;
import org.opengis.cite.cat20.dgiwg10.SuiteAttribute;
import org.opengis.cite.cat20.dgiwg10.util.DataSampler;
import org.testng.ISuite;
import org.testng.ITestContext;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SuitePreconditions {
    private static final Logger LOGR = Logger.getLogger(SuitePreconditions.class.getName());

    @BeforeSuite
    public void verifyTestSubject(ITestContext testContext) {
        SuiteAttribute testFileAttr = SuiteAttribute.TEST_SUBJ_FILE;
        Object sutObj = testContext.getSuite().getAttribute(testFileAttr.getName());
        Class expectedType = testFileAttr.getType();
        if (sutObj == null || !expectedType.isInstance(sutObj)) {
            String msg = String.format("Value of test suite attribute '%s' is missing or is not an instance of %s", testFileAttr.getName(), expectedType.getName());
            LOGR.log(Level.SEVERE, msg);
            throw new AssertionError((Object)msg);
        }
    }

    @Test(description="Test subject is WFS 2.0 service")
    public void verifyCapabilities(ITestContext testContext) {
        Document capabilitiesDocument = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        ETSAssert.assertQualifiedName(capabilitiesDocument, "http://www.opengis.net/cat/csw/2.0.2", "Capabilities");
    }

    @Test(description="SUT has data", dependsOnMethods={"verifyCapabilities"})
    public void dataAreAvailable(ITestContext testContext) {
        boolean sutHasData;
        ISuite suite = testContext.getSuite();
        Document capabilitiesDocument = (Document)suite.getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        DataSampler sampler = new DataSampler(capabilitiesDocument);
        suite.setAttribute(SuiteAttribute.DATA_SAMPLER.getName(), (Object)sampler);
        try {
            sampler.acquireRecords();
        }
        catch (RuntimeException rx) {
            StringBuilder msg = new StringBuilder("Failed to acquire feature data (");
            msg.append(rx.getClass().getName()).append("): ");
            msg.append(rx.getMessage());
            throw new AssertionError((Object)msg.toString());
        }
        Map<String, Node> records = sampler.getRecords();
        boolean bl = sutHasData = !records.isEmpty();
        if (!sutHasData) {
            String msg = "No test data available. Service must provide at least one record for testing";
            LOGR.warning(msg);
            throw new AssertionError((Object)msg);
        }
    }
}

