/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileReader;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;

public class TeErrorListener
implements ErrorListener {
    private char[] scriptChars = null;
    private int ErrorCount = 0;
    private int WarningCount = 0;
    private boolean active = true;
    private static Logger logger = Logger.getLogger("com.occamlab.te.TeErrorListener");

    public TeErrorListener() {
    }

    public TeErrorListener(char[] script_chars) {
        this.scriptChars = script_chars;
    }

    public int getErrorCount() {
        return this.ErrorCount;
    }

    public int getWarningCount() {
        return this.WarningCount;
    }

    private void error(String type, TransformerException exception) {
        if (this.scriptChars == null) {
            if (this.active) {
                System.err.println(type + ": " + exception.getMessageAndLocation());
            }
            return;
        }
        try {
            BufferedReader in;
            String systemId = exception.getLocator().getSystemId();
            if (systemId.length() == 0) {
                in = new BufferedReader(new CharArrayReader(this.scriptChars));
            } else {
                File txsl_file = new File(new URI(systemId));
                in = new BufferedReader(new FileReader(txsl_file));
            }
            int txsl_linenum = exception.getLocator().getLineNumber();
            Object location = "unknown location";
            boolean closed = true;
            for (int current_line = 1; current_line <= txsl_linenum || !closed; ++current_line) {
                String line = in.readLine();
                if (line == null) {
                    location = "unknown location";
                    break;
                }
                int pos = line.indexOf("te:loc=\"");
                if (pos >= 0) {
                    int comma = line.indexOf(",", pos);
                    int end_quote = line.indexOf("\"", comma);
                    location = "line " + line.substring(pos + 8, comma) + " of " + line.substring(comma + 1, end_quote);
                }
                if (current_line < txsl_linenum) continue;
                closed = line.indexOf(">") > 0;
            }
            in.close();
            System.err.println(type + " at " + (String)location + ":");
            System.err.println("  " + exception.getMessage() + " in intermediate stylesheet" + exception.getLocationAsString());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
            System.err.println(type + ": " + exception.getMessageAndLocation());
        }
    }

    @Override
    public void error(TransformerException exception) {
        this.error("Error", exception);
        ++this.ErrorCount;
    }

    @Override
    public void fatalError(TransformerException exception) {
        this.error("Fatal Error", exception);
        ++this.ErrorCount;
    }

    @Override
    public void warning(TransformerException exception) {
        this.error("Warning Error", exception);
        ++this.WarningCount;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

