/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class URLConnectionUtils {
    private static final Logger LOGR = Logger.getLogger(URLConnectionUtils.class.getName());

    public static InputStream getInputStream(URLConnection uc) throws IOException {
        InputStream is;
        block3: {
            is = null;
            try {
                is = uc.getInputStream();
            }
            catch (IOException ioe) {
                if (LOGR.isLoggable(Level.FINE)) {
                    String msg = String.format("Failed to resolve URL %s.\nTrying error stream...\n %s", uc.getURL(), ioe.getMessage());
                    LOGR.fine(msg);
                }
                if (!HttpURLConnection.class.isInstance(uc)) break block3;
                HttpURLConnection huc = (HttpURLConnection)uc;
                is = huc.getErrorStream();
            }
        }
        return is;
    }

    static {
        try {
            System.setProperty("sun.net.http.errorstream.enableBuffering", "true");
            System.setProperty("sun.net.http.errorstream.timeout", "600");
        }
        catch (Exception e) {
            LOGR.warning("Failed to enable buffering of error stream.\n" + e.getMessage());
            e.fillInStackTrace();
            e.printStackTrace(System.err);
        }
    }
}

