/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat20.dgiwg10;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.opengis.cite.cat20.dgiwg10.ErrorMessage;
import org.opengis.cite.cat20.dgiwg10.util.NamespaceBindings;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ETSAssert {
    private static final Logger LOGR = Logger.getLogger(ETSAssert.class.getPackage().getName());

    private ETSAssert() {
    }

    public static void assertStatusCode(int statusCode, int expectedStatusCode) {
        if (statusCode != expectedStatusCode) {
            throw new AssertionError((Object)ErrorMessage.format("UnexpectedStatus", new Object[0]));
        }
    }

    public static void assertXmlContentType(MultivaluedMap<String, Object> headers) {
        List contentType = (List)headers.get("Content-Type");
        boolean hasContentTypeXml = ETSAssert.hasContentTypeXml(contentType);
        if (!hasContentTypeXml) {
            throw new AssertionError((Object)"UnexpectedMediaType");
        }
    }

    public static void assertTrue(boolean valueToAssert, String failureMsg) {
        if (!valueToAssert) {
            throw new AssertionError((Object)failureMsg);
        }
    }

    public static void assertQualifiedName(Document document, String namespaceUri, String localName) {
        ETSAssert.assertQualifiedName(document.getDocumentElement(), namespaceUri, localName);
    }

    public static void assertQualifiedName(Node node, String namespaceUri, String localName) {
        Assert.assertEquals(node.getLocalName(), localName, ErrorMessage.get("LocalName"));
        Assert.assertEquals(node.getNamespaceURI(), namespaceUri, ErrorMessage.get("NamespaceName"));
    }

    public static void assertXPath(Node context, String expr) {
        ETSAssert.assertXPath(context, expr, null, null);
    }

    public static void assertXPath(Node context, String expr, Map<String, String> namespaceBindings) {
        ETSAssert.assertXPath(context, expr, namespaceBindings, null);
    }

    public static void assertXPath(Node context, String expr, Map<String, String> namespaceBindings, String assertionErrorMessage) {
        Boolean result;
        if (null == context) {
            throw new NullPointerException("Context node is null.");
        }
        NamespaceBindings bindings = NamespaceBindings.withStandardBindings();
        bindings.addAllBindings(namespaceBindings);
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(bindings);
        try {
            result = (Boolean)xpath.evaluate(expr, context, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException xpe) {
            String msg = ErrorMessage.format("XPathError", expr);
            LOGR.log(Level.WARNING, msg, xpe);
            throw new AssertionError((Object)msg);
        }
        Element elemNode = Document.class.isInstance(context) ? ((Document)Document.class.cast(context)).getDocumentElement() : (Element)context;
        String errorMessage = assertionErrorMessage;
        if (errorMessage == null) {
            errorMessage = ErrorMessage.format("XPathResult", elemNode.getNodeName(), expr);
        }
        ETSAssert.assertTrue(result, errorMessage);
    }

    public static void assertSchemaValid(Validator validator, Source source) {
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        validator.setErrorHandler(errHandler);
        try {
            validator.validate(source);
        }
        catch (Exception e) {
            throw new AssertionError((Object)ErrorMessage.format("XMLError", e.getMessage()));
        }
        Assert.assertFalse(errHandler.errorsDetected(), ErrorMessage.format("NotSchemaValid", errHandler.getErrorCount(), errHandler.toString()));
    }

    private static boolean hasContentTypeXml(List<Object> contentType) {
        for (Object ct : contentType) {
            if (!(ct instanceof String)) {
                return false;
            }
            if (!((String)ct).contains("xml")) continue;
            return true;
        }
        return false;
    }
}

