/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat20.dgiwg10;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.opengis.cite.cat20.dgiwg10.CommonFixture;
import org.opengis.cite.cat20.dgiwg10.util.XMLUtils;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.w3c.dom.Document;

public class TestFailureListener
extends TestListenerAdapter {
    @Override
    public void onTestFailure(ITestResult result) {
        super.onTestFailure(result);
        Object instance = result.getInstance();
        if (CommonFixture.class.isInstance(instance)) {
            CommonFixture fixture = (CommonFixture)CommonFixture.class.cast(instance);
            result.setAttribute("request", this.getRequestMessageInfo(fixture.requestDocument));
            result.setAttribute("response", this.getResponseMessageInfo(fixture.response, fixture.responseDocument));
        }
    }

    String getRequestMessageInfo(Document requestDocument) {
        if (requestDocument != null) {
            return XMLUtils.writeNodeToString(requestDocument);
        }
        return "No request document.";
    }

    String getResponseMessageInfo(Response rsp, Document responseDocument) {
        if (null == rsp) {
            return "No response message.";
        }
        StringBuilder msgInfo = new StringBuilder();
        msgInfo.append("Status: ").append(rsp.getStatus()).append('\n');
        msgInfo.append("Headers: ").append(rsp.getHeaders()).append('\n');
        if (responseDocument != null && rsp.getMediaType().isCompatible(MediaType.APPLICATION_XML_TYPE)) {
            msgInfo.append(XMLUtils.writeNodeToString(responseDocument));
            msgInfo.append('\n');
        }
        return msgInfo.toString();
    }
}

