/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat20.dgiwg10.transaction;

import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.cat20.dgiwg10.ETSAssert;
import org.opengis.cite.cat20.dgiwg10.transaction.TransactionalOperation;
import org.opengis.cite.cat20.dgiwg10.util.ElementSetName;
import org.opengis.cite.cat20.dgiwg10.util.OutputSchema;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class Harvest
extends TransactionalOperation {
    private static final String RECORD_TO_HARVEST = "https://opengeospatial.github.io/ets-cat20-dgiwg10/DMFMetadataRecord.xml";

    @Override
    String getOperationName() {
        return "Harvest";
    }

    @Test(description="Precondition of A.1.4 DGIWG Transactional CSW - Harvest Request (Harvest DCP URL must be available)", dependsOnGroups={"isTransactional"})
    public void supportsHarvesting() {
        Assert.assertNotNull(this.transactionUrl, "DCP URL for Operation 'Harvest' is not available");
    }

    @Test(description="Implements A.1.4 DGIWG Transactional CSW - Harvest Request (Requirement 20)", dependsOnMethods={"supportsHarvesting"})
    public void issueHarvestRequest() {
        this.requestDocument = this.requestCreator.createHarvest(RECORD_TO_HARVEST);
        this.response = this.cswClient.submitPostRequest(this.transactionUrl, this.requestDocument, TRANSACTION_USERNAME, TRANSACTION_PASSWORD);
        ETSAssert.assertStatusCode(this.response.getStatus(), 200);
        ETSAssert.assertXmlContentType(this.response.getHeaders());
        this.responseDocument = this.response.readEntity(Document.class);
        ETSAssert.assertQualifiedName(this.responseDocument, "http://www.opengis.net/cat/csw/2.0.2", "HarvestResponse");
        ETSAssert.assertSchemaValid(this.cswValidator, new DOMSource(this.responseDocument));
        int totalInserted = this.parseTotalInserted();
        ETSAssert.assertTrue(totalInserted == 1, "Expected totalInserted 1 but was " + totalInserted);
        this.id = this.parseIdentifier();
        ETSAssert.assertTrue(this.id != null, "Response does not contain the identifier of the harvested record.");
    }

    @Test(description="Implements A.1.4 DGIWG Transactional CSW - Ensure Harvest (Requirement 20)", dependsOnMethods={"issueHarvestRequest"})
    public void issueGetRecordById_EnsureHarvest() {
        this.requestDocument = this.requestCreator.createGetRecordById(OutputSchema.DC, ElementSetName.FULL, this.id);
        this.response = this.cswClient.submitPostRequest(this.transactionUrl, this.requestDocument, TRANSACTION_USERNAME, TRANSACTION_PASSWORD);
        ETSAssert.assertStatusCode(this.response.getStatus(), 200);
        ETSAssert.assertXmlContentType(this.response.getHeaders());
        this.responseDocument = this.response.readEntity(Document.class);
        String xpath = String.format("//csw:Record[dc:identifier = '%s']", this.id);
        ETSAssert.assertXPath(this.responseDocument, xpath);
    }
}

