/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat20.dgiwg10.transaction;

import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.cat20.dgiwg10.ETSAssert;
import org.opengis.cite.cat20.dgiwg10.transaction.TransactionalOperation;
import org.opengis.cite.cat20.dgiwg10.util.ElementSetName;
import org.opengis.cite.cat20.dgiwg10.util.OutputSchema;
import org.opengis.cite.cat20.dgiwg10.xml.RequestCreator;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class TransactionDataset
extends TransactionalOperation {
    @Override
    String getOperationName() {
        return "Transaction";
    }

    @Test(description="Implements A.1.4 DGIWG Transactional CSW - Insert (Requirement 18)", dependsOnGroups={"isTransactional"})
    public void issueInsertOperation_Dataset() {
        this.requestDocument = this.requestCreator.createInsertRequest(RequestCreator.RECORDTYPE.DATASET);
        this.response = this.cswClient.submitPostRequest(this.transactionUrl, this.requestDocument, TRANSACTION_USERNAME, TRANSACTION_PASSWORD);
        ETSAssert.assertStatusCode(this.response.getStatus(), 200);
        ETSAssert.assertXmlContentType(this.response.getHeaders());
        this.responseDocument = this.response.readEntity(Document.class);
        ETSAssert.assertQualifiedName(this.responseDocument, "http://www.opengis.net/cat/csw/2.0.2", "TransactionResponse");
        ETSAssert.assertSchemaValid(this.cswValidator, new DOMSource(this.responseDocument));
        int totalInserted = this.parseTotalInserted();
        ETSAssert.assertTrue(totalInserted == 1, "Expected totalInserted 1 but was " + totalInserted);
        this.id = this.parseIdentifier();
        ETSAssert.assertTrue(this.id != null, "Response does not contain the identifier of the inserted record.");
    }

    @Test(description="Implements A.1.4 DGIWG Transactional CSW - Ensure Insert (Requirement 18)", dependsOnMethods={"issueInsertOperation_Dataset"})
    public void issueGetRecords_EnsureInsert_Dataset() {
        this.requestDocument = this.requestCreator.createGetRecordById(OutputSchema.DC, ElementSetName.FULL, this.id);
        this.response = this.cswClient.submitPostRequest(this.transactionUrl, this.requestDocument, TRANSACTION_USERNAME, TRANSACTION_PASSWORD);
        ETSAssert.assertStatusCode(this.response.getStatus(), 200);
        ETSAssert.assertXmlContentType(this.response.getHeaders());
        this.responseDocument = this.response.readEntity(Document.class);
        String xpath = String.format("//csw:Record[dc:identifier = '%s']", this.id);
        ETSAssert.assertXPath(this.responseDocument, xpath);
    }

    @Test(description="Implements A.1.4 DGIWG Transactional CSW - Update (Requirement 18)", dependsOnMethods={"issueGetRecords_EnsureInsert_Dataset"})
    public void issueUpdateOperation_Dataset() {
        this.requestDocument = this.requestCreator.createUpdateRequest(RequestCreator.RECORDTYPE.DATASET);
        this.response = this.cswClient.submitPostRequest(this.transactionUrl, this.requestDocument, TRANSACTION_USERNAME, TRANSACTION_PASSWORD);
        ETSAssert.assertStatusCode(this.response.getStatus(), 200);
        ETSAssert.assertXmlContentType(this.response.getHeaders());
        this.responseDocument = this.response.readEntity(Document.class);
        ETSAssert.assertQualifiedName(this.responseDocument, "http://www.opengis.net/cat/csw/2.0.2", "TransactionResponse");
        ETSAssert.assertSchemaValid(this.cswValidator, new DOMSource(this.responseDocument));
        int totalUpdated = this.parseTotalUpdated();
        ETSAssert.assertTrue(totalUpdated == 1, "Expected totalUpdated 1 but was " + totalUpdated);
    }

    @Test(description="Implements A.1.4 DGIWG Transactional CSW - Ensure Update (Requirement 18)", dependsOnMethods={"issueUpdateOperation_Dataset"})
    public void issueGetRecords_EnsureUpdate_Dataset() {
        this.requestDocument = this.requestCreator.createGetRecordById(OutputSchema.DC, ElementSetName.FULL, this.id);
        this.response = this.cswClient.submitPostRequest(this.transactionUrl, this.requestDocument, TRANSACTION_USERNAME, TRANSACTION_PASSWORD);
        ETSAssert.assertStatusCode(this.response.getStatus(), 200);
        ETSAssert.assertXmlContentType(this.response.getHeaders());
        this.responseDocument = this.response.readEntity(Document.class);
        String xpath = String.format("//csw:Record[dc:identifier = '%s']", this.id);
        ETSAssert.assertXPath(this.responseDocument, xpath);
    }

    @Test(description="Implements A.1.4 DGIWG Transactional CSW - Update (Requirement 18)", dependsOnMethods={"issueGetRecords_EnsureUpdate_Dataset"})
    public void issueDeleteOperation_Dataset() {
        this.requestDocument = this.requestCreator.createDeleteRequest(this.id);
        this.response = this.cswClient.submitPostRequest(this.transactionUrl, this.requestDocument, TRANSACTION_USERNAME, TRANSACTION_PASSWORD);
        ETSAssert.assertStatusCode(this.response.getStatus(), 200);
        ETSAssert.assertXmlContentType(this.response.getHeaders());
        this.responseDocument = this.response.readEntity(Document.class);
        ETSAssert.assertQualifiedName(this.responseDocument, "http://www.opengis.net/cat/csw/2.0.2", "TransactionResponse");
        ETSAssert.assertSchemaValid(this.cswValidator, new DOMSource(this.responseDocument));
        int totalDeleted = this.parseTotalDeleted();
        ETSAssert.assertTrue(totalDeleted == 1, "Expected totalDeleted 1 but was " + totalDeleted);
        this.id = null;
    }

    @Test(description="Implements A.1.4 DGIWG Transactional CSW - Ensure Delete (Requirement 18)", dependsOnMethods={"issueDeleteOperation_Dataset"})
    public void issueGetRecords_EnsureDelete_Dataset() {
        this.requestDocument = this.requestCreator.createGetRecordById(OutputSchema.DC, ElementSetName.FULL, this.id);
        this.response = this.cswClient.submitPostRequest(this.transactionUrl, this.requestDocument, TRANSACTION_USERNAME, TRANSACTION_PASSWORD);
        ETSAssert.assertStatusCode(this.response.getStatus(), 200);
        ETSAssert.assertXmlContentType(this.response.getHeaders());
        this.responseDocument = this.response.readEntity(Document.class);
        String xpath = String.format("not(//csw:Record[dc:identifier = '%s'])", this.id);
        ETSAssert.assertXPath(this.responseDocument, xpath);
    }
}

