/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat20.dgiwg10.transaction;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.cat20.dgiwg10.CommonFixture;
import org.opengis.cite.cat20.dgiwg10.ProtocolBinding;
import org.opengis.cite.cat20.dgiwg10.util.ServiceMetadataUtils;
import org.opengis.cite.cat20.dgiwg10.util.TestSuiteLogger;
import org.opengis.cite.cat20.dgiwg10.util.ValidationUtils;
import org.opengis.cite.cat20.dgiwg10.util.XMLUtils;
import org.opengis.cite.cat20.dgiwg10.xml.RequestCreator;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public abstract class TransactionalOperation
extends CommonFixture {
    protected final RequestCreator requestCreator = new RequestCreator();
    protected URI transactionUrl;
    protected Validator cswValidator;
    protected String id;
    protected static final String TRANSACTION_USERNAME = System.getProperty("trn.user");
    protected static final String TRANSACTION_PASSWORD = System.getProperty("trn.pw");

    @BeforeClass
    public void buildValidators() {
        URL cswSchemaUrl = this.getClass().getResource("/org/opengis/cite/cat20/dgiwg10/xsd/csw/2.0.2/csw.xsd");
        try {
            Schema cswSchema = ValidationUtils.createSchema(cswSchemaUrl.toURI());
            this.cswValidator = cswSchema.newValidator();
        }
        catch (URISyntaxException e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to build XML Schema Validator for csw.xsd.", e);
        }
    }

    @BeforeClass
    public void setTransactionPostUrl() {
        this.transactionUrl = ServiceMetadataUtils.getOperationEndpoint(this.capabilitiesDoc, this.getOperationName(), ProtocolBinding.POST);
    }

    @AfterClass
    public void removeInsertedRecords() {
        if (this.id != null) {
            this.requestDocument = this.requestCreator.createDeleteRequest(this.id);
            this.response = this.cswClient.submitPostRequest(this.transactionUrl, this.requestDocument, TRANSACTION_USERNAME, TRANSACTION_PASSWORD);
        }
    }

    abstract String getOperationName();

    protected String parseIdentifier() {
        try {
            String xpath = "//csw:InsertResult/csw:BriefRecord/dc:identifier";
            return (String)XMLUtils.evaluateXPath(this.responseDocument, xpath, null, XPathConstants.STRING);
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    protected int parseTotalInserted() {
        return this.parseAsInteger("//csw:TransactionResponse/csw:TransactionSummary/csw:totalInserted");
    }

    protected int parseTotalUpdated() {
        return this.parseAsInteger("//csw:TransactionResponse/csw:TransactionSummary/csw:totalUpdated");
    }

    protected int parseTotalDeleted() {
        return this.parseAsInteger("//csw:TransactionResponse/csw:TransactionSummary/csw:totalDeleted");
    }

    private int parseAsInteger(String s) {
        try {
            return XMLUtils.parseAsInteger(this.responseDocument, s);
        }
        catch (XPathExpressionException e) {
            return -1;
        }
    }
}

