/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat20.dgiwg10.xml;

import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opengis.cite.cat20.dgiwg10.util.OutputSchema;
import org.opengis.cite.cat20.dgiwg10.util.TestSuiteLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FilterCreator {
    private DocumentBuilder docBuilder;

    public FilterCreator() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            this.docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to create DOM parser", e);
        }
    }

    public Element createIdentifierFilter(OutputSchema outputSchema, String identifier) {
        String propertyName = this.findIdentifierPropertyName(outputSchema);
        return this.createPropertyIsEqualToFilter(propertyName, identifier);
    }

    public Element createTitleFilter(OutputSchema outputSchema, String title) {
        String propertyName = this.findTitlePropertyName(outputSchema);
        return this.createPropertyIsEqualToFilter(propertyName, title);
    }

    public Element createAnyTextFilter(OutputSchema outputSchema, String propertyValue) {
        String propertyName = "AnyText";
        return this.createPropertyIsLikeFilter(propertyName, propertyValue);
    }

    private Element createPropertyIsEqualToFilter(String propertyName, String propertyValue) {
        Document document = this.docBuilder.newDocument();
        Element propertyIsEqualTo = document.createElementNS("http://www.opengis.net/ogc", "PropertyIsEqualTo");
        return this.createAndAppendPropertyNameAndValue(document, propertyIsEqualTo, propertyName, propertyValue);
    }

    private Element createPropertyIsLikeFilter(String propertyName, String propertyValue) {
        Document document = this.docBuilder.newDocument();
        Element propertyIsLike = document.createElementNS("http://www.opengis.net/ogc", "PropertyIsLike");
        propertyIsLike.setAttribute("escapeChar", "\\");
        propertyIsLike.setAttribute("singleChar", "?");
        propertyIsLike.setAttribute("wildCard", "*");
        return this.createAndAppendPropertyNameAndValue(document, propertyIsLike, propertyName, propertyValue);
    }

    private Element createAndAppendPropertyNameAndValue(Document document, Element propertyIsEqualTo, String propertyName, String propertyValue) {
        Element filter = document.createElementNS("http://www.opengis.net/ogc", "Filter");
        Element propertyNameElement = document.createElementNS("http://www.opengis.net/ogc", "PropertyName");
        propertyNameElement.setTextContent(propertyName);
        Element literal = document.createElementNS("http://www.opengis.net/ogc", "Literal");
        literal.setTextContent(propertyValue);
        propertyIsEqualTo.appendChild(propertyNameElement);
        propertyIsEqualTo.appendChild(literal);
        filter.appendChild(propertyIsEqualTo);
        return filter;
    }

    private String findIdentifierPropertyName(OutputSchema outputSchema) {
        if (OutputSchema.DC.equals((Object)outputSchema)) {
            return "dc:identifier";
        }
        return "Identifier";
    }

    private String findTitlePropertyName(OutputSchema outputSchema) {
        if (OutputSchema.DC.equals((Object)outputSchema)) {
            return "dc:title";
        }
        return "Title";
    }
}

