/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat20.dgiwg10.getrecordbyid;

import jakarta.ws.rs.core.MultivaluedMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.cat20.dgiwg10.CommonFixture;
import org.opengis.cite.cat20.dgiwg10.ETSAssert;
import org.opengis.cite.cat20.dgiwg10.ProtocolBinding;
import org.opengis.cite.cat20.dgiwg10.SuiteAttribute;
import org.opengis.cite.cat20.dgiwg10.returnables.Returnables;
import org.opengis.cite.cat20.dgiwg10.util.DataSampler;
import org.opengis.cite.cat20.dgiwg10.util.ElementSetName;
import org.opengis.cite.cat20.dgiwg10.util.OutputSchema;
import org.opengis.cite.cat20.dgiwg10.util.ServiceMetadataUtils;
import org.opengis.cite.cat20.dgiwg10.util.TestSuiteLogger;
import org.opengis.cite.cat20.dgiwg10.util.ValidationUtils;
import org.opengis.cite.cat20.dgiwg10.util.XMLUtils;
import org.opengis.cite.cat20.dgiwg10.xml.RequestCreator;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GetRecordById
extends CommonFixture {
    private final RequestCreator requestCreator = new RequestCreator();
    private DataSampler dataSampler;
    private Validator cswValidator;
    private Validator isoValidator;
    private Document dublinCoreResponse;
    private Document isoResponse;

    @BeforeClass
    public void retrieveDataSampler(ITestContext testContext) {
        this.dataSampler = (DataSampler)testContext.getSuite().getAttribute(SuiteAttribute.DATA_SAMPLER.getName());
    }

    @BeforeClass
    public void buildValidators() {
        URL cswSchemaUrl = this.getClass().getResource("/org/opengis/cite/cat20/dgiwg10/xsd/csw/2.0.2/csw.xsd");
        try {
            Schema cswSchema = ValidationUtils.createSchema(cswSchemaUrl.toURI());
            this.cswValidator = cswSchema.newValidator();
        }
        catch (URISyntaxException e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to build XML Schema Validator for csw.xsd.", e);
        }
        try {
            URL metadatEntitySchemaUrl = this.getClass().getResource("/org/opengis/cite/cat20/dgiwg10/xsd/iso/19139/20070417/gmd/metadataEntity.xsd");
            URL srvSchemaUrl = this.getClass().getResource("/org/opengis/cite/cat20/dgiwg10/xsd/iso/19139/20070417/srv/1.0/serviceMetadata.xsd");
            URL gmxSchemaUrl = this.getClass().getResource("/org/opengis/cite/cat20/dgiwg10/xsd/iso/19139/20070417/gmx/gmx.xsd");
            Schema schema = ValidationUtils.createSchema(metadatEntitySchemaUrl.toURI(), srvSchemaUrl.toURI(), gmxSchemaUrl.toURI(), cswSchemaUrl.toURI());
            this.isoValidator = schema.newValidator();
        }
        catch (URISyntaxException e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to build XML Schema Validator for csw.xsd.", e);
        }
    }

    @Test(description="Implements A.1.3 GetRecordById for DGIWG Basic CSW - 'csw:Record' (Requirement 10)")
    public void issueGetRecordById_DublinCore() {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.capabilitiesDoc, "GetRecords", ProtocolBinding.POST);
        if (endpoint == null) {
            throw new SkipException("No POST binding available for GetRecords request.");
        }
        String identifier = this.dataSampler.findSampleIdentifier();
        if (identifier == null) {
            throw new SkipException("No identifier available.");
        }
        this.requestDocument = this.requestCreator.createGetRecordById(OutputSchema.DC, ElementSetName.FULL, identifier);
        this.response = this.cswClient.submitPostRequest(endpoint, this.requestDocument);
        ETSAssert.assertStatusCode(this.response.getStatus(), 200);
        ETSAssert.assertXmlContentType((MultivaluedMap<String, Object>)this.response.getHeaders());
        this.responseDocument = (Document)this.response.readEntity(Document.class);
        ETSAssert.assertQualifiedName(this.responseDocument, "http://www.opengis.net/cat/csw/2.0.2", "GetRecordByIdResponse");
        ETSAssert.assertSchemaValid(this.cswValidator, new DOMSource(this.responseDocument));
        this.dublinCoreResponse = this.responseDocument;
    }

    @Test(description="Implements A.1.3 GetRecordById for DGIWG Basic CSW - 'gmd:MD_Metadata' (Requirement 10)")
    public void issueGetRecordById_Iso() {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.capabilitiesDoc, "GetRecords", ProtocolBinding.POST);
        if (endpoint == null) {
            throw new SkipException("No POST binding available for GetRecords request.");
        }
        String identifier = this.dataSampler.findSampleIdentifier();
        if (identifier == null) {
            throw new SkipException("No identifier available.");
        }
        this.requestDocument = this.requestCreator.createGetRecordById(OutputSchema.ISO19193, ElementSetName.FULL, identifier);
        this.response = this.cswClient.submitPostRequest(endpoint, this.requestDocument);
        ETSAssert.assertStatusCode(this.response.getStatus(), 200);
        ETSAssert.assertXmlContentType((MultivaluedMap<String, Object>)this.response.getHeaders());
        this.responseDocument = (Document)this.response.readEntity(Document.class);
        ETSAssert.assertQualifiedName(this.responseDocument, "http://www.opengis.net/cat/csw/2.0.2", "GetRecordByIdResponse");
        ETSAssert.assertSchemaValid(this.isoValidator, new DOMSource(this.responseDocument));
        this.isoResponse = this.responseDocument;
    }

    @Test(description="Implements A.1.3 GetRecordById for DGIWG Basic CSW - 'csw:Record', returnables (Requirement 13)", dependsOnMethods={"issueGetRecordById_DublinCore"})
    public void issueGetRecordById_Returnables_DublinCore() throws XPathExpressionException {
        Node record = (Node)XMLUtils.evaluateXPath(this.dublinCoreResponse, "//csw:Record[1]", null, XPathConstants.NODE);
        if (record == null) {
            throw new AssertionError((Object)"No csw:Record record available");
        }
        Returnables.assertReturnablesDublinCore(record);
    }

    @Test(description="Implements A.1.3 GetRecordById for DGIWG Basic CSW - 'gmd:MD_Metadata', returnables (Requirement 13)", dependsOnMethods={"issueGetRecordById_Iso"})
    public void issueGetRecordById_Returnables_Iso() throws XPathExpressionException {
        Node record = (Node)XMLUtils.evaluateXPath(this.isoResponse, "//gmd:MD_Metadata[1]", null, XPathConstants.NODE);
        if (record == null) {
            throw new AssertionError((Object)"No gmd:MD_Metadata record available");
        }
        Returnables.assertReturnablesIso(record);
    }
}

