/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat20.dgiwg10.transaction;

import java.net.URI;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.cat20.dgiwg10.CommonFixture;
import org.opengis.cite.cat20.dgiwg10.ETSAssert;
import org.opengis.cite.cat20.dgiwg10.ProtocolBinding;
import org.opengis.cite.cat20.dgiwg10.util.NamespaceBindings;
import org.opengis.cite.cat20.dgiwg10.util.ServiceMetadataUtils;
import org.opengis.cite.cat20.dgiwg10.util.XMLUtils;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class TransactionCommon
extends CommonFixture {
    protected static final String CSWT_IDENTIFIER = "http://www.dgiwg.org/std/csw/1.0/conf/dgiwg_cswt";
    private static final String ABSTRACT_TEXT_19 = "This service implements the DGIWG Catalogue Service for the Web ISO Profile version 1.0, DGIWG Basic CSW conformance class (http://www.dgiwg.org/std/csw/1.0/conf/basic) and DGIWG Transactional CSW (\u201dhttp://www.dgiwg.org/std/csw/1.0/conf/dgiwg_cswt)";

    @Test(description="Implements A.1.4 DGIWG Transactional CSW", groups={"isTransactional"})
    public void isTransactionalCsw() {
        String xpath = "contains(//csw:Capabilities/ows:ServiceIdentification/ows:Abstract, '%s')";
        String xpathWithIdentifier = String.format(xpath, CSWT_IDENTIFIER);
        try {
            boolean isCswT = (Boolean)XMLUtils.evaluateXPath(this.capabilitiesDoc, xpathWithIdentifier, NamespaceBindings.withStandardBindings().getAllBindings(), XPathConstants.BOOLEAN);
            if (!isCswT) {
                throw new SkipException("CSW is not transactional (missing identifier 'http://www.dgiwg.org/std/csw/1.0/conf/dgiwg_cswt' in the abstract of the capabilities).");
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
    }

    @Test(description="Implements A.1.4 DGIWG Transactional CSW", groups={"isTransactional"})
    public void hasTransactionPostUrl() {
        URI transactionUrl = ServiceMetadataUtils.getOperationEndpoint(this.capabilitiesDoc, "Transaction", ProtocolBinding.POST);
        if (transactionUrl == null) {
            throw new SkipException("CSW does not provide a POST Url for Transaction requests.");
        }
    }

    @Test(description="Implements A.1.4 DGIWG Transactional CSW (Requirement 19)", groups={"isTransactional"}, dependsOnMethods={"isTransactionalCsw"})
    public void verifyAbstract() {
        String xpath = "contains(normalize-space(//csw:Capabilities/ows:ServiceIdentification/ows:Abstract), 'This service implements the DGIWG Catalogue Service for the Web ISO Profile version 1.0, DGIWG Basic CSW conformance class (http://www.dgiwg.org/std/csw/1.0/conf/basic) and DGIWG Transactional CSW (\u201dhttp://www.dgiwg.org/std/csw/1.0/conf/dgiwg_cswt)')";
        ETSAssert.assertXPath(this.capabilitiesDoc, xpath, NamespaceBindings.withStandardBindings().getAllBindings(), "Abstract does not contain the expected text 'This service implements the DGIWG Catalogue Service for the Web ISO Profile version 1.0, DGIWG Basic CSW conformance class (http://www.dgiwg.org/std/csw/1.0/conf/basic) and DGIWG Transactional CSW (\u201dhttp://www.dgiwg.org/std/csw/1.0/conf/dgiwg_cswt)'.");
    }
}

