/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat20.dgiwg10.getrecords;

import jakarta.ws.rs.core.MultivaluedMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.cat20.dgiwg10.CommonFixture;
import org.opengis.cite.cat20.dgiwg10.ETSAssert;
import org.opengis.cite.cat20.dgiwg10.ProtocolBinding;
import org.opengis.cite.cat20.dgiwg10.SuiteAttribute;
import org.opengis.cite.cat20.dgiwg10.returnables.Returnables;
import org.opengis.cite.cat20.dgiwg10.util.DataSampler;
import org.opengis.cite.cat20.dgiwg10.util.ElementSetName;
import org.opengis.cite.cat20.dgiwg10.util.OutputSchema;
import org.opengis.cite.cat20.dgiwg10.util.ServiceMetadataUtils;
import org.opengis.cite.cat20.dgiwg10.util.TestSuiteLogger;
import org.opengis.cite.cat20.dgiwg10.util.ValidationUtils;
import org.opengis.cite.cat20.dgiwg10.util.XMLUtils;
import org.opengis.cite.cat20.dgiwg10.xml.FilterCreator;
import org.opengis.cite.cat20.dgiwg10.xml.RequestCreator;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GetRecords
extends CommonFixture {
    private final RequestCreator requestCreator = new RequestCreator();
    private final FilterCreator filterCreator = new FilterCreator();
    private DataSampler dataSampler;
    private Validator cswValidator;
    private Validator isoValidator;
    private Map<String, Document> queryableToResponseDublinCore = new HashMap<String, Document>();
    private Map<String, Document> queryableToResponseIso = new HashMap<String, Document>();

    @BeforeClass
    public void retrieveDataSampler(ITestContext testContext) {
        this.dataSampler = (DataSampler)testContext.getSuite().getAttribute(SuiteAttribute.DATA_SAMPLER.getName());
    }

    @BeforeClass
    public void buildValidators() {
        URL cswSchemaUrl = this.getClass().getResource("/org/opengis/cite/cat20/dgiwg10/xsd/csw/2.0.2/csw.xsd");
        try {
            Schema cswSchema = ValidationUtils.createSchema(cswSchemaUrl.toURI());
            this.cswValidator = cswSchema.newValidator();
        }
        catch (URISyntaxException e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to build XML Schema Validator for csw.xsd.", e);
        }
        try {
            URL metadatEntitySchemaUrl = this.getClass().getResource("/org/opengis/cite/cat20/dgiwg10/xsd/iso/19139/20070417/gmd/metadataEntity.xsd");
            URL srvSchemaUrl = this.getClass().getResource("/org/opengis/cite/cat20/dgiwg10/xsd/iso/19139/20070417/srv/1.0/serviceMetadata.xsd");
            URL gmxSchemaUrl = this.getClass().getResource("/org/opengis/cite/cat20/dgiwg10/xsd/iso/19139/20070417/gmx/gmx.xsd");
            Schema schema = ValidationUtils.createSchema(metadatEntitySchemaUrl.toURI(), srvSchemaUrl.toURI(), gmxSchemaUrl.toURI(), cswSchemaUrl.toURI());
            this.isoValidator = schema.newValidator();
        }
        catch (URISyntaxException e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to build XML Schema Validator for csw.xsd.", e);
        }
    }

    @DataProvider(name="queryables")
    public Iterator<Object[]> queryables() {
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        collectionsData.add(new Object[]{"Identifier"});
        collectionsData.add(new Object[]{"Title"});
        collectionsData.add(new Object[]{"AnyText"});
        return collectionsData.iterator();
    }

    @DataProvider(name="queryableAndFilter")
    public Iterator<Object[]> queryableAndFilter() {
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        collectionsData.add(new Object[]{"Identifier", this.createIdentifierFilter()});
        collectionsData.add(new Object[]{"Title", this.createTitleFilter()});
        collectionsData.add(new Object[]{"AnyText", this.createAnyTextFilter()});
        return collectionsData.iterator();
    }

    @Test(description="Implements A.1.2 GetRecord for DGIWG Basic CSW - 'csw:Record' (Requirement 6, 7)", dataProvider="queryableAndFilter")
    public void issueGetRecords_DublinCore(String queryable, Element filter) {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.capabilitiesDoc, "GetRecords", ProtocolBinding.POST);
        if (endpoint == null) {
            throw new SkipException("No POST binding available for GetRecords request.");
        }
        if (filter == null) {
            throw new SkipException("No value available for Queryable '" + queryable + "'.");
        }
        this.requestDocument = this.requestCreator.createGetRecordsRequest(OutputSchema.DC, ElementSetName.FULL, filter);
        this.response = this.cswClient.submitPostRequest(endpoint, this.requestDocument);
        ETSAssert.assertStatusCode(this.response.getStatus(), 200);
        ETSAssert.assertXmlContentType((MultivaluedMap<String, Object>)this.response.getHeaders());
        this.responseDocument = (Document)this.response.readEntity(Document.class);
        ETSAssert.assertQualifiedName(this.responseDocument, "http://www.opengis.net/cat/csw/2.0.2", "GetRecordsResponse");
        this.queryableToResponseDublinCore.put(queryable, this.responseDocument);
        ETSAssert.assertSchemaValid(this.cswValidator, new DOMSource(this.responseDocument));
    }

    @Test(description="Implements A.1.2 GetRecord for DGIWG Basic CSW - 'gmd:MD_Metadata' (Requirement 6, 7)", dataProvider="queryableAndFilter")
    public void issueGetRecords_Iso(String queryable, Element filter) {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.capabilitiesDoc, "GetRecords", ProtocolBinding.POST);
        if (endpoint == null) {
            throw new SkipException("No POST binding available for GetRecords request.");
        }
        if (filter == null) {
            throw new SkipException("No value available for Queryable '" + queryable + "'.");
        }
        this.requestDocument = this.requestCreator.createGetRecordsRequest(OutputSchema.ISO19193, ElementSetName.FULL, filter);
        this.response = this.cswClient.submitPostRequest(endpoint, this.requestDocument);
        ETSAssert.assertStatusCode(this.response.getStatus(), 200);
        ETSAssert.assertXmlContentType((MultivaluedMap<String, Object>)this.response.getHeaders());
        this.responseDocument = (Document)this.response.readEntity(Document.class);
        ETSAssert.assertQualifiedName(this.responseDocument, "http://www.opengis.net/cat/csw/2.0.2", "GetRecordsResponse");
        this.queryableToResponseIso.put(queryable, this.responseDocument);
        ETSAssert.assertSchemaValid(this.isoValidator, new DOMSource(this.responseDocument));
    }

    @Test(description="Implements A.1.2 GetRecord for DGIWG Basic CSW - 'csw:Record', returnables (Requirement 8)", dependsOnMethods={"issueGetRecords_DublinCore"}, alwaysRun=true, dataProvider="queryables")
    public void issueGetRecords_Returnables_DublinCore(String queryable) throws XPathExpressionException {
        Document response = this.queryableToResponseDublinCore.get(queryable);
        if (response == null) {
            throw new SkipException("No response available for queryable " + queryable);
        }
        Node record = (Node)XMLUtils.evaluateXPath(response, "//csw:Record[1]", null, XPathConstants.NODE);
        if (record == null) {
            throw new AssertionError((Object)"No csw:Record record available");
        }
        Returnables.assertReturnablesDublinCore(record);
    }

    @Test(description="Implements A.1.2 GetRecord for DGIWG Basic CSW - 'gmd:MD_Metadata', returnables (Requirement 8)", dependsOnMethods={"issueGetRecords_Iso"}, alwaysRun=true, dataProvider="queryables")
    public void issueGetRecords_Returnables_Iso(String queryable) throws XPathExpressionException {
        Document response = this.queryableToResponseIso.get(queryable);
        if (response == null) {
            throw new SkipException("No response available for queryable " + queryable);
        }
        Node record = (Node)XMLUtils.evaluateXPath(response, "//gmd:MD_Metadata[1]", null, XPathConstants.NODE);
        if (record == null) {
            throw new AssertionError((Object)"No gmd:MD_Metadata record available");
        }
        Returnables.assertReturnablesIso(record);
    }

    private Element createIdentifierFilter() {
        Map<String, Node> records = this.dataSampler.getRecords();
        for (String identifier : records.keySet()) {
            if (identifier == null) continue;
            return this.filterCreator.createIdentifierFilter(OutputSchema.ISO19193, identifier);
        }
        return null;
    }

    private Element createTitleFilter() {
        Map<String, Node> records = this.dataSampler.getRecords();
        for (Node record : records.values()) {
            String title = this.findTitle(record);
            if (title == null) continue;
            return this.filterCreator.createTitleFilter(OutputSchema.DC, title);
        }
        return null;
    }

    private Object createAnyTextFilter() {
        Map<String, Node> records = this.dataSampler.getRecords();
        for (Node record : records.values()) {
            String title = this.findTitle(record);
            if (title == null) continue;
            return this.filterCreator.createAnyTextFilter(OutputSchema.DC, title);
        }
        return null;
    }

    private String findTitle(Node record) {
        try {
            return (String)XMLUtils.evaluateXPath(record, "//dc:title", null, XPathConstants.STRING);
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }
}

