/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat20.dgiwg10.returnables;

import java.util.ArrayList;
import java.util.function.Function;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.cat20.dgiwg10.util.XMLUtils;
import org.testng.Assert;
import org.w3c.dom.Node;

public class Returnables {
    public static void assertReturnablesDublinCore(Node record) throws XPathExpressionException {
        Returnables.assertReturnables(record, r -> r.dublinCoreXpath);
    }

    public static void assertReturnablesIso(Node record) throws XPathExpressionException {
        Returnables.assertReturnables(record, r -> r.isoXpath);
    }

    public static void assertReturnables(Node record, Function<Returnable, String> f) throws XPathExpressionException {
        ArrayList<String> invalidReturnables = new ArrayList<String>();
        for (Returnable returnable : Returnable.values()) {
            String returnableXPath = f.apply(returnable);
            boolean hasReturnable = (Boolean)XMLUtils.evaluateXPath(record, returnableXPath, null, XPathConstants.BOOLEAN);
            if (hasReturnable) continue;
            invalidReturnables.add(returnable.name);
        }
        Assert.assertTrue((boolean)invalidReturnables.isEmpty(), (String)("Missing returnables in GetRecords response: " + String.join((CharSequence)",", invalidReturnables)));
    }

    static enum Returnable {
        IDENTIFIER("Identifier", "dc:identifier", "./gmd:fileIdentifier"),
        TITLE("Title", "dc:title", "./gmd:identificationInfo/*/gmd:citation/gmd:CI_Citation/gmd:title"),
        SUBJECT("Subject", "dc:subject", "./gmd:identificationInfo/*/gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:keyword | ./gmd:identificationInfo/*/gmd:topicCategory"),
        ABSTRACT("Abstract", "dc:description", "./gmd:identificationInfo/*/gmd:abstract"),
        TYPE("Type", "dc:type", "./gmd:hierarchyLevel/gmd:MD_ScopeCode/@codeListValue"),
        FORMAT("Format", "dc:format", "./gmd:distributionInfo/gmd:MD_Distribution/gmd:distributionFormat/gmd:MD_Format/gmd:name"),
        LANGUAGE("Language", "dc:language", "./gmd:language");

        private String name;
        private String dublinCoreXpath;
        private String isoXpath;

        private Returnable(String name, String dublinCoreXpath, String isoXpath) {
            this.name = name;
            this.dublinCoreXpath = dublinCoreXpath;
            this.isoXpath = isoXpath;
        }
    }
}

