/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat20.dgiwg10.util;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.dom.DOMSource;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.opengis.cite.cat20.dgiwg10.ProtocolBinding;
import org.opengis.cite.cat20.dgiwg10.util.ClientUtils;
import org.opengis.cite.cat20.dgiwg10.util.ServiceMetadataUtils;
import org.w3c.dom.Document;

public class CSWClient {
    private static final Logger LOG = Logger.getLogger(CSWClient.class.getName());
    private Client client = this.createClient();
    private Document capabilitiesDocument;

    public CSWClient() {
    }

    private Client createClient() {
        return ClientUtils.buildClient();
    }

    private Client createClient(String username, String pw) {
        Client client = this.createClient();
        client.register((Object)HttpAuthenticationFeature.basic((String)username, (String)pw));
        return client;
    }

    public CSWClient(Document capabilitiesDocument) {
        this();
        String docElemName = capabilitiesDocument.getDocumentElement().getLocalName();
        if (!"Capabilities".equals(docElemName)) {
            throw new IllegalArgumentException("Not a capabilities document: " + docElemName);
        }
        this.capabilitiesDocument = capabilitiesDocument;
    }

    public Response submitGetRequest(URI endpoint, Map<String, String> queryParams) {
        LOG.log(Level.FINE, String.format("Submitting GET request to URI %s", endpoint));
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)endpoint);
        if (queryParams != null) {
            for (Map.Entry<String, String> parameter : queryParams.entrySet()) {
                uriBuilder.queryParam(parameter.getKey(), new Object[]{parameter.getValue()});
            }
        }
        URI requestURI = uriBuilder.build(new Object[0]);
        LOG.log(Level.FINE, String.format("Request URI: %s", requestURI));
        WebTarget target = this.client.target(requestURI);
        Invocation.Builder reqBuilder = target.request();
        return reqBuilder.buildGet().invoke();
    }

    public Response submitPostRequest(URI endpoint, Document request) {
        return this.submitPostRequest(this.client, endpoint, request);
    }

    public Response submitPostRequest(URI endpoint, Document request, String user, String pw) {
        Client client = user != null && pw != null ? this.createClient(user, pw) : this.client;
        return this.submitPostRequest(client, endpoint, request);
    }

    protected Response submitPostRequest(Client client, URI endpoint, Document request) {
        DOMSource requestBody = new DOMSource(request);
        WebTarget target = this.client.target(endpoint);
        return target.request().buildPost(Entity.entity((Object)requestBody, (String)"application/xml")).invoke();
    }

    public Document getCapabilities() {
        if (this.capabilitiesDocument == null) {
            throw new IllegalStateException("Service description is unavailable.");
        }
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.capabilitiesDocument, "GetCapabilities", ProtocolBinding.GET);
        WebTarget target = this.client.target(endpoint);
        MultivaluedHashMap queryParams = new MultivaluedHashMap();
        queryParams.add((Object)"REQUEST", (Object)"GetCapabilities");
        queryParams.add((Object)"SERVICE", (Object)"CSW");
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)endpoint);
        if (null != queryParams) {
            for (Map.Entry param : queryParams.entrySet()) {
                uriBuilder.queryParam((String)param.getKey(), new Object[]{((List)param.getValue()).get(0)});
            }
        }
        return (Document)target.request().buildGet().invoke().readEntity(Document.class);
    }
}

