/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30.basic;

import com.sun.jersey.api.client.ClientResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import org.opengis.cite.cat30.CommonFixture;
import org.opengis.cite.cat30.ETSAssert;
import org.opengis.cite.cat30.ErrorMessage;
import org.opengis.cite.cat30.SuiteAttribute;
import org.opengis.cite.cat30.basic.GetRecordByIdTests;
import org.opengis.cite.cat30.util.ClientUtils;
import org.opengis.cite.cat30.util.DatasetInfo;
import org.opengis.cite.cat30.util.ServiceMetadataUtils;
import org.opengis.cite.cat30.util.XMLUtils;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class BasicGetRecordsTests
extends CommonFixture {
    private URI getURI;
    private URI postURI;
    private DatasetInfo datasetInfo;

    void setGetEndpoint(URI uri) {
        this.getURI = uri;
    }

    @BeforeClass
    public void findRequestEndpoints(ITestContext testContext) {
        this.getURI = ServiceMetadataUtils.getOperationEndpoint(this.cswCapabilities, "GetRecords", "GET");
        if (null == this.getURI.getScheme()) {
            throw new SkipException("GET endpoint for GetRecords request not found.");
        }
        this.postURI = ServiceMetadataUtils.getOperationEndpoint(this.cswCapabilities, "GetRecords", "POST");
    }

    @BeforeClass
    public void getDatasetInfo(ITestContext testContext) {
        DatasetInfo dataset = (DatasetInfo)testContext.getSuite().getAttribute(SuiteAttribute.DATASET.getName());
        if (null == dataset) {
            throw new SkipException("Dataset info not found in test context.");
        }
        this.datasetInfo = dataset;
    }

    @Test(description="Requirements: 063")
    public void getBriefRecordsWithNamespaceBinding() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecords");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("namespace", String.format("xmlns(tns=%s)", "http://www.opengis.net/cat/csw/3.0"));
        qryParams.put("typeNames", "tns:Record");
        qryParams.put("elementSetName", "brief");
        this.request = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        this.response = this.client.handle(this.request);
        Assert.assertEquals((int)this.response.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Document entity = this.getResponseEntityAsDocument(this.response, null);
        String expr = "count(//csw:SearchResults/csw:BriefRecord) > 0";
        ETSAssert.assertXPath(expr, entity, null);
    }

    @Test(description="Requirements: 101")
    public void getSummaryRecordsInDefaultRepresentation() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecords");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("typeNames", "Record");
        qryParams.put("elementSetName", "summary");
        this.request = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        this.response = this.client.handle(this.request);
        Assert.assertEquals((int)this.response.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Document entity = this.getResponseEntityAsDocument(this.response, null);
        String expr = "count(//csw:SearchResults/csw:SummaryRecord) > 0";
        ETSAssert.assertXPath(expr, entity, null);
    }

    @Test(description="Requirements: 80,122")
    public void getSummaryRecordsInAtomFeed() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecords");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("typeNames", "Record");
        qryParams.put("elementSetName", "summary");
        qryParams.put("outputFormat", "application/atom+xml");
        this.request = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_ATOM_XML_TYPE);
        this.response = this.client.handle(this.request);
        Assert.assertEquals((int)this.response.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Assert.assertEquals((Object)ClientUtils.removeParameters(this.response.getType()), (Object)MediaType.APPLICATION_ATOM_XML_TYPE, (String)ErrorMessage.get("UnexpectedMediaType"));
        Document entity = this.getResponseEntityAsDocument(this.response, null);
        Map<String, String> nsBindings = Collections.singletonMap("http://www.w3.org/2005/Atom", "atom");
        String expr = "count(/atom:feed/atom:entry) > 0";
        ETSAssert.assertXPath(expr, entity, nsBindings);
        Validator atomValidator = this.atomSchema.newValidator();
        ValidationErrorHandler err = new ValidationErrorHandler();
        atomValidator.setErrorHandler((ErrorHandler)err);
        try {
            StreamSource src = XMLUtils.toStreamSource(new DOMSource(entity));
            atomValidator.validate(src);
        }
        catch (IOException | SAXException ex) {
            Logger.getLogger(GetRecordByIdTests.class.getName()).log(Level.WARNING, "Error attempting to validate Atom feed.", ex);
        }
        Assert.assertFalse((boolean)err.errorsDetected(), (String)ErrorMessage.format("NotSchemaValid", err.getErrorCount(), err.toString()));
    }

    @Test(description="Requirements: 035,037,042")
    public void getRecordsInUnsupportedOutputFormat() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecords");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("typeNames", "Record");
        qryParams.put("elementSetName", "full");
        qryParams.put("outputFormat", "text/example");
        this.request = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.WILDCARD_TYPE);
        this.response = this.client.handle(this.request);
        ETSAssert.assertExceptionReport(this.response, "InvalidParameterValue", "outputFormat");
    }

    @Test(description="Requirements: 088")
    public void getRecordsWithUnknownTypeName() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecords");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("typeNames", "UnknownType");
        this.request = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        this.response = this.client.handle(this.request);
        ETSAssert.assertExceptionReport(this.response, "InvalidParameterValue", "typeNames");
    }

    @Test(description="Requirements: 102")
    public void unknownElementSetName() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecords");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("typeNames", "Record");
        qryParams.put("elementSetName", "undefined-view");
        this.request = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        this.response = this.client.handle(this.request);
        ETSAssert.assertExceptionReport(this.response, "InvalidParameterValue", "elementSetName");
    }

    @Test(description="Requirements: 035,037,042")
    public void getRecordsWithUnsupportedSchema() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecords");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("typeNames", "Record");
        qryParams.put("elementSetName", "brief");
        qryParams.put("outputSchema", "urn:uuid:6a29d2a8-9651-47a6-9b14-f05d2b5644f0");
        this.request = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        this.response = this.client.handle(this.request);
        ETSAssert.assertExceptionReport(this.response, "InvalidParameterValue", "outputSchema");
    }

    @Test(description="Requirements: 093")
    public void presentSubjectProperty() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecords");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("typeNames", "Record");
        qryParams.put("elementName", "tns:subject");
        qryParams.put("namespace", String.format("xmlns(tns=%s)", "http://purl.org/dc/elements/1.1/"));
        this.request = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        this.response = this.client.handle(this.request);
        Assert.assertEquals((int)this.response.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Document entity = this.getResponseEntityAsDocument(this.response, null);
        Validator validator = this.cswSchema.newValidator();
        ETSAssert.assertSchemaValid(validator, new DOMSource(entity, entity.getDocumentURI()));
        Element results = (Element)entity.getElementsByTagNameNS("http://www.opengis.net/cat/csw/3.0", "SearchResults").item(0);
        ETSAssert.assertXPath("count(csw:SummaryRecord[dc:subject]) = ./@numberOfRecordsReturned", results, null);
    }

    @Test(description="Requirements: 091")
    public void presentUnknownRecordProperty() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecords");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("typeNames", "Record");
        qryParams.put("elementName", "undefined");
        this.request = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        this.response = this.client.handle(this.request);
        ETSAssert.assertExceptionReport(this.response, "InvalidParameterValue", "elementName");
    }

    @Test(description="Requirements: 099")
    public void elementSetAndElementName() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecords");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("typeNames", "Record");
        qryParams.put("elementSetName", "brief");
        qryParams.put("elementName", "ns1:subject");
        qryParams.put("namespace", String.format("xmlns(ns1=%s)", "http://purl.org/dc/elements/1.1/"));
        this.request = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        this.response = this.client.handle(this.request);
        ETSAssert.assertExceptionReport(this.response, "NoApplicableCode", null);
    }

    @Test(description="Requirements: 082,084")
    public void getPartialResults() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecords");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("namespace", String.format("xmlns(csw3=%s)", "http://www.opengis.net/cat/csw/3.0"));
        qryParams.put("typeNames", "csw3:Record");
        qryParams.put("elementSetName", "summary");
        int startPosition = 3;
        qryParams.put("startPosition", Integer.toString(startPosition));
        int maxRecords = 2;
        qryParams.put("maxRecords", Integer.toString(maxRecords));
        this.request = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        this.response = this.client.handle(this.request);
        Assert.assertEquals((int)this.response.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Document entity = this.getResponseEntityAsDocument(this.response, null);
        Node resultsNode = entity.getElementsByTagNameNS("http://www.opengis.net/cat/csw/3.0", "SearchResults").item(0);
        Assert.assertNotNull((Object)resultsNode, (String)ErrorMessage.format("MissingInfosetItem", "csw:SearchResults"));
        Element results = (Element)resultsNode;
        Assert.assertEquals((int)results.getElementsByTagNameNS("http://www.opengis.net/cat/csw/3.0", "SummaryRecord").getLength(), (int)maxRecords, (String)ErrorMessage.format("ResultSetSize", "csw:SummaryRecord"));
        Assert.assertEquals((int)Integer.parseInt(results.getAttribute("numberOfRecordsReturned")), (int)maxRecords, (String)ErrorMessage.format("InfosetItemValue", "@numberOfRecordsReturned"));
        Assert.assertEquals((int)Integer.parseInt(results.getAttribute("nextRecord")), (int)(startPosition + maxRecords), (String)ErrorMessage.format("InfosetItemValue", "@nextRecord"));
    }

    @Test(description="Requirements: 082,084,122")
    public void getPartialResultsAsAtomFeed() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecords");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("namespace", String.format("xmlns(csw3=%s)", "http://www.opengis.net/cat/csw/3.0"));
        qryParams.put("typeNames", "csw3:Record");
        qryParams.put("elementSetName", "summary");
        qryParams.put("outputFormat", "application/atom+xml");
        int startPosition = 3;
        qryParams.put("startPosition", Integer.toString(startPosition));
        int maxRecords = 2;
        qryParams.put("maxRecords", Integer.toString(maxRecords));
        this.request = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_ATOM_XML_TYPE);
        this.response = this.client.handle(this.request);
        Assert.assertEquals((int)this.response.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Document entity = this.getResponseEntityAsDocument(this.response, null);
        Node feedNode = entity.getElementsByTagNameNS("http://www.w3.org/2005/Atom", "feed").item(0);
        Assert.assertNotNull((Object)feedNode, (String)ErrorMessage.format("MissingInfosetItem", "atom:feed"));
        Element feed = (Element)feedNode;
        Assert.assertEquals((int)feed.getElementsByTagNameNS("http://www.w3.org/2005/Atom", "entry").getLength(), (int)maxRecords, (String)ErrorMessage.format("ResultSetSize", "atom:entry"));
        Node startIndex = feed.getElementsByTagNameNS("http://a9.com/-/spec/opensearch/1.1/", "startIndex").item(0);
        Assert.assertNotNull((Object)startIndex, (String)ErrorMessage.format("MissingInfosetItem", "os:startIndex"));
        Assert.assertEquals((int)Integer.parseInt(startIndex.getTextContent()), (int)startPosition, (String)ErrorMessage.format("InfosetItemValue", "os:startIndex"));
        Node itemsPerPage = feed.getElementsByTagNameNS("http://a9.com/-/spec/opensearch/1.1/", "itemsPerPage").item(0);
        Assert.assertNotNull((Object)itemsPerPage, (String)ErrorMessage.format("MissingInfosetItem", "os:itemsPerPage"));
        Assert.assertEquals((int)Integer.parseInt(itemsPerPage.getTextContent()), (int)maxRecords, (String)ErrorMessage.format("InfosetItemValue", "os:itemsPerPage"));
    }
}

