/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import org.opengis.cite.cat30.util.DatasetInfo;
import org.opengis.cite.cat30.util.NamespaceBindings;
import org.opengis.cite.cat30.util.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Records {
    public static String generateRandomText() {
        Random r = new Random();
        int length = r.nextInt(10) + 5;
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char letter = (char)(r.nextInt(26) + 97);
            str.append(letter);
        }
        return str.toString();
    }

    public static String getRecordId(Element record) {
        StringBuilder str = new StringBuilder(record.getNodeName());
        NodeList idList = record.getElementsByTagNameNS("http://purl.org/dc/elements/1.1/", "identifier");
        if (idList.getLength() == 0) {
            idList = record.getElementsByTagNameNS("http://www.w3.org/2005/Atom", "id");
        }
        if (idList.getLength() > 0) {
            str.append("[").append(idList.item(0).getTextContent()).append("]");
        }
        return str.toString();
    }

    public static List<String> findPropertyValues(File file, String xpath) {
        ArrayList<String> idList = new ArrayList<String>();
        StreamSource src = new StreamSource(file);
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put("http://purl.org/dc/elements/1.1/", "dc");
        nsBindings.put("http://purl.org/dc/terms/", "dct");
        XdmValue value = null;
        try {
            value = XMLUtils.evaluateXPath2(src, xpath, nsBindings);
        }
        catch (SaxonApiException ex) {
            Logger.getLogger(DatasetInfo.class.getName()).log(Level.WARNING, "Failed to evaluate XPath expression: " + xpath, ex);
        }
        for (XdmItem item : value) {
            idList.add(item.getStringValue());
        }
        return idList;
    }

    public static String findMatchingSearchTerms(File dataFile, QName ... elemNames) {
        StringBuilder searchTerms = new StringBuilder();
        XdmValue results = Records.findRecordsInSampleData(dataFile, elemNames);
        if (results.size() > 0) {
            XdmNode lastNode = (XdmNode)results.itemAt(results.size() - 1);
            for (QName elemName : elemNames) {
                String value = lastNode.axisIterator(Axis.CHILD, new net.sf.saxon.s9api.QName(elemName)).next().getStringValue();
                searchTerms.append(value.trim().split("\\s+")[0]).append(" ");
            }
        } else {
            int randomIndex;
            String[] titleWords;
            ThreadLocalRandom random = ThreadLocalRandom.current();
            List<String> titles = Records.findPropertyValues(dataFile, "//dc:title");
            while ((titleWords = titles.get(randomIndex = random.nextInt(titles.size())).trim().split("\\s+")).length < 2) {
            }
            searchTerms.append(titleWords[titleWords.length - 1]).append(" ");
            searchTerms.append(titleWords[0]);
        }
        return searchTerms.toString().trim();
    }

    public static XdmValue findRecordsInSampleData(File dataFile, QName ... properties) {
        StringBuilder xpath = new StringBuilder("//csw:Record[");
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put("http://www.opengis.net/cat/csw/3.0", "csw");
        NamespaceBindings stdBindings = NamespaceBindings.withStandardBindings();
        for (int i = 0; i < properties.length; ++i) {
            QName elemName = properties[i];
            String localName = elemName.getLocalPart();
            String nsName = elemName.getNamespaceURI();
            String nsPrefix = stdBindings.getPrefix(nsName);
            nsBindings.put(nsName, nsPrefix);
            xpath.append(nsPrefix).append(':').append(localName);
            if (i >= properties.length - 1) continue;
            xpath.append(" and ");
        }
        xpath.append("]");
        XdmValue value = null;
        try {
            value = XMLUtils.evaluateXPath2(new StreamSource(dataFile), xpath.toString(), nsBindings);
        }
        catch (SaxonApiException x) {
            Logger.getLogger(Records.class.getName()).log(Level.WARNING, String.format("Failed to evaluate XPath expression against sample data file at %s:\n %s ", dataFile.getAbsolutePath(), xpath), x);
        }
        return value;
    }

    public static QName getRecordName(String mediaType) {
        QName recordName = mediaType.startsWith("application/atom+xml") ? new QName("http://www.w3.org/2005/Atom", "entry") : new QName("http://www.opengis.net/cat/csw/3.0", "Record");
        return recordName;
    }
}

