/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v311;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.Duration;
import org.geotoolkit.gml.xml.TimeIndeterminateValueType;
import org.geotoolkit.gml.xml.v311.AbstractTimeGeometricPrimitiveType;
import org.geotoolkit.gml.xml.v311.TimeInstantPropertyType;
import org.geotoolkit.gml.xml.v311.TimeInstantType;
import org.geotoolkit.gml.xml.v311.TimeIntervalLengthType;
import org.geotoolkit.gml.xml.v311.TimePositionType;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.Position;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="TimePeriodType", propOrder={"beginPosition", "begin", "endPosition", "end", "duration", "timeInterval"})
@XmlRootElement(name="TimePeriod")
public class TimePeriodType
extends AbstractTimeGeometricPrimitiveType
implements Period,
Serializable {
    private TimePositionType beginPosition;
    private TimeInstantPropertyType begin;
    private TimePositionType endPosition;
    private TimeInstantPropertyType end;
    private Duration duration;
    private TimeIntervalLengthType timeInterval;

    TimePeriodType() {
    }

    public TimePeriodType(Position beginPosition, Position endPosition) {
        if (beginPosition instanceof TimePositionType) {
            this.beginPosition = (TimePositionType)beginPosition;
        } else if (beginPosition != null) {
            this.beginPosition = new TimePositionType(beginPosition.getDate());
        }
        if (endPosition instanceof TimePositionType) {
            this.endPosition = (TimePositionType)endPosition;
        } else if (endPosition != null) {
            this.endPosition = new TimePositionType(endPosition.getDate());
        }
    }

    public TimePeriodType(String beginValue, String endValue) {
        this.beginPosition = new TimePositionType(beginValue);
        this.endPosition = new TimePositionType(endValue);
    }

    public TimePeriodType(Timestamp beginValue, Timestamp endValue) {
        this.beginPosition = new TimePositionType(beginValue);
        this.endPosition = new TimePositionType(endValue);
    }

    public TimePeriodType(Position beginPosition) {
        if (beginPosition instanceof TimePositionType) {
            this.beginPosition = (TimePositionType)beginPosition;
        } else if (beginPosition != null) {
            this.beginPosition = new TimePositionType(beginPosition);
        }
        this.endPosition = new TimePositionType(TimeIndeterminateValueType.NOW);
    }

    public TimePeriodType(String beginValue) {
        this.beginPosition = new TimePositionType(beginValue);
        this.endPosition = new TimePositionType(TimeIndeterminateValueType.NOW);
    }

    public TimePeriodType(Timestamp beginValue) {
        this.beginPosition = new TimePositionType(beginValue);
        this.endPosition = new TimePositionType(TimeIndeterminateValueType.NOW);
    }

    public TimePeriodType(TimeIndeterminateValueType indeterminateBegin, Position endPosition) {
        this.beginPosition = new TimePositionType(indeterminateBegin);
        if (endPosition instanceof TimePositionType) {
            this.endPosition = (TimePositionType)endPosition;
        } else if (endPosition != null) {
            this.endPosition = new TimePositionType(endPosition);
        }
    }

    public TimePeriodType(Position beginPosition, TimeIndeterminateValueType indeterminateEnd) {
        this.endPosition = new TimePositionType(indeterminateEnd);
        if (beginPosition instanceof TimePositionType) {
            this.beginPosition = (TimePositionType)beginPosition;
        } else if (beginPosition != null) {
            this.beginPosition = new TimePositionType(beginPosition);
        }
    }

    public TimePeriodType(Duration duration) {
        this.duration = duration;
    }

    public TimePositionType getBeginPosition() {
        return this.beginPosition;
    }

    public void setBeginPosition(TimePositionType value) {
        this.beginPosition = value;
    }

    public void setBeginPosition(Date value) {
        this.beginPosition = new TimePositionType(value);
    }

    public void setBeginPosition(TimeIndeterminateValueType value) {
        this.beginPosition = new TimePositionType(value);
    }

    public void setBeginPosition(TimeInstantType value) {
        if (value != null) {
            this.beginPosition = value.getTimePosition();
        }
    }

    public TimeInstantPropertyType getBegin() {
        return this.begin;
    }

    public void setBegin(TimeInstantPropertyType value) {
        this.begin = value;
    }

    public TimePositionType getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(TimePositionType value) {
        this.endPosition = value;
    }

    public void setEndPosition(Date value) {
        this.endPosition = new TimePositionType(value);
    }

    public void setEndPosition(TimeIndeterminateValueType value) {
        this.endPosition = new TimePositionType(value);
    }

    public void setEndPosition(TimeInstantType value) {
        if (value != null) {
            this.endPosition = value.getTimePosition();
        }
    }

    public TimeInstantPropertyType getEnd() {
        return this.end;
    }

    public void setEnd(TimeInstantPropertyType value) {
        this.end = value;
    }

    @Override
    public Instant getBeginning() {
        if (this.begin != null) {
            return this.begin.getTimeInstant();
        }
        if (this.beginPosition != null) {
            return new TimeInstantType(this.beginPosition);
        }
        return null;
    }

    @Override
    public Instant getEnding() {
        if (this.end != null) {
            return this.end.getTimeInstant();
        }
        if (this.endPosition != null) {
            return new TimeInstantType(this.endPosition);
        }
        return null;
    }

    public long getTime() {
        long e;
        long b;
        if (this.beginPosition != null && this.beginPosition.getDate() != null) {
            b = this.beginPosition.getDate().getTime();
        } else if (this.begin != null && this.begin.getTimeInstant() != null && this.begin.getTimeInstant().getTimePosition() != null && this.begin.getTimeInstant().getTimePosition().getDate() != null) {
            b = this.begin.getTimeInstant().getTimePosition().getDate().getTime();
        } else {
            return -1L;
        }
        if (this.endPosition != null && this.endPosition.getDate() != null) {
            e = this.endPosition.getDate().getTime();
        } else if (this.end != null && this.end.getTimeInstant() != null && this.end.getTimeInstant().getTimePosition() != null && this.end.getTimeInstant().getTimePosition().getDate() != null) {
            e = this.end.getTimeInstant().getTimePosition().getDate().getTime();
        } else {
            return -1L;
        }
        return e - b;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration value) {
        this.duration = value;
    }

    public TimeIntervalLengthType getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(TimeIntervalLengthType value) {
        this.timeInterval = value;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TimePeriodType)) {
            return false;
        }
        TimePeriodType that = (TimePeriodType)object;
        return Utilities.equals(this.begin, that.begin) && Utilities.equals(this.beginPosition, that.beginPosition) && Utilities.equals(this.duration, that.duration) && Utilities.equals(this.endPosition, that.endPosition) && Utilities.equals(this.timeInterval, that.timeInterval) && Utilities.equals(this.end, that.end);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.beginPosition != null ? this.beginPosition.hashCode() : 0);
        hash = 37 * hash + (this.begin != null ? this.begin.hashCode() : 0);
        hash = 37 * hash + (this.endPosition != null ? this.endPosition.hashCode() : 0);
        hash = 37 * hash + (this.end != null ? this.end.hashCode() : 0);
        hash = 37 * hash + (this.duration != null ? this.duration.hashCode() : 0);
        hash = 37 * hash + (this.timeInterval != null ? this.timeInterval.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        char lineSeparator = '\n';
        StringBuilder s = new StringBuilder("TimePeriod:").append(lineSeparator);
        if (this.begin != null) {
            s.append("begin:").append(this.begin).append(lineSeparator);
        }
        if (this.end != null) {
            s.append("end  :").append(this.end).append(lineSeparator);
        }
        if (this.beginPosition != null) {
            s.append("beginPosition :").append(this.beginPosition).append(lineSeparator);
        }
        if (this.endPosition != null) {
            s.append("endPosition   :").append(this.endPosition);
        }
        if (this.duration != null) {
            s.append(lineSeparator).append("duration:").append(this.duration);
        }
        if (this.timeInterval != null) {
            s.append(lineSeparator).append("timeInterval:").append(this.timeInterval).append(lineSeparator);
        }
        return s.toString();
    }
}

