/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.sql;

import java.util.Arrays;
import java.util.Date;
import org.geotoolkit.lang.Static;

public final class TypeMapper
extends Static {
    private static final TypeMapper[] TYPES = new TypeMapper[]{new TypeMapper(Boolean.class, 16, "BOOLEAN"), new TypeMapper(Date.class, 93, "TIMESTAMP"), new TypeMapper(Double.class, 8, "DOUBLE PRECISION"), new TypeMapper(Float.class, 7, "REAL"), new TypeMapper(Long.class, -5, "BIGINT"), new TypeMapper(Integer.class, 4, "INTEGER"), new TypeMapper(Short.class, 5, "SMALLINT"), new TypeMapper(Byte.class, -6, "SMALLINT"), new TypeMapper(Number.class, 3, "DECIMAL")};
    private static final int OFFSET = 6;
    private static final byte[] ITYPES = new byte[100];
    private final Class<?> classe;
    private final int type;
    private final String keyword;

    private TypeMapper(Class<?> clazz, int n, String string) {
        this.classe = clazz;
        this.type = n;
        this.keyword = string;
    }

    public static String keywordFor(Class<?> clazz) {
        if (clazz != null) {
            for (TypeMapper typeMapper : TYPES) {
                if (!typeMapper.classe.isAssignableFrom(clazz)) continue;
                return typeMapper.keyword;
            }
        }
        return null;
    }

    public static Class<?> toJavaType(int n) {
        byte by;
        if ((n += 6) >= 0 && n < ITYPES.length && (by = ITYPES[n]) >= 0 && by < TYPES.length) {
            return TypeMapper.TYPES[by].classe;
        }
        return null;
    }

    static {
        Arrays.fill(ITYPES, (byte)-1);
        for (int n = 0; n < TYPES.length; n = (int)((byte)(n + 1))) {
            TypeMapper.ITYPES[TypeMapper.TYPES[n].type + 6] = n;
        }
    }
}

