/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata;

import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.gui.swing.tree.DefaultTreeModel;
import org.geotoolkit.gui.swing.tree.TreeTableNode;
import org.geotoolkit.gui.swing.tree.Trees;
import org.geotoolkit.metadata.DescriptionMap;
import org.geotoolkit.metadata.KeyNamePolicy;
import org.geotoolkit.metadata.MetadataTreeFormat;
import org.geotoolkit.metadata.NameMap;
import org.geotoolkit.metadata.NullValuePolicy;
import org.geotoolkit.metadata.PropertyAccessor;
import org.geotoolkit.metadata.PropertyMap;
import org.geotoolkit.metadata.RestrictionMap;
import org.geotoolkit.metadata.TypeMap;
import org.geotoolkit.metadata.TypeValuePolicy;
import org.geotoolkit.metadata.UnmodifiableMetadataException;
import org.geotoolkit.metadata.ValueRestriction;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.logging.Logging;

@ThreadSafe
public final class MetadataStandard {
    private static final MetadataStandard[] INSTANCES;
    public static final MetadataStandard ISO_19111;
    public static final MetadataStandard ISO_19115;
    public static final MetadataStandard ISO_19119;
    public static final MetadataStandard ISO_19123;
    private final String name;
    private final String interfacePackage;
    private final String implementationPackage;
    private final String[] prefix;
    private final String[] acronyms;
    private final Map<Class<?>, PropertyAccessor> accessors = new HashMap();
    private final Map<Class<?>, Class<?>> implementations;
    private final ThreadLocal<MetadataTreeFormat> treeBuilders = new ThreadLocal<MetadataTreeFormat>(){

        @Override
        protected MetadataTreeFormat initialValue() {
            return new MetadataTreeFormat(MetadataStandard.this);
        }
    };

    public MetadataStandard(String string) {
        this(string.substring(string.lastIndexOf(46) + 1), string, null, null, null);
    }

    private MetadataStandard(String string, String string2, String string3, String[] stringArray, String[] stringArray2) {
        if (!string2.endsWith(".")) {
            string2 = string2 + '.';
        }
        if (string3 != null) {
            if (!string3.endsWith(".")) {
                string3 = string3 + '.';
            }
            this.implementations = new HashMap();
            if (stringArray == null) {
                throw new NullArgumentException();
            }
        } else {
            this.implementations = null;
        }
        this.interfacePackage = string2;
        this.implementationPackage = string3;
        this.acronyms = stringArray2;
        this.prefix = stringArray;
        this.name = string;
    }

    public static MetadataStandard forClass(Class<?> clazz) {
        String string = clazz.getName();
        for (MetadataStandard metadataStandard : INSTANCES) {
            if (!string.startsWith(metadataStandard.interfacePackage)) continue;
            return metadataStandard;
        }
        for (Class clazz2 : Classes.getAllInterfaces(clazz)) {
            string = clazz2.getName();
            for (MetadataStandard metadataStandard : INSTANCES) {
                if (!string.startsWith(metadataStandard.interfacePackage)) continue;
                return metadataStandard;
            }
        }
        return null;
    }

    private PropertyAccessor getAccessor(Class<?> clazz) throws ClassCastException {
        PropertyAccessor propertyAccessor = this.getAccessorOptional(clazz);
        if (propertyAccessor == null) {
            throw new ClassCastException(Errors.format(226, clazz.getCanonicalName()));
        }
        return propertyAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PropertyAccessor getAccessorOptional(Class<?> clazz) {
        Map<Class<?>, PropertyAccessor> map = this.accessors;
        synchronized (map) {
            Class<?> clazz2;
            PropertyAccessor propertyAccessor = this.accessors.get(clazz);
            if (propertyAccessor == null && (clazz2 = this.getStandardType(clazz)) != null) {
                propertyAccessor = new PropertyAccessor(clazz, clazz2);
                this.accessors.put(clazz, propertyAccessor);
            }
            return propertyAccessor;
        }
    }

    private Class<?> getStandardType(Class<?> clazz) {
        return PropertyAccessor.getStandardType(clazz, this.interfacePackage);
    }

    public boolean isMetadata(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.getName().startsWith(this.interfacePackage)) {
            return true;
        }
        return this.getAccessorOptional(clazz) != null;
    }

    public Class<?> getInterface(Class<?> clazz) throws ClassCastException {
        ArgumentChecks.ensureNonNull("type", clazz);
        if (clazz.getName().startsWith(this.interfacePackage)) {
            return clazz;
        }
        return this.getAccessor(clazz).type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Class<?> getImplementation(Class<?> clazz) {
        String string;
        if (clazz != null && clazz.isInterface() && this.implementations != null && (string = clazz.getName()).startsWith(this.interfacePackage)) {
            Map<Class<?>, Class<?>> map = this.implementations;
            synchronized (map) {
                int n;
                Class<?> clazz2 = this.implementations.get(clazz);
                if (clazz2 != null) {
                    return clazz2 != Void.TYPE ? clazz2 : clazz;
                }
                StringBuilder stringBuilder = new StringBuilder(this.implementationPackage).append(string, this.interfacePackage.length(), string.length());
                if (this.acronyms != null) {
                    for (n = 0; n < this.acronyms.length; n += 2) {
                        String string2 = this.acronyms[n];
                        if (!Strings.endsWith(stringBuilder, string2, false)) continue;
                        stringBuilder.setLength(stringBuilder.length() - string2.length());
                        stringBuilder.append(this.acronyms[n + 1]);
                        break;
                    }
                }
                n = stringBuilder.lastIndexOf(".") + 1;
                int n2 = 0;
                for (String string3 : this.prefix) {
                    string = stringBuilder.replace(n, n + n2, string3).toString();
                    try {
                        clazz2 = Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Logging.recoverableException(MetadataStandard.class, "getImplementation", classNotFoundException);
                        n2 = string3.length();
                        continue;
                    }
                    if (clazz2.isAnnotationPresent(Deprecated.class)) {
                        n2 = string3.length();
                        continue;
                    }
                    this.implementations.put(clazz, clazz2);
                    return clazz2;
                }
                this.implementations.put(clazz, Void.TYPE);
            }
        }
        return clazz;
    }

    public Map<String, Class<?>> asTypeMap(Class<?> clazz, TypeValuePolicy typeValuePolicy, KeyNamePolicy keyNamePolicy) throws ClassCastException {
        ArgumentChecks.ensureNonNull("type", clazz);
        ArgumentChecks.ensureNonNull("typeValues", (Object)typeValuePolicy);
        ArgumentChecks.ensureNonNull("keyNames", (Object)keyNamePolicy);
        clazz = this.getImplementation(clazz);
        return new TypeMap(this.getAccessor(clazz), typeValuePolicy, keyNamePolicy);
    }

    public Map<String, String> asNameMap(Class<?> clazz, KeyNamePolicy keyNamePolicy, KeyNamePolicy keyNamePolicy2) throws ClassCastException {
        ArgumentChecks.ensureNonNull("type", clazz);
        ArgumentChecks.ensureNonNull("typeValues", (Object)keyNamePolicy);
        ArgumentChecks.ensureNonNull("keyNames", (Object)keyNamePolicy2);
        clazz = this.getImplementation(clazz);
        return new NameMap(this.getAccessor(clazz), keyNamePolicy, keyNamePolicy2);
    }

    public Map<String, String> asDescriptionMap(Class<?> clazz, Locale locale, KeyNamePolicy keyNamePolicy) throws ClassCastException {
        ArgumentChecks.ensureNonNull("type", clazz);
        ArgumentChecks.ensureNonNull("locale", locale);
        ArgumentChecks.ensureNonNull("keyNames", (Object)keyNamePolicy);
        clazz = this.getImplementation(clazz);
        try {
            return new DescriptionMap(this.getAccessor(clazz), this.interfacePackage, locale, keyNamePolicy);
        }
        catch (MissingResourceException missingResourceException) {
            Logging.recoverableException(MetadataStandard.class, "asDescriptionMap", missingResourceException);
            return Collections.emptyMap();
        }
    }

    public Map<String, ValueRestriction> asRestrictionMap(Object object, NullValuePolicy nullValuePolicy, KeyNamePolicy keyNamePolicy) throws ClassCastException {
        Class<?> clazz;
        ArgumentChecks.ensureNonNull("metadata", object);
        ArgumentChecks.ensureNonNull("content", (Object)nullValuePolicy);
        ArgumentChecks.ensureNonNull("keyNames", (Object)keyNamePolicy);
        if (object instanceof Class) {
            clazz = this.getImplementation((Class)object);
            object = null;
        } else {
            clazz = object.getClass();
        }
        return new RestrictionMap(this.getAccessor(clazz), object, nullValuePolicy, keyNamePolicy);
    }

    public Map<String, Object> asMap(Object object, NullValuePolicy nullValuePolicy, KeyNamePolicy keyNamePolicy) throws ClassCastException {
        ArgumentChecks.ensureNonNull("metadata", object);
        ArgumentChecks.ensureNonNull("content", (Object)nullValuePolicy);
        ArgumentChecks.ensureNonNull("keyNames", (Object)keyNamePolicy);
        return new PropertyMap(object, this.getAccessor(object.getClass()), nullValuePolicy, keyNamePolicy);
    }

    public Map<String, Object> asMap(Object object) throws ClassCastException {
        return this.asMap(object, NullValuePolicy.NON_EMPTY, KeyNamePolicy.JAVABEANS_PROPERTY);
    }

    public TreeTableNode asTreeTable(Object object) throws ClassCastException {
        return this.treeBuilders.get().asTreeTable(object);
    }

    public TreeModel asTree(Object object) throws ClassCastException {
        MetadataTreeFormat metadataTreeFormat = this.treeBuilders.get();
        return new DefaultTreeModel(metadataTreeFormat.asTree(object), true);
    }

    final void parse(TreeModel treeModel, Object object) throws ParseException {
        this.treeBuilders.get().parse((TreeNode)treeModel.getRoot(), object);
    }

    final boolean isModifiable(Class<?> clazz) throws ClassCastException {
        return this.getAccessor(clazz).isModifiable();
    }

    final void freeze(Object object) throws ClassCastException {
        this.getAccessor(object.getClass()).freeze(object);
    }

    public void shallowCopy(Object object, Object object2, boolean bl) throws ClassCastException, UnmodifiableMetadataException {
        ArgumentChecks.ensureNonNull("target", object2);
        PropertyAccessor propertyAccessor = this.getAccessor(object2.getClass());
        if (!propertyAccessor.type.isInstance(object)) {
            ArgumentChecks.ensureNonNull("source", object);
            throw new ClassCastException(Errors.format(256, "source", object.getClass(), propertyAccessor.type));
        }
        if (!propertyAccessor.shallowCopy(object, object2, bl)) {
            throw new UnmodifiableMetadataException(Errors.format(230));
        }
    }

    public boolean shallowEquals(Object object, Object object2, ComparisonMode comparisonMode, boolean bl) throws ClassCastException {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        PropertyAccessor propertyAccessor = this.getAccessor(object.getClass());
        if (propertyAccessor.type != this.getStandardType(object2.getClass())) {
            return false;
        }
        return propertyAccessor.shallowEquals(object, object2, comparisonMode, bl);
    }

    public int hashCode(Object object) throws ClassCastException {
        return this.getAccessor(object.getClass()).hashCode(object);
    }

    public String toString(Object object) throws ClassCastException {
        return Trees.toString(this.asTreeTable(object));
    }

    public String toString() {
        return Classes.getShortClassName(this) + '[' + this.name + ']';
    }

    static {
        String[] stringArray = new String[]{"Default", "Abstract"};
        String[] stringArray2 = new String[]{"CoordinateSystem", "CS", "CoordinateReferenceSystem", "CRS"};
        ISO_19111 = new MetadataStandard("ISO 19111", "org.opengis.referencing.", "org.geotoolkit.referencing.", stringArray, stringArray2);
        ISO_19115 = new MetadataStandard("ISO 19115", "org.opengis.metadata.", "org.geotoolkit.metadata.iso.", stringArray, null);
        ISO_19119 = new MetadataStandard("ISO 19119", "org.opengis.service.", null, null, null);
        ISO_19123 = new MetadataStandard("ISO 19123", "org.opengis.coverage.", null, null, null);
        INSTANCES = new MetadataStandard[]{ISO_19111, ISO_19115, ISO_19119, ISO_19123};
    }
}

